package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.VinculoHabilidadeColaboradorDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @since 27.01.2016 
 * @author joao.morais
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class VinculoHabilidadeColaboradorDao extends CrudDaoDefaultImpl {

	public VinculoHabilidadeColaboradorDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {
		List ordem = new ArrayList();
		ordem.add(new Order("idHabilidade"));
		return super.find(obj, ordem);
	}

	@Override
	public Class getBean() {
		return VinculoHabilidadeColaboradorDTO.class;
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDVINCULOCOLABORADOR", "IdVinculoColaborador", true, true, false, false));
		listFields.add(new Field("IDEMPREGADO", "IdEmpregado", false, false, false, false));
		listFields.add(new Field("IDHABILIDADE", "idHabilidade", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "VINCULOHABILIDADE";
	}
	

	@SuppressWarnings("unchecked")
	public Collection<VinculoHabilidadeColaboradorDTO> findByIdHabilidade(final Integer idHabilidade) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idHabilidade", idHabilidade));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();
		
		return this.findByCondition(condicao, ordenacao);
	}
	
	public void deleteAllVinculosHabilidade(final Integer idHabilidade) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idHabilidade", idHabilidade));
		super.deleteByCondition(condicao);
	}
	
}