package br.com.centralit.citcorpore.metainfo.util;

import java.io.IOException;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * Converter JSON utilizando Jackson
 * 
 * @created 23/07/2014
 * @authors Bruno César Ribeiro e Silva - <a href="mailto:bruno@brunocesar.com">bruno@brunocesar.com</a>
 */
public final class JSONConverter {

	private JSONConverter() {
	}

	private static final ObjectMapper objectMapper = new ObjectMapper();

	static {
		objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		objectMapper.setSerializationInclusion(Include.NON_NULL);
		objectMapper.setSerializationInclusion(Include.NON_EMPTY);
		objectMapper.setSerializationInclusion(Include.NON_DEFAULT);
	}

	public static <T> T fromJson(final String json, final Class<T> clazz) {
		try {
			return objectMapper.readValue(json, clazz);
		} catch (final IOException e) {
			throw new IllegalArgumentException("Erro ao fazer o parse do json " + json, e);
		}
	}

	/**
	 * Desserializar uma String JSON para um lista.
	 * Use da seguinte maneira: 
	 * Set<Seu_TIPO> lista = JSONConverter.fromJson(Seu_Json, new TypeReference<Set<Seu_Tipo>>() {});
	 * @author cristian.guedes
	 * @param json
	 * @param clazzes
	 * @return
	 * @throws IOException 
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 */
	public static <T> T fromJson(final String json, final TypeReference<T> clazzes) throws JsonParseException, JsonMappingException, IOException {
//		try {
			return objectMapper.readValue(json, clazzes);
//		} catch (final IOException e) {
//			throw new IllegalArgumentException("Erro ao fazer o parse do json " + json, e);
//		}
	}
	
	
	
	public static String toJson(final Object object) {
		try {
			return objectMapper.writeValueAsString(object);
		} catch (final IOException e) {
			throw new IllegalArgumentException("Erro ao fazer o parse do objeto" + object, e);
		}
	}
	
 
}
