package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoHistoricoDTO;
import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoSLADTO;
import br.com.centralit.citcorpore.bean.PrioridadeAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeServicoUnidadeDTO;
import br.com.centralit.citcorpore.bean.PrioridadeServicoUsuarioDTO;
import br.com.centralit.citcorpore.bean.ResultadosEsperadosDTO;
import br.com.centralit.citcorpore.bean.RevisarSlaDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SlaRequisitoSlaDTO;
import br.com.centralit.citcorpore.bean.TempoAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoEmpregadoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoUnidadeDTO;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoHistoricoDao;
import br.com.centralit.citcorpore.integracao.AcordoServicoContratoDao;
import br.com.centralit.citcorpore.integracao.BaseConhecimentoSLADAO;
import br.com.centralit.citcorpore.integracao.PrioridadeAcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.PrioridadeServicoUnidadeDao;
import br.com.centralit.citcorpore.integracao.PrioridadeServicoUsuarioDao;
import br.com.centralit.citcorpore.integracao.ResultadosEsperadosDAO;
import br.com.centralit.citcorpore.integracao.RevisarSlaDao;
import br.com.centralit.citcorpore.integracao.ServicoContratoDao;
import br.com.centralit.citcorpore.integracao.ServicoDao;
import br.com.centralit.citcorpore.integracao.SlaRequisitoSLADao;
import br.com.centralit.citcorpore.integracao.TempoAcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.TempoAtendimentoEmpregadoDao;
import br.com.centralit.citcorpore.integracao.TempoAtendimentoUnidadeDao;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class AcordoNivelServicoServiceEjb extends CrudServiceImpl implements AcordoNivelServicoService {

    private AcordoNivelServicoDao dao;
	private AcordoNivelServicoHistoricoDao acordoNivelServicoHistoricoDao;

    @Override
    protected AcordoNivelServicoDao getDao() {
        if (dao == null) {
            dao = new AcordoNivelServicoDao();
        }
        return dao;
    }

    @Override
    public AcordoNivelServicoDTO findAtivoByIdServicoContrato(final Integer idServicoContrato, final String tipo) throws Exception {
        return this.getDao().findAtivoByIdServicoContrato(idServicoContrato, tipo);
    }
    
    @Override
    public AcordoNivelServicoDTO findTempoAtendimentoByIdServicoContratoAndIdEmpregado(Integer idServicoContrato, Integer idEmpregado) throws Exception {
    	return this.getDao().findTempoAtendimentoByIdServicoContratoAndIdEmpregado(idServicoContrato, idEmpregado);
    }

    @Override
    public void copiarSLA(final Integer idAcordoNivelServico, final Integer idServicoContratoOrigem, final Integer[] idServicoCopiarPara) throws Exception {

        final TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
        final PrioridadeServicoUnidadeDao prioridadeServicoUnidadeDao = new PrioridadeServicoUnidadeDao();
        final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

        try {

            tc.start();

            this.getDao().setTransactionControler(tc);
            tempoAcordoNivelServicoDao.setTransactionControler(tc);
            prioridadeServicoUnidadeDao.setTransactionControler(tc);

            AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
            acordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
            acordoNivelServicoDTO = (AcordoNivelServicoDTO) this.getDao().restore(acordoNivelServicoDTO);

            final Collection colPrioridadesUnidades = prioridadeServicoUnidadeDao.findByIdServicoContrato(idServicoContratoOrigem);

            for (final Integer element : idServicoCopiarPara) {
                acordoNivelServicoDTO.setIdAcordoNivelServico(null);
                acordoNivelServicoDTO.setIdServicoContrato(element);

                acordoNivelServicoDTO = (AcordoNivelServicoDTO) this.getDao().create(acordoNivelServicoDTO);
                if (acordoNivelServicoDTO.getTipo().equalsIgnoreCase("T")) { // TEMPO
                    final Collection colTempos = tempoAcordoNivelServicoDao.findByIdAcordo(idAcordoNivelServico);
                    if (colTempos != null) {
                        for (final Iterator it = colTempos.iterator(); it.hasNext();) {
                            final TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) it.next();
                            tempoAcordoNivelServicoDTO.setIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
                            try {
                                tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
                            } catch (final Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (colPrioridadesUnidades != null) {
                        for (final Iterator it = colPrioridadesUnidades.iterator(); it.hasNext();) {
                            final PrioridadeServicoUnidadeDTO prioridadeServicoUnidadeDTO = (PrioridadeServicoUnidadeDTO) it.next();
                            prioridadeServicoUnidadeDTO.setIdServicoContrato(element);
                            try {
                                prioridadeServicoUnidadeDao.delete(prioridadeServicoUnidadeDTO);
                            } catch (final Exception e) {
								e.printStackTrace(); // Deixa passar o erro, pos
														// no influencia.
                            }
                            try {
                                prioridadeServicoUnidadeDao.create(prioridadeServicoUnidadeDTO);
                            } catch (final Exception e) {
								e.printStackTrace(); // Deixa passar o erro, pos
														// no influencia.
                            }
                        }
                    }
                }
            }
            tc.commit();

        } catch (final Exception e) {
            this.rollbackTransaction(tc, e);
        } finally {
            try {
                tc.close();
            } catch (final PersistenceException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }
    }

    @Override
    public Collection<AcordoNivelServicoDTO> findByIdServicoContrato(final Integer parm) throws Exception {
        try {
            return this.getDao().findByIdServicoContrato(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection consultaPorIdServicoContrato(final Integer parm) throws Exception {
        final ResultadosEsperadosDAO dao = new ResultadosEsperadosDAO();
        final Collection colRetorno = new ArrayList<>();
        try {
            final Collection col = dao.findByIdServicoContrato(parm);
            if (col != null && col.size() > 0) {
                for (final Iterator it = col.iterator(); it.hasNext();) {
                    final ResultadosEsperadosDTO resultados = (ResultadosEsperadosDTO) it.next();
                    if (resultados.getDeleted() == null || resultados.getDeleted().equalsIgnoreCase("N") || resultados.getDeleted().trim().equals("")) {
                        if (!this.consultaAcordoNivelServicoAtivo(resultados)) {
                            colRetorno.add(resultados);
                        }
                    }
                }
            }
            return colRetorno;
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    private boolean consultaAcordoNivelServicoAtivo(final ResultadosEsperadosDTO resultadosEsperadosDTO) throws ServiceException {
        AcordoNivelServicoDTO acordoNivelServicoContratoDTO = new AcordoNivelServicoDTO();
        acordoNivelServicoContratoDTO.setIdAcordoNivelServico(resultadosEsperadosDTO.getIdAcordoNivelServico());
        try {
            acordoNivelServicoContratoDTO = (AcordoNivelServicoDTO) this.getDao().restore(acordoNivelServicoContratoDTO);
            final String situacao = acordoNivelServicoContratoDTO.getSituacao();
            if (!situacao.equalsIgnoreCase("A")) {
                return true;
            }
            return false;
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdServicoContrato(final Integer parm) throws Exception {
        try {
            this.getDao().deleteByIdServicoContrato(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection findByIdPrioridadePadrao(final Integer parm) throws Exception {
        try {
            return this.getDao().findByIdPrioridadePadrao(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdPrioridadePadrao(final Integer parm) throws Exception {
        try {
            this.getDao().deleteByIdPrioridadePadrao(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    /**
	 * Mtodo para retornar os servios que possuem o SLA selecionado j
	 * copiado, para ser tratado evitando duplicao de SLA.
	 *
	 * @param titulo
	 *            do SLA selecionado
	 * @return retorna os servios que possuem o SLA selecionado
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
    @Override
    public List<ServicoContratoDTO> buscaServicosComContrato(final String tituloSla) throws Exception {
        try {
            return this.getDao().buscaServicosComContrato(tituloSla);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    /**
	 * Mtodo para verificar se existe cadastrado um cadastro o mesmo nome.
	 *
	 * @param HashMap
	 *            mapFields
	 * @return true se o nome existir e false se no existir
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
    @Override
    public boolean verificaSeNomeExiste(final HashMap mapFields) throws Exception {
        final String tituloSLA = (String) mapFields.get("TITULOSLA");
        try {
            return this.getDao().verificaSeNomeExiste(tituloSLA);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<AcordoNivelServicoDTO> findAcordosSemVinculacaoDireta() throws Exception {
        try {
            return this.getDao().findAcordosSemVinculacaoDireta();
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public AcordoNivelServicoDTO create(AcordoNivelServicoDTO acordoNivelServicoDTO, final AcordoNivelServicoHistoricoDTO acordoNivelServicoHistoricoDTO) throws ServiceException,
            LogicException {

        final TransactionControler transaction = new TransactionControlerImpl(this.getDao().getAliasDB());

        final TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
        final PrioridadeAcordoNivelServicoDao prioridadeAcordoNivelServicoDao = new PrioridadeAcordoNivelServicoDao();
        final PrioridadeServicoUsuarioDao prioridadeServicoUsuarioDao = new PrioridadeServicoUsuarioDao();
        final SlaRequisitoSLADao slaRequisitoSlaDao = new SlaRequisitoSLADao();
        final AcordoNivelServicoHistoricoDao acordoNivelServicoHistoricoDao = new AcordoNivelServicoHistoricoDao();
        final RevisarSlaDao revisarSlaDao = new RevisarSlaDao();
		final BaseConhecimentoSLADAO baseConhecimentoSLADAO = new BaseConhecimentoSLADAO();

        Integer idAcordoNivelServico = 0;

        try {
            this.getDao().setTransactionControler(transaction);
            tempoAcordoNivelServicoDao.setTransactionControler(transaction);
            prioridadeAcordoNivelServicoDao.setTransactionControler(transaction);
            prioridadeServicoUsuarioDao.setTransactionControler(transaction);
            slaRequisitoSlaDao.setTransactionControler(transaction);
            acordoNivelServicoHistoricoDao.setTransactionControler(transaction);
            revisarSlaDao.setTransactionControler(transaction);
			baseConhecimentoSLADAO.setTransactionControler(transaction);

            transaction.start();

            acordoNivelServicoDTO = (AcordoNivelServicoDTO) this.getDao().create(acordoNivelServicoDTO);
            acordoNivelServicoDTO.setIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());

            if (acordoNivelServicoDTO.getIdAcordoNivelServico() != null) {
                idAcordoNivelServico = acordoNivelServicoDTO.getIdAcordoNivelServico();
            }

            for (int i = 1; i <= 5; i++) {
                final TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = new TempoAcordoNivelServicoDTO();
                tempoAcordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                tempoAcordoNivelServicoDTO.setIdFase(1);
                tempoAcordoNivelServicoDTO.setIdPrioridade(i);
                tempoAcordoNivelServicoDTO.setTempoHH(acordoNivelServicoDTO.getHhCaptura()[i - 1]);
                tempoAcordoNivelServicoDTO.setTempoMM(acordoNivelServicoDTO.getMmCaptura()[i - 1]);
                tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
            }
            for (int i = 1; i <= 5; i++) {
                final TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = new TempoAcordoNivelServicoDTO();
                tempoAcordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                tempoAcordoNivelServicoDTO.setIdFase(2);
                tempoAcordoNivelServicoDTO.setIdPrioridade(i);
                tempoAcordoNivelServicoDTO.setTempoHH(acordoNivelServicoDTO.getHhResolucao()[i - 1]);
                tempoAcordoNivelServicoDTO.setTempoMM(acordoNivelServicoDTO.getMmResolucao()[i - 1]);
                tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
            }

            final List<PrioridadeAcordoNivelServicoDTO> colUnidades = acordoNivelServicoDTO.getListaPrioridadeUnidade();
            if (colUnidades != null && colUnidades.size() > 0) {
                for (final PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoDTO : colUnidades) {
                    prioridadeAcordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    prioridadeAcordoNivelServicoDTO.setDataInicio(UtilDatas.getDataAtual());
                    prioridadeAcordoNivelServicoDao.create(prioridadeAcordoNivelServicoDTO);
                }
            }

            final List<PrioridadeServicoUsuarioDTO> colUsuarios = acordoNivelServicoDTO.getListaPrioridadeUsuario();
            if (colUsuarios != null && colUsuarios.size() > 0) {
                for (final PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioDTO : colUsuarios) {
                    prioridadeServicoUsuarioDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    prioridadeServicoUsuarioDTO.setDataInicio(UtilDatas.getDataAtual());
                    prioridadeServicoUsuarioDao.create(prioridadeServicoUsuarioDTO);
                }
            }

            final List<SlaRequisitoSlaDTO> colSlaRequisitoSla = acordoNivelServicoDTO.getListaSlaRequisitoSlaDTO();
            if (colSlaRequisitoSla != null && colSlaRequisitoSla.size() > 0) {
                for (final SlaRequisitoSlaDTO slaRequisitoSlaDTO : colSlaRequisitoSla) {
                    slaRequisitoSlaDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    slaRequisitoSlaDTO.setDataUltModificacao(UtilDatas.getDataAtual());
                    slaRequisitoSlaDao.create(slaRequisitoSlaDTO);
                }
            }

            final List<RevisarSlaDTO> colRevisarSla = acordoNivelServicoDTO.getListaRevisarSlaDTO();
            if (colRevisarSla != null && colRevisarSla.size() > 0) {
                for (final RevisarSlaDTO revisarSlaDTO : colRevisarSla) {
                    revisarSlaDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    revisarSlaDao.create(revisarSlaDTO);
                }
            }

			final List<BaseConhecimentoSLADTO> colBaseConhecimentoSLA = acordoNivelServicoDTO.getListaBaseConhecimentoSLADTO();
			if (colBaseConhecimentoSLA != null && colBaseConhecimentoSLA.size() > 0) {
				for (final BaseConhecimentoSLADTO baseConhecimentoSLADTO : colBaseConhecimentoSLA) {
					baseConhecimentoSLADTO.setIdAcordoNivelServico(idAcordoNivelServico);
					baseConhecimentoSLADTO.setDataInicio(UtilDatas.getDataAtual());

					baseConhecimentoSLADAO.create(baseConhecimentoSLADTO);
				}
			}

            final AcordoNivelServicoDTO acordoNivelServicoAux = new AcordoNivelServicoDTO();

            acordoNivelServicoAux.setTempoAuto(acordoNivelServicoDTO.getTempoAuto());
            acordoNivelServicoAux.setIdPrioridadeAuto1(acordoNivelServicoDTO.getIdPrioridadeAuto1());
            acordoNivelServicoAux.setIdGrupo1(acordoNivelServicoDTO.getIdGrupo1());
            acordoNivelServicoAux.setIdAcordoNivelServico(idAcordoNivelServico);
            this.getDao().updateTemposAcoes(acordoNivelServicoAux);

            acordoNivelServicoHistoricoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
            acordoNivelServicoHistoricoDao.create(acordoNivelServicoHistoricoDTO);

            transaction.commit();

        } catch (final Exception e) {
            e.printStackTrace();
            this.rollbackTransaction(transaction, e);
            throw new ServiceException(e.getMessage());
        } finally {
            try {
                transaction.close();
            } catch (final PersistenceException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        return acordoNivelServicoDTO;

    }

    @Override
    public AcordoNivelServicoDTO update(final AcordoNivelServicoDTO acordoNivelServicoDTO, final AcordoNivelServicoHistoricoDTO acordoNivelServicoHistoricoDTO)
            throws ServiceException, LogicException {

        final TransactionControler transaction = new TransactionControlerImpl(this.getDao().getAliasDB());

        final TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
        final PrioridadeAcordoNivelServicoDao prioridadeAcordoNivelServicoDao = new PrioridadeAcordoNivelServicoDao();
        final PrioridadeServicoUsuarioDao prioridadeServicoUsuarioDao = new PrioridadeServicoUsuarioDao();
        final SlaRequisitoSLADao slaRequisitoSlaDao = new SlaRequisitoSLADao();
        final AcordoNivelServicoHistoricoDao acordoNivelServicoHistoricoDao = new AcordoNivelServicoHistoricoDao();
        final RevisarSlaDao revisarSlaDao = new RevisarSlaDao();
		final BaseConhecimentoSLADAO baseConhecimentoSLADAO = new BaseConhecimentoSLADAO();

        final Integer idAcordoNivelServico = acordoNivelServicoDTO.getIdAcordoNivelServico();

        try {
            this.getDao().setTransactionControler(transaction);
            tempoAcordoNivelServicoDao.setTransactionControler(transaction);
            prioridadeAcordoNivelServicoDao.setTransactionControler(transaction);
            prioridadeServicoUsuarioDao.setTransactionControler(transaction);
            slaRequisitoSlaDao.setTransactionControler(transaction);
            acordoNivelServicoHistoricoDao.setTransactionControler(transaction);
            revisarSlaDao.setTransactionControler(transaction);
			baseConhecimentoSLADAO.setTransactionControler(transaction);

            
            transaction.start();

            this.getDao().updateNotNull(acordoNivelServicoDTO);

            tempoAcordoNivelServicoDao.deleteByIdAcordo(idAcordoNivelServico);

            for (int i = 1; i <= 5; i++) {
                final TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = new TempoAcordoNivelServicoDTO();
                tempoAcordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                tempoAcordoNivelServicoDTO.setIdFase(1);
                tempoAcordoNivelServicoDTO.setIdPrioridade(i);
                tempoAcordoNivelServicoDTO.setTempoHH(acordoNivelServicoDTO.getHhCaptura()[i - 1]);
                tempoAcordoNivelServicoDTO.setTempoMM(acordoNivelServicoDTO.getMmCaptura()[i - 1]);
                tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
            }
            for (int i = 1; i <= 5; i++) {
                final TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = new TempoAcordoNivelServicoDTO();
                tempoAcordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                tempoAcordoNivelServicoDTO.setIdFase(2);
                tempoAcordoNivelServicoDTO.setIdPrioridade(i);
                tempoAcordoNivelServicoDTO.setTempoHH(acordoNivelServicoDTO.getHhResolucao()[i - 1]);
                tempoAcordoNivelServicoDTO.setTempoMM(acordoNivelServicoDTO.getMmResolucao()[i - 1]);
                tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
            }

            // Atualiza prioridade unidades
            final List<PrioridadeAcordoNivelServicoDTO> listaPrioridadeUnidadeAtual = (List<PrioridadeAcordoNivelServicoDTO>) prioridadeAcordoNivelServicoDao
                    .findByIdAcordoNivelServico(idAcordoNivelServico);
            if (listaPrioridadeUnidadeAtual != null && listaPrioridadeUnidadeAtual.size() > 0) {
                for (final PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoDTO : listaPrioridadeUnidadeAtual) {
                    if (prioridadeAcordoNivelServicoDTO.getDataFim() == null) {
                        prioridadeAcordoNivelServicoDTO.setDataFim(UtilDatas.getDataAtual());
                        prioridadeAcordoNivelServicoDao.update(prioridadeAcordoNivelServicoDTO);
                    }
                }
            }
            final List<PrioridadeAcordoNivelServicoDTO> colUnidades = acordoNivelServicoDTO.getListaPrioridadeUnidade();
            if (colUnidades != null && colUnidades.size() > 0) {
                for (final PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoDTO : colUnidades) {
                    prioridadeAcordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    prioridadeAcordoNivelServicoDTO.setDataInicio(UtilDatas.getDataAtual());
                    prioridadeAcordoNivelServicoDTO.setDataFim(null);
                    final PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoAux = (PrioridadeAcordoNivelServicoDTO) prioridadeAcordoNivelServicoDao
                            .restore(prioridadeAcordoNivelServicoDTO);
                    if (prioridadeAcordoNivelServicoAux != null) {
                        prioridadeAcordoNivelServicoDao.update(prioridadeAcordoNivelServicoDTO);
                    } else {
                        prioridadeAcordoNivelServicoDao.create(prioridadeAcordoNivelServicoDTO);
                    }
                }
            }

			// Atualiza prioridade usurios
            final List<PrioridadeServicoUsuarioDTO> listaPrioridadeServicoUsuarioAtual = (List<PrioridadeServicoUsuarioDTO>) prioridadeServicoUsuarioDao
                    .findByIdAcordoNivelServico(idAcordoNivelServico);
            if (listaPrioridadeServicoUsuarioAtual != null && listaPrioridadeServicoUsuarioAtual.size() > 0) {
                for (final PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioDTO : listaPrioridadeServicoUsuarioAtual) {
                    if (prioridadeServicoUsuarioDTO.getDataFim() == null) {
                        prioridadeServicoUsuarioDTO.setDataFim(UtilDatas.getDataAtual());
                        prioridadeServicoUsuarioDao.update(prioridadeServicoUsuarioDTO);
                    }
                }
            }
            final List<PrioridadeServicoUsuarioDTO> colUsuarios = acordoNivelServicoDTO.getListaPrioridadeUsuario();
            if (colUsuarios != null && colUsuarios.size() > 0) {
                for (final PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioDTO : colUsuarios) {
                    prioridadeServicoUsuarioDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    prioridadeServicoUsuarioDTO.setDataInicio(UtilDatas.getDataAtual());
                    prioridadeServicoUsuarioDTO.setDataFim(null);
                    final PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioAux = (PrioridadeServicoUsuarioDTO) prioridadeServicoUsuarioDao.restore(prioridadeServicoUsuarioDTO);
                    if (prioridadeServicoUsuarioAux != null) {
                        prioridadeServicoUsuarioDao.update(prioridadeServicoUsuarioDTO);
                    } else {
                        prioridadeServicoUsuarioDao.create(prioridadeServicoUsuarioDTO);
                    }
                }
            }

            // Atualiza requisitoSla
            slaRequisitoSlaDao.deleteByIdAcordoNivelServico(idAcordoNivelServico);
            final List<SlaRequisitoSlaDTO> colSlaRequisitoSla = acordoNivelServicoDTO.getListaSlaRequisitoSlaDTO();
            if (colSlaRequisitoSla != null && colSlaRequisitoSla.size() > 0) {
                for (final SlaRequisitoSlaDTO slaRequisitoSlaDTO : colSlaRequisitoSla) {
                    slaRequisitoSlaDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    slaRequisitoSlaDTO.setDataUltModificacao(UtilDatas.getDataAtual());
                    slaRequisitoSlaDao.create(slaRequisitoSlaDTO);
                }
            }

            // Atualiza revisarSla
            revisarSlaDao.deleteByIdAcordoNivelServico(idAcordoNivelServico);
            final List<RevisarSlaDTO> colRevisarSla = acordoNivelServicoDTO.getListaRevisarSlaDTO();
            if (colRevisarSla != null && colRevisarSla.size() > 0) {
                for (final RevisarSlaDTO revisarSlaDTO : colRevisarSla) {
                    revisarSlaDTO.setIdAcordoNivelServico(idAcordoNivelServico);
                    revisarSlaDao.create(revisarSlaDTO);
                }
            }

			baseConhecimentoSLADAO.deleteByIdAcordoNivelServico(idAcordoNivelServico);
			final List<BaseConhecimentoSLADTO> baseConhecimentoSLA = acordoNivelServicoDTO.getListaBaseConhecimentoSLADTO();
			if (baseConhecimentoSLA != null && baseConhecimentoSLA.size() > 0) {
				for (final BaseConhecimentoSLADTO baseConhecimentoSLADTO : baseConhecimentoSLA) {
					baseConhecimentoSLADTO.setIdAcordoNivelServico(idAcordoNivelServico);
					baseConhecimentoSLADTO.setDataInicio(UtilDatas.getDataAtual());

					baseConhecimentoSLADAO.create(baseConhecimentoSLADTO);
				}
			}

            final AcordoNivelServicoDTO acordoNivelServicoAux = new AcordoNivelServicoDTO();

            acordoNivelServicoAux.setTempoAuto(acordoNivelServicoDTO.getTempoAuto());
            acordoNivelServicoAux.setIdPrioridadeAuto1(acordoNivelServicoDTO.getIdPrioridadeAuto1());
            acordoNivelServicoAux.setIdGrupo1(acordoNivelServicoDTO.getIdGrupo1());
            acordoNivelServicoAux.setIdAcordoNivelServico(idAcordoNivelServico);

            this.getDao().updateTemposAcoes(acordoNivelServicoAux);

            acordoNivelServicoHistoricoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
            acordoNivelServicoHistoricoDao.create(acordoNivelServicoHistoricoDTO);

            transaction.commit();

        } catch (final Exception e) {
            e.printStackTrace();
            this.rollbackTransaction(transaction, e);
            throw new ServiceException(e.getMessage());
        } finally {
            try {
                transaction.close();
            } catch (final PersistenceException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        return acordoNivelServicoDTO;
    }

    @Override
    public void excluir(final AcordoNivelServicoDTO acordoNivelServicoDTO) throws Exception {
        final TransactionControler transaction = new TransactionControlerImpl(this.getDao().getAliasDB());

        final TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
        final PrioridadeAcordoNivelServicoDao prioridadeAcordoNivelServicoDao = new PrioridadeAcordoNivelServicoDao();
        final PrioridadeServicoUsuarioDao prioridadeServicoUsuarioDao = new PrioridadeServicoUsuarioDao();
        final SlaRequisitoSLADao slaRequisitoSlaDao = new SlaRequisitoSLADao();
        final AcordoNivelServicoHistoricoDao acordoNivelServicoHistoricoDao = new AcordoNivelServicoHistoricoDao();
        final RevisarSlaDao revisarSlaDao = new RevisarSlaDao();
		final BaseConhecimentoSLADAO baseConhecimentoSLADAO = new BaseConhecimentoSLADAO();

        final Integer idAcordoNivelServico = acordoNivelServicoDTO.getIdAcordoNivelServico();

        try {
            this.getDao().setTransactionControler(transaction);
            tempoAcordoNivelServicoDao.setTransactionControler(transaction);
            prioridadeAcordoNivelServicoDao.setTransactionControler(transaction);
            prioridadeServicoUsuarioDao.setTransactionControler(transaction);
            slaRequisitoSlaDao.setTransactionControler(transaction);
            acordoNivelServicoHistoricoDao.setTransactionControler(transaction);
            revisarSlaDao.setTransactionControler(transaction);
			baseConhecimentoSLADAO.setTransactionControler(transaction);

            transaction.start();

            acordoNivelServicoDTO.setDeleted("y");
            this.getDao().updateNotNull(acordoNivelServicoDTO);

            tempoAcordoNivelServicoDao.deleteByIdAcordo(idAcordoNivelServico);

            final List<PrioridadeAcordoNivelServicoDTO> listaPrioridadeUnidadeAtual = (List<PrioridadeAcordoNivelServicoDTO>) prioridadeAcordoNivelServicoDao
                    .findByIdAcordoNivelServico(idAcordoNivelServico);
            if (listaPrioridadeUnidadeAtual != null && listaPrioridadeUnidadeAtual.size() > 0) {
                for (final PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoDTO : listaPrioridadeUnidadeAtual) {
                    if (prioridadeAcordoNivelServicoDTO.getDataFim() == null) {
                        prioridadeAcordoNivelServicoDTO.setDataFim(UtilDatas.getDataAtual());
                        prioridadeAcordoNivelServicoDao.update(prioridadeAcordoNivelServicoDTO);
                    }
                }
            }

            final List<PrioridadeServicoUsuarioDTO> listaPrioridadeServicoUsuarioAtual = (List<PrioridadeServicoUsuarioDTO>) prioridadeServicoUsuarioDao
                    .findByIdAcordoNivelServico(idAcordoNivelServico);
            if (listaPrioridadeServicoUsuarioAtual != null && listaPrioridadeServicoUsuarioAtual.size() > 0) {
                for (final PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioDTO : listaPrioridadeServicoUsuarioAtual) {
                    if (prioridadeServicoUsuarioDTO.getDataFim() == null) {
                        prioridadeServicoUsuarioDTO.setDataFim(UtilDatas.getDataAtual());
                        prioridadeServicoUsuarioDao.update(prioridadeServicoUsuarioDTO);
                    }
                }
            }

            slaRequisitoSlaDao.deleteByIdAcordoNivelServico(idAcordoNivelServico);

            revisarSlaDao.deleteByIdAcordoNivelServico(idAcordoNivelServico);
			baseConhecimentoSLADAO.deleteByIdAcordoNivelServico(idAcordoNivelServico);

            transaction.commit();

        } catch (final Exception e) {
            e.printStackTrace();
            this.rollbackTransaction(transaction, e);
            throw new ServiceException(e.getMessage());
        } finally {
            try {
                transaction.close();
            } catch (final PersistenceException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<AcordoNivelServicoDTO> findIdEmailByIdSolicitacaoServico(final Integer idSolicitacaoServico) throws Exception {
        try {
            return this.getDao().findIdEmailByIdSolicitacaoServico(idSolicitacaoServico);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String verificaIdAcordoNivelServico(final HashMap mapFields) throws Exception {
        List<AcordoNivelServicoDTO> listaAcordoNivelServicoDTO = null;
        String id = mapFields.get("IDACORDONIVELSERVICO").toString().trim();
        if (id == null || id.equals("")) {
            id = "0";
        }
        if (UtilStrings.soContemNumeros(id)) {
            final Integer idAcordoNivelServico = Integer.parseInt(id);
            listaAcordoNivelServicoDTO = this.getDao().findByIdAcordoSemVinculacaoDireta(idAcordoNivelServico);
        } else {
            listaAcordoNivelServicoDTO = this.getDao().findByTituloSLA(id);
        }
        if (listaAcordoNivelServicoDTO != null && listaAcordoNivelServicoDTO.size() > 0) {
            return String.valueOf(listaAcordoNivelServicoDTO.get(0).getIdAcordoNivelServico());
        }
        return "0";
    }

    @Override
	public void addAcordoNivelServicoMultiNivel(AcordoNivelServicoDTO acordoNivelServicoDTO, Set<Integer> listIdServicoContrato, List<TempoAtendimentoUnidadeDTO> listaTempoAtendimentoUnidade,
			List<TempoAtendimentoEmpregadoDTO> listaTempoAtendimentoEmpregado, AcordoNivelServicoHistoricoDTO acordoNivelServicoHistoricoDTO) throws Exception {
    	TempoAtendimentoUnidadeDao tempoAtendimentoUnidadeDao = new TempoAtendimentoUnidadeDao();
    	TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		this.getDao().setTransactionControler(tc);
		this.getAcordoNivelServicoHistoricoDao().setTransactionControler(tc);
		tempoAtendimentoUnidadeDao.setTransactionControler(tc);
		tc.start();
		try {
			if (acordoNivelServicoDTO.getIdAcordoNivelServico() == null){
				acordoNivelServicoDTO.setCriadoEm(UtilDatas.getDataHoraAtual());
				acordoNivelServicoDTO = (AcordoNivelServicoDTO) this.getDao().create(acordoNivelServicoDTO);
			} else {
				this.getDao().updateNotNull(acordoNivelServicoDTO);
				deleteAcordos(acordoNivelServicoDTO, tc);
			}

			acordoNivelServicoHistoricoDTO.setIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
			this.getAcordoNivelServicoHistoricoDao().create(acordoNivelServicoHistoricoDTO);

			if (acordoNivelServicoDTO.getIdContrato() != null) { // Cliente
				addListAcordoServicoContrato(acordoNivelServicoDTO, listIdServicoContrato, tc);
				addListTempoAtendimentoUnidade(acordoNivelServicoDTO.getIdAcordoNivelServico(), listaTempoAtendimentoUnidade, tc);
				addListTempoAtendimentoEmpregado(acordoNivelServicoDTO.getIdAcordoNivelServico(), listaTempoAtendimentoEmpregado, tc);
			} else if (acordoNivelServicoDTO.getIdServicoContrato() != null) { // Requisio/Incidente
				addListTempoAtendimentoUnidade(acordoNivelServicoDTO.getIdAcordoNivelServico(), listaTempoAtendimentoUnidade, tc);
				addListTempoAtendimentoEmpregado(acordoNivelServicoDTO.getIdAcordoNivelServico(), listaTempoAtendimentoEmpregado, tc);
			} else { // Global
				addListAcordoServicoContrato(acordoNivelServicoDTO, listIdServicoContrato, tc);
			}

			addTempoAcordoNivelServico(acordoNivelServicoDTO, tc);

			tc.commit();
		} catch (Exception e) {
			e.printStackTrace();
			tc.rollback();
			throw e;
		} finally {
			tc.closeQuietly();
		}
	}

	private void deleteAcordos(AcordoNivelServicoDTO acordoNivelServicoDTO, TransactionControler tc) throws Exception {
		AcordoServicoContratoDao acordoServicoContratoDao = new AcordoServicoContratoDao();
		acordoServicoContratoDao.setTransactionControler(tc);

		TempoAtendimentoUnidadeDao tempoAtendimentoUnidadeDao = new TempoAtendimentoUnidadeDao();
		tempoAtendimentoUnidadeDao.setTransactionControler(tc);
		TempoAtendimentoEmpregadoDao acordoNivelServicoEmpregadoDao = new TempoAtendimentoEmpregadoDao();
		acordoNivelServicoEmpregadoDao.setTransactionControler(tc);

		Collection<AcordoServicoContratoDTO> listAcordoServicoContratoDTO = acordoServicoContratoDao.findByIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
		Collection<TempoAtendimentoUnidadeDTO> listTempoAtendimentoUnidadeDto = tempoAtendimentoUnidadeDao.findByIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
		Collection<TempoAtendimentoEmpregadoDTO> listTempoAtendimentoEmpregadoDto = acordoNivelServicoEmpregadoDao.findByIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());

		if(listAcordoServicoContratoDTO != null) {
			for (AcordoServicoContratoDTO acordoServicoContratoDTO : listAcordoServicoContratoDTO) {
				acordoServicoContratoDao.delete(acordoServicoContratoDTO);
			}
		}

		if (listTempoAtendimentoUnidadeDto != null) {
			for (TempoAtendimentoUnidadeDTO tempoAtendimentoUnidadeDTO : listTempoAtendimentoUnidadeDto) {
				tempoAtendimentoUnidadeDao.delete(tempoAtendimentoUnidadeDTO);
			}
		}

		if (listTempoAtendimentoEmpregadoDto != null) {
			for (TempoAtendimentoEmpregadoDTO acordoNivelServicoEmpregadoDTO : listTempoAtendimentoEmpregadoDto) {
				acordoNivelServicoEmpregadoDao.delete(acordoNivelServicoEmpregadoDTO);
			}
		}

		TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
		tempoAcordoNivelServicoDao.setTransactionControler(tc);

		tempoAcordoNivelServicoDao.deleteByIdAcordo(acordoNivelServicoDTO.getIdAcordoNivelServico());
	}

	private Integer addListAcordoServicoContrato(AcordoNivelServicoDTO acordoNivelServicoDTO, Set<Integer> listIdServicoContrato, TransactionControler tc) throws Exception {
		AcordoServicoContratoDao acordoServicoContratoDao = new AcordoServicoContratoDao();
		acordoServicoContratoDao.setTransactionControler(tc);
		Integer idAcordoServicoContrato = 0;
		for (Integer idServicoContrato : listIdServicoContrato) {
			AcordoServicoContratoDTO acordoServicoContratoDTO = new AcordoServicoContratoDTO();
			acordoServicoContratoDTO.setIdServicoContrato(idServicoContrato);
			acordoServicoContratoDTO.setIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
			acordoServicoContratoDTO.setDataCriacao(UtilDatas.getDataHoraAtual());
			acordoServicoContratoDTO.setDataInicio(acordoNivelServicoDTO.getDataInicio());
			acordoServicoContratoDTO.setDataFim(acordoNivelServicoDTO.getDataFim());
			acordoServicoContratoDTO.setHabilitado("S");
			acordoServicoContratoDTO = (AcordoServicoContratoDTO) acordoServicoContratoDao
					.create(acordoServicoContratoDTO);
			idAcordoServicoContrato = acordoServicoContratoDTO.getIdAcordoServicoContrato();
		}
		return idAcordoServicoContrato;
	}

	private void addListTempoAtendimentoUnidade(Integer idAcordoNivelServico, List<TempoAtendimentoUnidadeDTO> listaTempoAtendimentoUnidade, TransactionControler tc) throws Exception {
		TempoAtendimentoUnidadeDao tempoAtendimentoUnidadeDAO = new TempoAtendimentoUnidadeDao();
		tempoAtendimentoUnidadeDAO.setTransactionControler(tc);
		for (TempoAtendimentoUnidadeDTO tempoAtendimentoUnidade : listaTempoAtendimentoUnidade) {

			TempoAtendimentoUnidadeDTO tempoAtendimentoUnidadeDTO = new TempoAtendimentoUnidadeDTO();
			tempoAtendimentoUnidadeDTO.setIdAcordoNivelServico(idAcordoNivelServico);
			tempoAtendimentoUnidadeDTO.setIdUnidade(tempoAtendimentoUnidade.getIdUnidade());
			tempoAtendimentoUnidadeDTO.setPrioridade(tempoAtendimentoUnidade.getPrioridade());
			
			tempoAtendimentoUnidadeDAO.create(tempoAtendimentoUnidadeDTO);
		}
	}

	private void addListTempoAtendimentoEmpregado(Integer idAcordoNivelServico, List<TempoAtendimentoEmpregadoDTO> listaTempoAtendimentoEmpregado, TransactionControler tc) throws Exception {
		TempoAtendimentoEmpregadoDao tempoAtendimentoEmpregadoDAO = new TempoAtendimentoEmpregadoDao();
		tempoAtendimentoEmpregadoDAO.setTransactionControler(tc);
		for (TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregado : listaTempoAtendimentoEmpregado) {

			TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregadoDTO = new TempoAtendimentoEmpregadoDTO();
			tempoAtendimentoEmpregadoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
			tempoAtendimentoEmpregadoDTO.setIdEmpregado(tempoAtendimentoEmpregado.getIdEmpregado());
			tempoAtendimentoEmpregadoDTO.setPrioridade(tempoAtendimentoEmpregado.getPrioridade());
			
			tempoAtendimentoEmpregadoDAO.create(tempoAtendimentoEmpregadoDTO);
		}
	}

	private void addTempoAcordoNivelServico(AcordoNivelServicoDTO acordoNivelServicoDTO, TransactionControler tc)
			throws Exception {
		TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
		tempoAcordoNivelServicoDao.setTransactionControler(tc);
		TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = new TempoAcordoNivelServicoDTO();
		tempoAcordoNivelServicoDTO.setIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
		for (int i = 0; i < 5; i++) {
			tempoAcordoNivelServicoDTO.setIdPrioridade(i + 1);
			tempoAcordoNivelServicoDTO.setIdFase(1);
			tempoAcordoNivelServicoDTO.setTempoHH(UtilNumbersAndDecimals.nullToZero(acordoNivelServicoDTO.getHhCaptura()[i]));
			tempoAcordoNivelServicoDTO.setTempoMM(UtilNumbersAndDecimals.nullToZero(acordoNivelServicoDTO.getMmCaptura()[i]));
			tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
			tempoAcordoNivelServicoDTO.setIdFase(2);
			tempoAcordoNivelServicoDTO.setTempoHH(UtilNumbersAndDecimals.nullToZero(acordoNivelServicoDTO.getHhResolucao()[i]));
			tempoAcordoNivelServicoDTO.setTempoMM(UtilNumbersAndDecimals.nullToZero(acordoNivelServicoDTO.getMmResolucao()[i]));
			tempoAcordoNivelServicoDao.create(tempoAcordoNivelServicoDTO);
		}
	}

	@Override
	public IDto restoreTempoAtendimento(Integer idAcordoNivelServico) throws Exception {
		AcordoNivelServicoDao acordoNivelServicoDao = new AcordoNivelServicoDao();

		TempoAtendimentoDTO tempoAtendimentoDTO = new TempoAtendimentoDTO();
		AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
		acordoNivelServicoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
		acordoNivelServicoDTO = (AcordoNivelServicoDTO) acordoNivelServicoDao.restore(acordoNivelServicoDTO);

		Reflexao.copyPropertyValues(acordoNivelServicoDTO, tempoAtendimentoDTO);

		tempoAtendimentoDTO = addTempoAtendimento(tempoAtendimentoDTO, idAcordoNivelServico);

		if(acordoNivelServicoDTO.getIdContrato() != null){//Cliente
			tempoAtendimentoDTO.setTipoAcordo(Enumerados.TipoAnsMultinivel.CLIENTE.getChave());

			tempoAtendimentoDTO = addIdsServicosContrato(tempoAtendimentoDTO);
			tempoAtendimentoDTO = addUnidades(tempoAtendimentoDTO);
			tempoAtendimentoDTO = addEmpregados(tempoAtendimentoDTO);

			addIdsServicosRelacionadosServicoContrato(tempoAtendimentoDTO);
		} else if (acordoNivelServicoDTO.getIdServicoContrato() != null) {// Requisio/incidente
			tempoAtendimentoDTO.setTipoAcordo(Enumerados.TipoAnsMultinivel.REQUISICAO.getChave());

			tempoAtendimentoDTO = addUnidades(tempoAtendimentoDTO);
			tempoAtendimentoDTO = addEmpregados(tempoAtendimentoDTO);
			
			tempoAtendimentoDTO.setListaIdsServicosContrato(Arrays.asList(acordoNivelServicoDTO.getIdServicoContrato()));
			addIdsServicosRelacionadosServicoContrato(tempoAtendimentoDTO);

		} else {//Global
			tempoAtendimentoDTO.setTipoAcordo(Enumerados.TipoAnsMultinivel.GLOBAL.getChave());

			tempoAtendimentoDTO = addIdsServicosContrato(tempoAtendimentoDTO);
			addIdsServicosRelacionadosServicoContrato(tempoAtendimentoDTO);
		}

		return tempoAtendimentoDTO;
	}

	private void addIdsServicosRelacionadosServicoContrato(TempoAtendimentoDTO tempoAtendimentoDTO) throws Exception {
		ServicoDao servicoDao = new ServicoDao();
		String idsServicosContrato = Util.listIntegerToListStr(tempoAtendimentoDTO.getListaIdsServicosContrato());

		if (!UtilStrings.isNullOrEmpty(idsServicosContrato)) {
			List<ServicoDTO> listServicos = servicoDao.getIdsServicosRelacionadosServicoContrato(idsServicosContrato);
			if (listServicos != null && !listServicos.isEmpty()) {
				List<Integer> listaIdsServicos = new ArrayList<>();
				Set<Integer> listaIdsContratos = new HashSet<>();

				for (ServicoDTO servicoDto : listServicos) {
					if (servicoDto != null && servicoDto.getIdServico() != null) {
						listaIdsServicos.add(servicoDto.getIdServico());
						listaIdsContratos.add(servicoDto.getIdContrato());
					}
				}

				tempoAtendimentoDTO.setListaIdsServicosRelacionadosServicoContrato(listaIdsServicos);
				tempoAtendimentoDTO.setListaIdsContratosRelacionadosServicoContrato(new ArrayList<>(listaIdsContratos));
			}
		}
	}

	private TempoAtendimentoDTO addIdsServicosContrato(TempoAtendimentoDTO tempoAtendimentoDTO) throws Exception {
		ServicoContratoDao servicoContratoDao = new ServicoContratoDao();
		List<ServicoContratoDTO> listServicos = servicoContratoDao.listServicoContratoFromAcordoServicoContrato(tempoAtendimentoDTO.getIdAcordoNivelServico());
		if (listServicos != null && !listServicos.isEmpty()) {
			List<Integer> listaIdsServicosContrato = geraListaIdsServicosContrato(listServicos);
			tempoAtendimentoDTO.setListaIdsServicosContrato(listaIdsServicosContrato);
		}
		return tempoAtendimentoDTO;
	}

	private List<Integer> geraListaIdsServicosContrato(List<ServicoContratoDTO> listServicos) {
		List<Integer> listaIdsServicosContrato = new ArrayList<Integer>();

		for (ServicoContratoDTO servicoContratoDto : listServicos) {
			if (servicoContratoDto != null && servicoContratoDto.getIdServicoContrato() != null) {
				listaIdsServicosContrato.add(servicoContratoDto.getIdServicoContrato());
			}
		}

		return listaIdsServicosContrato;
	}

	private TempoAtendimentoDTO addUnidades(TempoAtendimentoDTO tempoAtendimentoDTO) throws Exception {

		TempoAtendimentoUnidadeDao ansUnidadeDao = new TempoAtendimentoUnidadeDao();
		// ArrayList<UnidadeDTO> listaUnidades = ansUnidadeDao.listUnidadesByIdAcordoNivelServico(tempoAtendimentoDTO.getIdAcordoNivelServico());
		ArrayList<TempoAtendimentoUnidadeDTO> listaUnidades = ansUnidadeDao.listUnidadesByIdAcordoNivelServico(tempoAtendimentoDTO.getIdAcordoNivelServico());
		if (listaUnidades != null && !listaUnidades.isEmpty()) {
			// tempoAtendimentoDTO.setListaUnidadeDeserializado(listaUnidades);
			tempoAtendimentoDTO.setListaPrioridadeUnidade(listaUnidades);
			// tempoAtendimentoDTO.setListaUnidades(WebUtil.serializeObjects(listaUnidades));
		}

		return tempoAtendimentoDTO;
	}

	private TempoAtendimentoDTO addEmpregados(TempoAtendimentoDTO tempoAtendimentoDTO) throws Exception {

		TempoAtendimentoEmpregadoDao ansEmpregadoDao = new TempoAtendimentoEmpregadoDao();
		// ArrayList<EmpregadoDTO> listaEmpregados = ansEmpregadoDao.listEmpregadosByIdAcordoNivelServico(tempoAtendimentoDTO.getIdAcordoNivelServico());
		ArrayList<TempoAtendimentoEmpregadoDTO> listaEmpregados = ansEmpregadoDao.listEmpregadosByIdAcordoNivelServico(tempoAtendimentoDTO.getIdAcordoNivelServico());
		if (listaEmpregados != null && !listaEmpregados.isEmpty()) {
			// tempoAtendimentoDTO.setListaEmpregadoDeserializado(listaEmpregados);
			tempoAtendimentoDTO.setListaPrioridadeEmpregado(listaEmpregados);
			// tempoAtendimentoDTO.setListaEmpregados(WebUtil.serializeObjects(listaEmpregados));
		}

		return tempoAtendimentoDTO;
	}

	private TempoAtendimentoDTO addTempoAtendimento(TempoAtendimentoDTO tempoAtendimentoDTO, Integer idAcordoNivelServico) throws Exception{
		TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
		List<TempoAcordoNivelServicoDTO> listTempoAcordoNivelServico = new ArrayList<>(tempoAcordoNivelServicoDao.findByIdAcordo(idAcordoNivelServico));
		Integer[] hhCaptura = new Integer[5];
		Integer[] mmCaptura = new Integer[5];
		Integer[] hhResolucao = new Integer[5];
		Integer[] mmResolucao = new Integer[5];
		for(TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO : listTempoAcordoNivelServico){
			if(tempoAcordoNivelServicoDTO.getIdFase() == 1){
				hhCaptura[tempoAcordoNivelServicoDTO.getIdPrioridade() - 1] = tempoAcordoNivelServicoDTO.getTempoHH();
				mmCaptura[tempoAcordoNivelServicoDTO.getIdPrioridade() - 1] = tempoAcordoNivelServicoDTO.getTempoMM();
			} else {
				hhResolucao[tempoAcordoNivelServicoDTO.getIdPrioridade() - 1] = tempoAcordoNivelServicoDTO.getTempoHH();
				mmResolucao[tempoAcordoNivelServicoDTO.getIdPrioridade() - 1] = tempoAcordoNivelServicoDTO.getTempoMM();
			}
		}
		tempoAtendimentoDTO.setHhCaptura(hhCaptura);
		tempoAtendimentoDTO.setMmCaptura(mmCaptura);
		tempoAtendimentoDTO.setHhResolucao(hhResolucao);
		tempoAtendimentoDTO.setMmResolucao(mmResolucao);

		return tempoAtendimentoDTO;
	}

	@Override
	public void excluiAnsMulti(AcordoNivelServicoDTO acordoNivelServicoDTO) throws Exception {

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		tc.start();

		try {
			acordoNivelServicoDTO.setDeleted("y");
			this.getDao().updateNotNull(acordoNivelServicoDTO);

			this.deleteAcordos(acordoNivelServicoDTO, tc);

			tc.commit();
		} catch (Exception e) {
			tc.rollback();
			throw new Exception(e);
		} finally {
			tc.closeQuietly();
		}

	}

	private AcordoNivelServicoHistoricoDao getAcordoNivelServicoHistoricoDao() throws ServiceException {
		if (acordoNivelServicoHistoricoDao == null) {
			acordoNivelServicoHistoricoDao = new AcordoNivelServicoHistoricoDao();
		}

		return acordoNivelServicoHistoricoDao;
	}

	@Override
	public AcordoNivelServicoDTO findANSIncReqProcByIdServicoContrato(Integer idServicoContrato) throws Exception {
		return this.getDao().findANSIncReqProcByIdServicoContrato(idServicoContrato);
	}

}
