package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.integracao.AmeacaRiscoDAO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

public class AmeacaRiscoServiceEjb extends CrudServiceImpl implements AmeacaRiscoService {

	private AmeacaRiscoDAO dao;

	@Override
	public List buscaAmeacasByRisco(Integer idRisco) throws PersistenceException {
		return this.getDao().buscaAmeacasByRisco(idRisco);
	}

	public void excluiAmeacasRisco(Integer idRisco) throws PersistenceException {
		this.getDao().excluiAmeacasRisco(idRisco);
	}

	public boolean verificarVinculoAmeaca(Integer idAmeaca) throws PersistenceException {
		return this.getDao().verificarVinculoAmeaca(idAmeaca);
	}
	@Override
	protected AmeacaRiscoDAO getDao() {
		if (dao == null) {
			dao = new AmeacaRiscoDAO();
		}
		return dao;
	}

}
