package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.AmeacaDTO;
import br.com.centralit.citcorpore.integracao.AmeacaDao;
import br.com.centralit.citcorpore.integracao.CategoriaAmeacaDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class AmeacaServiceEjb extends CrudServiceImpl implements AmeacaService {

	private AmeacaDao cadastroAmeacaDao;
	private CategoriaAmeacaDao categoriaAmeacaDao;

	@Override
	protected AmeacaDao getDao() {
		if (cadastroAmeacaDao == null) {
			cadastroAmeacaDao = new AmeacaDao();
		}
		return cadastroAmeacaDao;
	}
	
	protected CategoriaAmeacaDao getCategoriaAmeacaDao() {
		if (categoriaAmeacaDao == null) {
			categoriaAmeacaDao = new CategoriaAmeacaDao();
		}
		return categoriaAmeacaDao;
	}

	/**
	 * Retorna true quando houver alguma tupla com mesmo nome
	 * 
	 * @author joao.morais
	 */
	@Override
	public boolean verificaDuplicata(String nomeAmeaca, Integer categoriaAmeaca) throws PersistenceException {
		Collection<AmeacaDTO> lista = this.getDao().getListAmeacasByNome(nomeAmeaca);
		// Se houver alguma tupla com mesmo nome de ameaca entra no bloco if
		if (lista != null && lista.size() > 0) {
			for(AmeacaDTO ameacaDTO : lista){
				if (ameacaDTO.getIdCategoriaAmeaca().intValue() == categoriaAmeaca) {
					return true;
				}
			}
			return false;
		} else
			return false;
	}

	/**
	 * Retorna true quando houver alguma tupla com mesmo nome
	 * 
	 * @author joao.morais
	 */
	@Override
	public boolean verificaDuplicataSalvar(String nomeAmeaca) throws PersistenceException {
		Collection<AmeacaDTO> lista = this.getDao().getListAmeacasByNome(nomeAmeaca);
		// Se houver alguma tupla com mesmo nome de ameaca entra no bloco if
		if (lista != null && lista.size() > 0) {
			return true;
		} else
			return false;
	}

	@Override
	public String getCategoriaAmeaca(Integer idCategoriaAmeaca) throws PersistenceException {
		if (this.getCategoriaAmeacaDao().getCategoriaAmeacaById(idCategoriaAmeaca) != null) {
			AmeacaDTO ameacaDTO = this.getCategoriaAmeacaDao().getCategoriaAmeacaById(idCategoriaAmeaca);
			return ameacaDTO.getNomeCategoriaAmeaca();
		} else {
			return null;
		}

	}
	
	public boolean verificarVinculoCategoriaAmeaca(Integer idCategoriaAmeaca) throws PersistenceException {
		return this.getDao().verificarVinculoCategoriaAmeaca(idCategoriaAmeaca);
	}
}
