package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citcorpore.bean.AplicacaoRequisitoDTO;
import br.com.centralit.citcorpore.integracao.AplicacaoRequisitoDao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class AplicacaoRequisitoServiceEjb extends CrudServiceImpl implements AplicacaoRequisitoService {

	private AplicacaoRequisitoDao dao;

	@Override
	public void deleteByIdAplicacao(final Integer idAplicacao) throws Exception {
		try {
			this.getDao().deleteByIdAplicacao(idAplicacao);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	@SuppressWarnings("rawtypes")
	public Collection findByIdAplicacao(final Integer idAplicacao) throws Exception {
		try {
			return this.getDao().findByIdAplicacao(idAplicacao);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void salvarRequisitos(final List<AplicacaoRequisitoDTO> listaDeRequisitosDaAplicacao, Integer idAplicacao) throws Exception {
		if (listaDeRequisitosDaAplicacao != null && !listaDeRequisitosDaAplicacao.isEmpty()) {
			for (final AplicacaoRequisitoDTO requisito : listaDeRequisitosDaAplicacao) {
				if (requisito.getIdRequisitoAplicacao() != null && requisito.getIdRequisitoAplicacao().intValue() > 0) {
					this.getDao().update(requisito);
				} else {
					requisito.setIdAplicacao(idAplicacao);
					this.getDao().create(requisito);
				}
			}
		}
	}

	@Override
	public void excluirRequisitos(final List<String> listaDeRequisitos) throws Exception {
		if (listaDeRequisitos != null && !listaDeRequisitos.isEmpty()) {
			for (final String idRequisito : listaDeRequisitos) {
				if (StringUtils.isNotBlank(idRequisito)) {
					final AplicacaoRequisitoDTO requisito = new AplicacaoRequisitoDTO();
					requisito.setIdRequisitoAplicacao(Integer.valueOf(idRequisito));
					this.getDao().delete(requisito);
				}
			}
		}
	}

	@Override
	protected AplicacaoRequisitoDao getDao() {
		if (dao == null) {
			dao = new AplicacaoRequisitoDao();
		}
		return dao;
	}

}
