package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AplicacaoClienteDTO;
import br.com.centralit.citcorpore.bean.AplicacaoDTO;
import br.com.centralit.citcorpore.bean.AplicacaoRequisitoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

public interface AplicacaoService extends CrudService {

	public IDto create(IDto model) throws ServiceException, LogicException;

	public void delete(IDto model) throws ServiceException, LogicException;

	public Collection<AplicacaoDTO> listaAtivas() throws ServiceException, LogicException;

	public void update(IDto model) throws ServiceException, LogicException;

	public void salvarClientes(List<AplicacaoClienteDTO> listaDeClientes, Integer idAplicacao) throws Exception;

	public void excluirClientes(List<String> listaDeClientes) throws Exception;

	public Collection<AplicacaoClienteDTO> findClientesByIdAplicacao(Integer idAplicacao) throws Exception;
	
	public Collection<AplicacaoDTO> listAtivosByIdServicoAndFiltro(Integer idServico, String filtro, Pageable pageable, Boolean isTotalizacao) throws Exception;
	
	public boolean aplicacaoVinculadoServico(Integer idAplicacao) throws Exception;
}
