package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citcorpore.bean.AplicacaoClienteDTO;
import br.com.centralit.citcorpore.bean.AplicacaoDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.integracao.AplicacaoClienteDao;
import br.com.centralit.citcorpore.integracao.AplicacaoDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

/**
 * @author CentralIT
 */
@SuppressWarnings({ "unchecked" })
public class AplicacaoServiceEjb extends CrudServiceImpl implements AplicacaoService {

	private AplicacaoClienteDao aplicacaoClienteDao;
	private AplicacaoDao aplicacaoDao;

	@Override
	public IDto create(final IDto model) throws ServiceException, LogicException {
		AplicacaoDTO aplicacaoDTO = (AplicacaoDTO) model;

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {
			this.validaCreate(model);

			this.getDao().setTransactionControler(tc);

			tc.start();

			aplicacaoDTO = (AplicacaoDTO) this.getDao().create(aplicacaoDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
		return aplicacaoDTO;
	}

	@Override
	public void delete(final IDto model) throws ServiceException, LogicException {
		final AplicacaoDTO aplicacaoDTO = (AplicacaoDTO) model;

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {

			this.getDao().setTransactionControler(tc);

			tc.start();

			aplicacaoDTO.setDataFim(UtilDatas.getDataAtual());
			this.getDao().update(aplicacaoDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
	}

	@Override
	public void excluirClientes(List<String> listaDeClientes) throws Exception {
		if (listaDeClientes != null && !listaDeClientes.isEmpty()) {
			for (final String idCliente : listaDeClientes) {
				if (StringUtils.isNotBlank(idCliente)) {
					final ClienteDTO cliente = new ClienteDTO();
					cliente.setIdCliente(Integer.valueOf(idCliente));
					this.getAplicacaoClienteDao().delete(cliente);
				}
			}
		}
	}

	protected AplicacaoClienteDao getAplicacaoClienteDao() {
		if (aplicacaoClienteDao == null) {
			aplicacaoClienteDao = new AplicacaoClienteDao();
		}
		return aplicacaoClienteDao;
	}

	@Override
	protected AplicacaoDao getDao() {
		if (aplicacaoDao == null) {
			aplicacaoDao = new AplicacaoDao();
		}
		return aplicacaoDao;
	}

	@Override
	public Collection<AplicacaoDTO> listaAtivas() throws ServiceException, LogicException {
		Collection<AplicacaoDTO> aplicacoes = new ArrayList<AplicacaoDTO>();
		try {
			aplicacoes = this.getDao().listaAtivas();

			if (aplicacoes == null) {
				aplicacoes = new ArrayList<AplicacaoDTO>();
			}
		} catch (final Exception e) {
			e.printStackTrace();
		}
		return aplicacoes;
	}

	@Override
	public void salvarClientes(List<AplicacaoClienteDTO> listaDeClientes, Integer idAplicacao) throws Exception {

		if (listaDeClientes != null && !listaDeClientes.isEmpty()) {
			for (final AplicacaoClienteDTO cliente : listaDeClientes) {
				cliente.setIdAplicacao(idAplicacao);
				if (cliente.getIdAplicacaoCliente() != null && cliente.getIdAplicacaoCliente().intValue() > 0) {
					this.getAplicacaoClienteDao().update(cliente);
				} else {
					this.getAplicacaoClienteDao().create(cliente);
				}
			}
		}
	}

	@Override
	public void update(final IDto model) throws ServiceException, LogicException {
		final AplicacaoDTO aplicacaoDTO = (AplicacaoDTO) model;
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			this.validaUpdate(model);

			this.getDao().setTransactionControler(tc);

			tc.start();

			this.getDao().update(aplicacaoDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
	}

	@Override
	public Collection<AplicacaoClienteDTO> findClientesByIdAplicacao(final Integer idAplicacao) throws Exception {
		try {
			return this.getAplicacaoClienteDao().findByIdAplicacao(idAplicacao);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<AplicacaoDTO> listAtivosByIdServicoAndFiltro(Integer idServico, String filtro, Pageable pageable, Boolean isTotalizacao) throws Exception {
		try {
			return this.getDao().listAtivosByIdServicoAndFiltro(idServico, filtro);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}
	
	@Override
	public boolean aplicacaoVinculadoServico(Integer idAplicacao) throws Exception {
		try {
			return this.getDao().aplicacaoVinculadoServico(idAplicacao);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}



}
