package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.AprovacaoMudancaDTO;
import br.com.centralit.citcorpore.integracao.AprovacaoMudancaDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class AprovacaoMudancaServiceEjb extends CrudServiceImpl implements AprovacaoMudancaService {

	private AprovacaoMudancaDao dao;

	@Override
	protected AprovacaoMudancaDao getDao() {
		if (dao == null) {
			dao = new AprovacaoMudancaDao();
		}
		return dao;
	}

	@Override
	public Collection<AprovacaoMudancaDTO> listaAprovacaoMudancaPorIdRequisicaoMudanca(final Integer idRequisicaoMudanca) throws Exception {
		return this.getDao().listaAprovacaoMudancaPorIdRequisicaoMudanca(idRequisicaoMudanca);
	}

	@Override
	public Integer quantidadeAprovacaoMudancaPorVoto(final AprovacaoMudancaDTO aprovacao) throws Exception {
		return this.getDao().quantidadeAprovacaoMudancaPorVoto(aprovacao);
	}

	@Override
	public Boolean validacaoAprovacaoMudanca(final Integer idRequisicaoMudanca) throws Exception {
		return this.getDao().validacaoAprovacaoMudanca(idRequisicaoMudanca);
	}

	@Override
	public Integer quantidadeAprovacaoMudanca(final AprovacaoMudancaDTO aprovacao) throws Exception {
		return this.getDao().quantidadeAprovacaoMudanca(aprovacao);
	}

}
