package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.AprovacaoPropostaDTO;
import br.com.centralit.citcorpore.integracao.AprovacaoPropostaDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class AprovacaoPropostaServiceEjb extends CrudServiceImpl implements AprovacaoPropostaService {

	private AprovacaoPropostaDao dao;

	@Override
	protected AprovacaoPropostaDao getDao() {
		if (dao == null) {
			dao = new AprovacaoPropostaDao();
		}
		return dao;
	}

	@Override
	public Collection<AprovacaoPropostaDTO> listaAprovacaoPropostaPorIdRequisicaoMudanca(final Integer idRequisicaoMudanca) throws Exception {
		return this.getDao().listaAprovacaoPropostaPorIdRequisicaoMudanca(idRequisicaoMudanca);
	}

	@Override
	public Integer quantidadeAprovacaoPropostaPorVoto(final AprovacaoPropostaDTO aprovacao) throws Exception {
		return this.getDao().quantidadeAprovacaoPropostaPorVoto(aprovacao);
	}

	@Override
	public Boolean validacaoAprovacaoProposta(final Integer idRequisicaoMudanca) throws Exception {
		return this.getDao().validacaoAprovacaoProposta(idRequisicaoMudanca);
	}

	@Override
	public Integer quantidadeAprovacaoProposta(final AprovacaoPropostaDTO aprovacao) throws Exception {
		return this.getDao().quantidadeAprovacaoProposta(aprovacao);
	}

}
