package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.AssociacaoDeviceAtendenteDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Servios para {@link AssociacaoDeviceAtendenteDTO}
 *
 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
 * @since 15/11/2014
 */
public interface AssociacaoDeviceAtendenteService extends CrudService {

    /**
     * Lista as associaes ativas de um usurio, independentemente de conexo e plataforma
     *
     * @param usuario
     *            usurio para o qual se deseja listar as associaes ativas
     * @param connection
     *            "conexo" no mobile, que  a URI acessada
     * @return {@link List} de {@link AssociacaoDeviceAtendenteDTO}
     * @throws ServiceException
     */
    List<AssociacaoDeviceAtendenteDTO> listActiveAssociationsForUserAndConnection(final UsuarioDTO usuario, final String connection) throws ServiceException;

    /**
     * Associa um device a um usurio
     *
     * @param associacao
     *            informaes da associao a ser efetuada
     * @param usuario
     *            usurio para o qual ser realizada a associao
     * @return {@link AssociacaoDeviceAtendenteDTO} realizada
     * @throws ServiceException
     */
    AssociacaoDeviceAtendenteDTO associateDeviceToAttendant(final AssociacaoDeviceAtendenteDTO associacao, final UsuarioDTO usuario) throws ServiceException;

    /**
     * Desassocia um device de um usurio
     *
     * @param associacao
     *            informaes da associao a ser desfeita
     * @param usuario
     *            usurio para o qual ser realizada a desassociao
     * @return {@link AssociacaoDeviceAtendenteDTO} desassociado
     * @throws ServiceException
     */
    AssociacaoDeviceAtendenteDTO disassociateDeviceFromAttendant(final AssociacaoDeviceAtendenteDTO associacao, final UsuarioDTO usuario) throws ServiceException;

}
