/**
 * CentralIT - CITSmart.
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.HashMap;

import br.com.centralit.citcorpore.bean.AtividadesServicoContratoDTO;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface AtividadesServicoContratoService extends CrudService {

	public Collection findByIdServicoContrato(Integer parm) throws Exception;

	public void deleteByIdServicoContrato(Integer parm) throws Exception;

	/**
	 * Retorna Atividades Ativas do Servio Contrato pelo Id do Servio
	 * Contrato.
	 * 
	 * @param idServicoContrato
	 * @return atividadesServicoContrato
	 * @throws Exception
	 */
	public Collection<AtividadesServicoContratoDTO> obterAtividadesAtivasPorIdServicoContrato(Integer idServicoContrato) throws Exception;
	
	/**
	 * Mtodo para atualizar a observacao de os no homologadas
	 * 
	 * @param mapFields
	 * @throws Exception
	 */
	public boolean atualizaObservacao(HashMap mapFields) throws Exception;
	
	/**
	 * Mtodo para calcular frmula
	 * 
	 * @param mapFields
	 * @throws Exception
	 */
	public String calculaFormula(HashMap mapFields) throws Exception;
	
	/**
	 * Verifica se complexidades esto cadastradas
	 * 
	 * @param mapFields
	 * @throws Exception
	 */
	public boolean verificaComplexidade(HashMap mapFields) throws Exception;
	
	/**
	 * Mtodo que retorna os servios vinculado ao contrato em questo
	 * 
	 * @param mapFields
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
	public Collection preencheComboServicoContrato(HashMap mapFields, String language) throws Exception;
	
	public Double calculaFormula(AtividadesServicoContratoDTO atividadesServicoContrato) throws Exception;
	
	public Collection listarPorFormula() throws Exception;
}
