package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.AtributoDemandaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.integracao.AtributoDemandaItemConfiguracaoDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class AtributoDemandaItemConfiguracaoServiceEjb extends CrudServiceImpl implements AtributoDemandaItemConfiguracaoService {

	
	@Override
	protected AtributoDemandaItemConfiguracaoDao getDao() {
		return new AtributoDemandaItemConfiguracaoDao();
	}

	@Override
	public List<AtributoDemandaItemConfiguracaoDTO> listByIdItemConfiguracao(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, Integer pageNo, Integer pageSize) throws Exception{
		return getDao().listByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO, pageNo, pageSize);
	}

	@Override
	public Integer getTotalPaginasAtributoDemanda(Integer pageSize, Integer idItemConfiguracao) throws Exception{
		Double totalItens = new Double(this.getDao().getTotalItensByIdItemConfiguracao(idItemConfiguracao));
		Double totalPaginas = Math.ceil(totalItens / new Double(pageSize));
		return totalPaginas.intValue();
	}

	@Override
	public void deleteByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		this.getDao().deleteByIdItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public List<AtributoDemandaItemConfiguracaoDTO> listAllByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception{
		return getDao().listAllByIdItemConfiguracao(idItemConfiguracao);
	}

}
