package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.AtributoDemandaServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoNegocioAtributoDemandaDTO;
import br.com.centralit.citcorpore.integracao.AtributoDemandaServicoDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class AtributoDemandaServicoServiceEjb extends CrudServiceImpl implements AtributoDemandaServicoService {

	
	@Override
	protected AtributoDemandaServicoDao getDao() {
		return new AtributoDemandaServicoDao();
	}

	@Override
	public List<AtributoDemandaServicoDTO> listByIdServico(ServicoNegocioAtributoDemandaDTO servicoNegocioAtributoDemandaDTO, Integer pageNo, Integer pageSize) throws Exception{
		return getDao().listByIdServico(servicoNegocioAtributoDemandaDTO, pageNo, pageSize);
	}

	@Override
	public Integer getTotalPaginasAtributoDemanda(Integer pageSize, Integer idServico) throws Exception{
		Double totalItens = new Double(this.getDao().getTotalItensByIdServico(idServico));
		Double totalPaginas = Math.ceil(totalItens / new Double(pageSize));
		return totalPaginas.intValue();
	}

	@Override
	public void deleteByIdServico(Integer idServico) throws Exception {
		this.getDao().deleteByIdServico(idServico);
	}

	@Override
	public List<AtributoDemandaServicoDTO> listAllByIdServico(Integer idServico) throws Exception {
		return getDao().listAllByIdServico(idServico);
	}

}
