package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.integracao.AtributosFinanceirosDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

/**
 * @author CentralIT
 */
@SuppressWarnings({ "unchecked" })
public class AtributosFinanceirosServiceEjb extends CrudServiceImpl implements AtributosFinanceirosService {

	private AtributosFinanceirosDao atributosFinanceirosDao;

	@Override
	public void deleteLogico(final IDto model) throws Exception {
		final AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) model;
		atributosFinanceirosDTO.setDataFim(UtilDatas.getDataAtual());
		this.getDao().update(atributosFinanceirosDTO);
	}

	@Override
	protected AtributosFinanceirosDao getDao() {
		if (atributosFinanceirosDao == null) {
			atributosFinanceirosDao = new AtributosFinanceirosDao();
		}
		return atributosFinanceirosDao;
	}

	@Override
	public Collection<AtributosFinanceirosDTO> findFinanceiroByIdServico(final Integer idAplicacao, final Integer pageNo, final Integer pageSize) throws Exception {
		try {
			return getDao().findByIdServico(idAplicacao, pageNo, pageSize);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}
	
	@Override
	public Collection<AtributosFinanceirosDTO> findlistaTiposPorPerfil(final String perfil) throws Exception {
		try {
			return getDao().listaTiposPorPerfil(perfil);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Integer getTotalPaginasAtributosFinanceiros(Integer pageSize, Integer idServico) throws Exception {
		if(pageSize <= 0) return 1;
		return new Double(Math.ceil(new Double(getDao().getTotalAtributosFinanceiros(idServico)) / new Double(pageSize))).intValue();
	}


}
