package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.BaseConhecimentoSLADTO;
import br.com.centralit.citcorpore.integracao.BaseConhecimentoSLADAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class BaseConhecimentoSLAServiceEjb extends CrudServiceImpl implements BaseConhecimentoSLAService {

	private BaseConhecimentoSLADAO dao;

	@Override
	protected BaseConhecimentoSLADAO getDao() {
		if (dao == null) {
			dao = new BaseConhecimentoSLADAO();
		}
		return dao;
	}

	@Override
	public void delete(BaseConhecimentoSLADTO baseConhecimentoSLADTO) throws Exception {

		if (baseConhecimentoSLADTO != null) {
			baseConhecimentoSLADTO.setDataFim(UtilDatas.getDataAtual());

			this.update(baseConhecimentoSLADTO);
		}
	}

	@Override
	public Collection findById(Integer idBaseConhecimentoSLA) throws Exception {
		try {
			return this.getDao().findById(idBaseConhecimentoSLA);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdAcordoNivelServico(final Integer idAcordoNivelServico) throws Exception {
		try {
			return this.getDao().findByIdAcordoNivelServico(idAcordoNivelServico);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}
}
