/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citcorpore.bean.AnexoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoRelacionadoDTO;
import br.com.centralit.citcorpore.bean.ComentariosDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoICDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoMidiaSoftwareDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoEmpregadoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.ImportanciaConhecimentoGrupoDTO;
import br.com.centralit.citcorpore.bean.ImportanciaConhecimentoUsuarioDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.LiberacaoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.MudancaBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.NotificacaoDTO;
import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.ProblemaBaseConhecimentoRelacionadoDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.AnexoBaseConhecimentoDAO;
import br.com.centralit.citcorpore.integracao.BaseConhecimentoDAO;
import br.com.centralit.citcorpore.integracao.ComentariosDAO;
import br.com.centralit.citcorpore.integracao.ConhecimentoICDao;
import br.com.centralit.citcorpore.integracao.ConhecimentoMidiaSoftwareDAO;
import br.com.centralit.citcorpore.integracao.ConhecimentoSolicitacaoDao;
import br.com.centralit.citcorpore.integracao.EmpregadoDao;
import br.com.centralit.citcorpore.integracao.HistoricoBaseConhecimentoDAO;
import br.com.centralit.citcorpore.integracao.LiberacaoBaseConhecimentoDao;
import br.com.centralit.citcorpore.integracao.MudancaBaseConhecimentoDao;
import br.com.centralit.citcorpore.integracao.NotificacaoDao;
import br.com.centralit.citcorpore.integracao.ProblemaBaseConhecimentoDAO;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoDao;
import br.com.centralit.citcorpore.mail.MensagemEmail;
import br.com.centralit.citcorpore.util.Arquivo;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.lucene.Lucene;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;

/**
 * ServiceEJB de BaseConhecimento.
 *
 * @author valdoilo.damasceno
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class BaseConhecimentoServiceEjb extends CrudServiceImpl implements BaseConhecimentoService {

	private File pastaDaBaseConhecimento;

	private BaseConhecimentoDAO dao;
    private BaseConhecimentoDAO daoReports;
	private ComentariosDAO comentariosDAO;

	private PerfilAcessoPastaService perfilAcessoPastaService;

	@Override
	protected BaseConhecimentoDAO getDao() {
		if (dao == null) {
			dao = new BaseConhecimentoDAO();
		}
		return dao;
	}

    protected BaseConhecimentoDAO getDao(final String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (daoReports == null) {
				daoReports = new BaseConhecimentoDAO(databaseAlias);
			}
			return daoReports;
		}
		return this.getDao();
    }

	private ComentariosDAO geComentariosDAO() {
		if (comentariosDAO == null) {
			comentariosDAO = new ComentariosDAO();
		}
		return comentariosDAO;
	}

	private Integer idBaseConhecimento;

	@Override
	public Integer getIdBaseConhecimento() {
		return idBaseConhecimento;
	}

	public PerfilAcessoPastaService getPerfilAcessoPastaService() {

		if (this.perfilAcessoPastaService == null) {
			try {
				this.setPerfilAcessoPastaService((PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null));
			} catch (ServiceException servExc) {
				servExc.printStackTrace();
			} catch (Exception exc) {
				exc.printStackTrace();
			}
		}

		return this.perfilAcessoPastaService;
	}

	public void setPerfilAcessoPastaService(PerfilAcessoPastaService perfilAcessoPastaService) {
		this.perfilAcessoPastaService = perfilAcessoPastaService;
	}

	@Override
	public BaseConhecimentoDTO create(BaseConhecimentoDTO baseConhecimentoDto, final Collection<UploadDTO> arquivosUpados, final Integer idEmpresa, final UsuarioDTO usuarioDto) throws Exception {

		BaseConhecimentoDTO baseConhecimentoOld;
		if (baseConhecimentoDto.getIdBaseConhecimento()!=null){
			baseConhecimentoOld = (BaseConhecimentoDTO) this.getDao().restore(baseConhecimentoDto);
		} else {
			baseConhecimentoOld = null;
		}

		NotificacaoDTO notificacaoDto = new NotificacaoDTO();
		final ProblemaBaseConhecimentoRelacionadoDTO problemaBaseConhecimentoRelacionadoDTO = new ProblemaBaseConhecimentoRelacionadoDTO();

		final ControleGEDService controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		String prontuarioGedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD, "N");

		if (!UtilStrings.isNotVazio(prontuarioGedInternoBancoDados)) {
			prontuarioGedInternoBancoDados = "N";
		}

		final String PRONTUARIO_GED_DIRETORIO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "/usr/local/gedCitsmart/");
		final String PRONTUARIO_GED_INTERNO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, "S");

		final TransactionControler transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());

		final AnexoBaseConhecimentoDAO anexoBaseConhecimentoDao = new AnexoBaseConhecimentoDAO();
		final ControleGEDDao controleGEDDao = new ControleGEDDao();
		final HistoricoBaseConhecimentoDAO historicoBaseConhecimentoDao = new HistoricoBaseConhecimentoDAO();
		final ProblemaBaseConhecimentoDAO problemaBaseConhecimentoDAO = new ProblemaBaseConhecimentoDAO();

		try {

			this.getDao().setTransactionControler(transactionControler);
			anexoBaseConhecimentoDao.setTransactionControler(transactionControler);
			controleGEDDao.setTransactionControler(transactionControler);
			historicoBaseConhecimentoDao.setTransactionControler(transactionControler);
			problemaBaseConhecimentoDAO.setTransactionControler(transactionControler);

			transactionControler.start();

			this.validaCreate(baseConhecimentoDto);

			baseConhecimentoDto.setDataInicio(UtilDatas.getDataAtual());
			baseConhecimentoDto.setIdUsuarioAutor(usuarioDto.getIdUsuario());
			baseConhecimentoDto.setArquivado("N");

			if (baseConhecimentoDto.getErroConhecido() == null || baseConhecimentoDto.getErroConhecido().equalsIgnoreCase("")) {
				baseConhecimentoDto.setErroConhecido("N");
			}

			final boolean isAprovaBaseConhecimento = this.usuarioAprovaBaseConhecimento(usuarioDto, baseConhecimentoDto.getIdPasta());

			if (!isAprovaBaseConhecimento) {
				baseConhecimentoDto.setStatus("N");
			} else {
				if (baseConhecimentoDto.getStatus().equalsIgnoreCase("S")) {
					baseConhecimentoDto.setVersao("1.0");
					baseConhecimentoDto.setIdUsuarioAprovador(usuarioDto.getIdUsuario());
					baseConhecimentoDto.setDataPublicacao(UtilDatas.getDataAtual());
				}

			}

			notificacaoDto = this.criarNotificacao(baseConhecimentoDto, transactionControler);

			if (notificacaoDto.getIdNotificacao() != null) {
				baseConhecimentoDto.setIdNotificacao(notificacaoDto.getIdNotificacao());
			}

			baseConhecimentoDto = (BaseConhecimentoDTO) this.getDao().create(baseConhecimentoDto);

			HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDto = new HistoricoBaseConhecimentoDTO();

			Reflexao.copyPropertyValues(baseConhecimentoDto, historicoBaseConhecimentoDto);

			// ENVIAR NOTIFICAO PARA O RESPONSVEL PELO GERENCIAMENTO DE CONHECIMENTO.
            this.enviarEmailNotificacaoConhecimento(baseConhecimentoDto, transactionControler, "C");

			historicoBaseConhecimentoDto.setIdUsuarioAlteracao(usuarioDto.getIdUsuario());

            historicoBaseConhecimentoDto.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());

			historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.create(historicoBaseConhecimentoDto);

			baseConhecimentoDto.setIdHistoricoBaseConhecimento(historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento());

			this.getDao().updateNotNull(baseConhecimentoDto);

			// ENVIAR NOTIFICAO PARA O RESPONSVEL PELO GERENCIAMENTO DE
			// CONHECIMENTO.
			this.enviarEmailNotificacaoConhecimento(baseConhecimentoDto, transactionControler, "C");

			this.criarImportanciaConhecimentoUsuario(baseConhecimentoDto, transactionControler);
			this.criarImportanciaConhecimentoGrupo(baseConhecimentoDto, transactionControler);
			this.criarRelacionamentoEntreConhecimentos(baseConhecimentoDto, transactionControler);
			this.criarComentarios(baseConhecimentoDto, transactionControler);

			// CRIAR RELACIONAMENTO ENTRE UMA BASE DE CONHECIMENTO COM UM PROBLEMA.
			if (baseConhecimentoDto.getIdProblema() != null && baseConhecimentoDto.getIdBaseConhecimento() != null) {
				problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
				problemaBaseConhecimentoRelacionadoDTO.setIdProblema(baseConhecimentoDto.getIdProblema());
				problemaBaseConhecimentoRelacionadoDTO.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
				problemaBaseConhecimentoDAO.create(problemaBaseConhecimentoRelacionadoDTO);
			}

			String pasta = "";
			if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S")) {
				pasta = controleGEDService.getProximaPastaArmazenar();

				File fileDir = new File(PRONTUARIO_GED_DIRETORIO);
				if (!fileDir.exists()) {
					fileDir.mkdirs();
				}

				fileDir = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa);
				if (!fileDir.exists()) {
					fileDir.mkdirs();
				}

				fileDir = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta);
				if (!fileDir.exists()) {
					fileDir.mkdirs();
				}
			}

			final ArrayList<AnexoBaseConhecimentoDTO> listaAnexoBaseConhecimento = new ArrayList<AnexoBaseConhecimentoDTO>();
			if (arquivosUpados != null && !arquivosUpados.isEmpty()) {

				for (final UploadDTO uploadDto : arquivosUpados) {

					ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

					AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

					controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
					controleGEDDTO.setId(baseConhecimentoDto.getIdBaseConhecimento());
					controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
					controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
					controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
					controleGEDDTO.setPasta(pasta);
					controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());

					if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
						controleGEDDTO.setPathArquivo(uploadDto.getPath());
					} else {
						controleGEDDTO.setPathArquivo(null);
					}

					controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

					if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
						if (controleGEDDTO != null) {
							final File arquivo = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + "."
									+ Util.getFileExtension(uploadDto.getNameFile()));
							CriptoUtils.encryptFile(uploadDto.getPath(), PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged", System
									.getProperties().get("user.dir") + Constantes.getValue("CAMINHO_CHAVE_PUBLICA"));
							anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
							arquivo.delete();
						}
					}

                    anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
                    if (controleGEDDTO != null) {
                        anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
                        anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
                    }
                    anexoBaseConhecimento.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
                    anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
					// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                    try {
                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                    } catch (final Exception e) {
                        e.printStackTrace();
                    }

					anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

					listaAnexoBaseConhecimento.add(anexoBaseConhecimento);
				}
			} else {
				System.out.println("BaseConhecimento - A arquivosUpados esta vazia!");
			}

            // @Author euler.ramos
			// INDEXAO LUCENE
            // Indexando Base de Conhecimento
            final Lucene lucene = new Lucene();
			// Publicada, No arquivada e No excluda!
            lucene.indexarBaseConhecimento(baseConhecimentoDto, listaAnexoBaseConhecimento);

			transactionControler.commit();
		} catch (final Exception e) {
			e.printStackTrace();
			System.err.println("GED BaseConhecimento - Erro ao gravar Arquivo ged e gravar o ged no banco de dados: " + e);
			this.rollbackTransaction(transactionControler, e);
		} finally {
			try {
				transactionControler.close();
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}
		}

		return baseConhecimentoDto;
	}

	@Override
	public void update(final BaseConhecimentoDTO baseConhecimentoDto, final Collection<UploadDTO> arquivosUpados, final Integer idEmpresa, final UsuarioDTO usuarioDto) throws ServiceException,
			Exception {

		BaseConhecimentoDTO baseConhecimentoOld;
		if (baseConhecimentoDto.getIdBaseConhecimento()!=null){
			baseConhecimentoOld = (BaseConhecimentoDTO) this.getDao().restore(baseConhecimentoDto);
		} else {
			baseConhecimentoOld = null;
		}

		if (baseConhecimentoOld!=null){
			baseConhecimentoDto.setIdBaseConhecimentoOrigem(baseConhecimentoOld.getIdBaseConhecimentoOrigem());
		}

		// @Author euler.ramos
		final Lucene lucene = new Lucene();
		final ControleGEDService controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		final BaseConhecimentoRelacionadoService baseConhecimentoRelacionadoService = (BaseConhecimentoRelacionadoService) ServiceLocator.getInstance().getService(
				BaseConhecimentoRelacionadoService.class, null);

		NotificacaoDTO notificacaoDto = new NotificacaoDTO();
		HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDto = new HistoricoBaseConhecimentoDTO();
		final ProblemaBaseConhecimentoRelacionadoDTO problemaBaseConhecimentoRelacionadoDTO = new ProblemaBaseConhecimentoRelacionadoDTO();

		String prontuarioGedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD, "N");

		if (!UtilStrings.isNotVazio(prontuarioGedInternoBancoDados)) {
			prontuarioGedInternoBancoDados = "N";
		}

		final String PRONTUARIO_GED_DIRETORIO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "/usr/local/gedCitsmart/");
		final String PRONTUARIO_GED_INTERNO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, "S");

		final AnexoBaseConhecimentoDAO anexoBaseConhecimentoDao = new AnexoBaseConhecimentoDAO();
		final ControleGEDDao controleGEDDao = new ControleGEDDao();
		final HistoricoBaseConhecimentoDAO historicoBaseConhecimentoDao = new HistoricoBaseConhecimentoDAO();
		final ProblemaBaseConhecimentoDAO problemaBaseConhecimentoDAO = new ProblemaBaseConhecimentoDAO();
		final ConhecimentoICDao conhecimentoICDao = new ConhecimentoICDao();

		final TransactionControler transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {

			this.getDao().setTransactionControler(transactionControler);
			anexoBaseConhecimentoDao.setTransactionControler(transactionControler);
			controleGEDDao.setTransactionControler(transactionControler);
			historicoBaseConhecimentoDao.setTransactionControler(transactionControler);
			problemaBaseConhecimentoDAO.setTransactionControler(transactionControler);
			conhecimentoICDao.setTransactionControler(transactionControler);

			transactionControler.start();

			BaseConhecimentoDTO novaBaseConhecimento = this.atribuirValoresNovaBaseConhecimento(baseConhecimentoDto);

			final String status = baseConhecimentoOld.getStatus();

			String pasta = "";
			if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S")) {
				pasta = controleGEDService.getProximaPastaArmazenar();

				File fileDir = new File(PRONTUARIO_GED_DIRETORIO);
				if (!fileDir.exists()) {
					fileDir.mkdirs();
				}

				fileDir = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa);
				if (!fileDir.exists()) {
					fileDir.mkdirs();
				}

				fileDir = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta);
				if (!fileDir.exists()) {
					fileDir.mkdirs();
				}
			}

			final boolean isAprovaBaseConhecimento = this.usuarioAprovaBaseConhecimento(usuarioDto, baseConhecimentoDto.getIdPasta());

			// A BASE IR SER APROVADA
            if (novaBaseConhecimento.getStatus() != null && isAprovaBaseConhecimento && novaBaseConhecimento.getStatus().equalsIgnoreCase("S")) {
                if (novaBaseConhecimento.getVersao() != null && !novaBaseConhecimento.getVersao().equals("")) {
                    final Double novaVersao = Double.parseDouble(novaBaseConhecimento.getVersao()) + 0.1;

					novaBaseConhecimento.setVersao(novaVersao.toString().substring(0, 3));
					novaBaseConhecimento.setTitulo(baseConhecimentoDto.getTitulo().split(" - v")[0] + " - v" + novaBaseConhecimento.getVersao());
				} else {
					novaBaseConhecimento.setVersao("1.0");
				}

				// BASE NO APROVADA - VAI SER APROVADA
                if (baseConhecimentoDto.getIdBaseConhecimentoPai() != null || status.equalsIgnoreCase("N")) {
                    try {
                        novaBaseConhecimento.setStatus("S");
                        novaBaseConhecimento.setIdBaseConhecimentoPai(null);
                        novaBaseConhecimento.setIdUsuarioAprovador(usuarioDto.getIdUsuario());
                        novaBaseConhecimento.setDataPublicacao(UtilDatas.getDataAtual());

						if (novaBaseConhecimento.getErroConhecido() == null || novaBaseConhecimento.getErroConhecido().equalsIgnoreCase("")) {
							novaBaseConhecimento.setErroConhecido("N");
						}

						notificacaoDto = this.criarNotificacao(novaBaseConhecimento, transactionControler);

						if (notificacaoDto.getIdNotificacao() != null) {
							novaBaseConhecimento.setIdNotificacao(notificacaoDto.getIdNotificacao());
						}

						novaBaseConhecimento = (BaseConhecimentoDTO) this.getDao().create(novaBaseConhecimento);

						if (baseConhecimentoDto.getIdBaseConhecimentoPai() != null) {

							final BaseConhecimentoDTO baseConhecimentoPai = new BaseConhecimentoDTO();

							baseConhecimentoPai.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimentoPai());
							baseConhecimentoPai.setStatus("S");

							this.getDao().updateNotNull(baseConhecimentoPai);

						}

						Reflexao.copyPropertyValues(novaBaseConhecimento, historicoBaseConhecimentoDto);

						historicoBaseConhecimentoDto.setIdUsuarioAlteracao(usuarioDto.getIdUsuario());

						historicoBaseConhecimentoDto.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());

						if (historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento() == null) {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.create(historicoBaseConhecimentoDto);
						} else {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.createWithID(historicoBaseConhecimentoDto);
						}

						if (novaBaseConhecimento.getIdHistoricoBaseConhecimento() == null) {

							novaBaseConhecimento.setIdHistoricoBaseConhecimento(historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento());

							this.getDao().updateNotNull(novaBaseConhecimento);
						}

						// ENVIAR NOTIFICAO PARA O RESPONSVEL PELO GERENCIAMENTO DE CONHECIMENTO.
                        this.enviarEmailNotificacaoConhecimento(baseConhecimentoDto, transactionControler, "U");

						idBaseConhecimento = novaBaseConhecimento.getIdBaseConhecimento();

						this.criarImportanciaConhecimentoUsuario(novaBaseConhecimento, transactionControler);
						this.criarImportanciaConhecimentoGrupo(novaBaseConhecimento, transactionControler);
						this.criarRelacionamentoEntreConhecimentos(novaBaseConhecimento, transactionControler);
						this.criarComentarios(novaBaseConhecimento, transactionControler);
						this.criarRelacionamentoMidiaDefinitiva(baseConhecimentoDto, novaBaseConhecimento, transactionControler);

						// CRIAR RELACIONAMENTO ENTRE UMA BASE DE CONHECIMENTO COM UM PROBLEMA.
						if (novaBaseConhecimento.getIdProblema() != null && novaBaseConhecimento.getIdBaseConhecimento() != null) {
							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
							problemaBaseConhecimentoRelacionadoDTO.setIdProblema(novaBaseConhecimento.getIdProblema());
							problemaBaseConhecimentoRelacionadoDTO.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.create(problemaBaseConhecimentoRelacionadoDTO);
						}

						final ArrayList<AnexoBaseConhecimentoDTO> listaAnexoBaseConhecimento = new ArrayList<AnexoBaseConhecimentoDTO>();
						if (arquivosUpados != null && !arquivosUpados.isEmpty()) {

							for (final UploadDTO uploadDto : arquivosUpados) {

								if (uploadDto.getTemporario().equalsIgnoreCase("S")) {

									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
									AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
										controleGEDDTO.setPathArquivo(uploadDto.getPath());
									} else {
										controleGEDDTO.setPathArquivo(null);
									}

									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {

										if (controleGEDDTO != null) {

											final File arquivo = new File(PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + "."
													+ Util.getFileExtension(uploadDto.getNameFile()));

											CriptoUtils.encryptFile(uploadDto.getPath(), PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged", System
													.getProperties().get("user.dir") + Constantes.getValue("CAMINHO_CHAVE_PUBLICA"));

											anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");

											arquivo.delete();
										}
									}

                                    anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
                                    if (controleGEDDTO != null) {
                                        anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
                                        anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
                                    }
                                    anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
                                    anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                                    try {
                                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                                    } catch (final Exception e) {
                                        e.printStackTrace();
                                    }

									anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

									listaAnexoBaseConhecimento.add(anexoBaseConhecimento);

								} else {

									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

									AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());
									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									final File arquivoAntigo = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + uploadDto.getPath().substring(3) + ".ged");

									this.copiarArquivo(arquivoAntigo, PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");

									anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
									anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
									anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
									anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
									anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
									anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());

									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                                    try {
                                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                                    } catch (final Exception e) {
                                        e.printStackTrace();
                                    }

									anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

									listaAnexoBaseConhecimento.add(anexoBaseConhecimento);
								}
							}
						}

						// @Author euler.ramos
						lucene.indexarBaseConhecimento(novaBaseConhecimento, listaAnexoBaseConhecimento);

						baseConhecimentoRelacionadoService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);
//						importanciaConhecimentoUsuarioService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);
//						importanciaConhecimentoGrupoService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);
//						conhecimentoProblemaDao.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
//						conhecimentoICDao.updateIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), idBaseConhecimento);
						final SolicitacaoServicoDao solicitacaoServicoDao = new SolicitacaoServicoDao();
						final ConhecimentoSolicitacaoDao conhecimentoSolicitacaoDao = new ConhecimentoSolicitacaoDao();
						solicitacaoServicoDao.setTransactionControler(transactionControler);
						conhecimentoSolicitacaoDao.setTransactionControler(transactionControler);

						final List<SolicitacaoServicoDTO> listaSolicitacoes = solicitacaoServicoDao.listaSolicitacoesRelacionadasBaseconhecimento(baseConhecimentoDto.getIdBaseConhecimento());

//						conhecimentoSolicitacaoDao.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());

						if (listaSolicitacoes != null) {
							for (final SolicitacaoServicoDTO solicitacaoServicoDTO : listaSolicitacoes) {
								final ConhecimentoSolicitacaoDTO obj = new ConhecimentoSolicitacaoDTO();
								obj.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
								obj.setIdSolicitacaoServico(solicitacaoServicoDTO.getIdSolicitacaoServico());
								conhecimentoSolicitacaoDao.create(obj);
							}
						}

						this.getDao().delete(baseConhecimentoDto);

						// Excluir Base de Conhecimento Antiga do ndice, atendendo solicitao: 111236 nessa excluso os anexos so excluidos juntamente.
                        lucene.excluirBaseConhecimento(baseConhecimentoDto, true);

						// TODO EXCLUIR COMENTRIOS

						// TODO EXCLUIR NOTIFICAES

						// TODO EXCLUIR IMPORTNCIA CONHECIMENTO

						// TODO EXCLUIR COMENTRIOS

						// TODO EXCLUIR CONHECIMENTOPROBLEMA

						// EXCLUO OS ANEXOS DA BASE DE CONHECIMENTO ANTIGA.

						final Collection<AnexoBaseConhecimentoDTO> anexosBaseConhecimento = anexoBaseConhecimentoDao.consultarAnexosDaBaseConhecimento(baseConhecimentoDto);
						if (anexosBaseConhecimento != null && !anexosBaseConhecimento.isEmpty()) {
							for (final AnexoBaseConhecimentoDTO anexo : anexosBaseConhecimento) {
								anexoBaseConhecimentoDao.delete(anexo);
								this.deleteDir(new File(anexo.getLink()));
							}
						}

						// EXCLUO OS GEDS DA BASE DE CONHECIMENTO ANTIGA.

						final Collection<ControleGEDDTO> gedsBaseConhecimento = controleGEDDao.listByIdTabelaAndIdBaseConhecimento(ControleGEDDTO.TABELA_BASECONHECIMENTO,
								baseConhecimentoDto.getIdBaseConhecimento());
						if (gedsBaseConhecimento != null && !gedsBaseConhecimento.isEmpty()) {
							for (final ControleGEDDTO ged : gedsBaseConhecimento) {
								controleGEDDao.delete(ged);
							}
						}

						transactionControler.commit();

					} catch (final Exception e) {
						throw e;
					}

                } else {
					// BASE PUBLICADA, ALTERADA VAI SER PUBLICADA NOVAMENTE COM OUTRA VERSO
                    try {

                    	if (baseConhecimentoDto.getIdBaseConhecimentoOrigem()!=null&&baseConhecimentoDto.getIdBaseConhecimentoOrigem().intValue()>0) {
                			novaBaseConhecimento.setIdBaseConhecimentoOrigem(baseConhecimentoDto.getIdBaseConhecimentoOrigem());
                		} else {
                			novaBaseConhecimento.setIdBaseConhecimentoOrigem(baseConhecimentoDto.getIdBaseConhecimento());
                		}

                    	novaBaseConhecimento.setIdUsuarioAprovador(usuarioDto.getIdUsuario());
                        novaBaseConhecimento.setDataPublicacao(UtilDatas.getDataAtual());

						notificacaoDto = this.criarNotificacao(novaBaseConhecimento, transactionControler);

						if (notificacaoDto.getIdNotificacao() != null) {
							novaBaseConhecimento.setIdNotificacao(notificacaoDto.getIdNotificacao());
						}

						novaBaseConhecimento = (BaseConhecimentoDTO) this.getDao().create(novaBaseConhecimento);

						Reflexao.copyPropertyValues(novaBaseConhecimento, historicoBaseConhecimentoDto);

						historicoBaseConhecimentoDto.setIdUsuarioAlteracao(usuarioDto.getIdUsuario());

						historicoBaseConhecimentoDto.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());

						if (historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento() == null) {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.create(historicoBaseConhecimentoDto);
						} else {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.createWithID(historicoBaseConhecimentoDto);
						}

						if (novaBaseConhecimento.getIdHistoricoBaseConhecimento() == null) {

							novaBaseConhecimento.setIdHistoricoBaseConhecimento(historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento());

							this.getDao().updateNotNull(novaBaseConhecimento);
						}

						//baseConhecimentoDto.setArquivado("S");
						baseConhecimentoOld.setArquivado("S");

						this.getDao().updateNotNull(baseConhecimentoOld);

						lucene.excluirBaseConhecimento(baseConhecimentoDto, true);

						// ENVIAR NOTIFICAO PARA O RESPONSVEL PELO GERENCIAMENTO DE CONHECIMENTO.
                        this.enviarEmailNotificacaoConhecimento(baseConhecimentoDto, transactionControler, "U");

						idBaseConhecimento = novaBaseConhecimento.getIdBaseConhecimento();

						this.criarImportanciaConhecimentoUsuario(novaBaseConhecimento, transactionControler);
						this.criarImportanciaConhecimentoGrupo(novaBaseConhecimento, transactionControler);
						this.criarRelacionamentoEntreConhecimentos(novaBaseConhecimento, transactionControler);
						this.criarComentarios(novaBaseConhecimento, transactionControler);
						this.criarRelacionamentoMidiaDefinitiva(baseConhecimentoDto, novaBaseConhecimento, transactionControler);

						// CRIAR RELACIONAMENTO ENTRE UMA BASE DE CONHECIMENTO COM UM PROBLEMA.
						if (novaBaseConhecimento.getIdProblema() != null && novaBaseConhecimento.getIdBaseConhecimento() != null) {

							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoRelacionadoDTO.setIdProblema(novaBaseConhecimento.getIdProblema());
							problemaBaseConhecimentoRelacionadoDTO.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.create(problemaBaseConhecimentoRelacionadoDTO);
						}

						final ArrayList<AnexoBaseConhecimentoDTO> listaAnexoBaseConhecimento = new ArrayList<AnexoBaseConhecimentoDTO>();
						if (arquivosUpados != null && !arquivosUpados.isEmpty()) {
							for (final UploadDTO uploadDto : arquivosUpados) {
								if (uploadDto.getTemporario().equalsIgnoreCase("S")) {

									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
									AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
										controleGEDDTO.setPathArquivo(uploadDto.getPath());
									} else {
										controleGEDDTO.setPathArquivo(null);
									}

									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
										if (controleGEDDTO != null) {
											final File arquivo = new File(PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + "."
													+ Util.getFileExtension(uploadDto.getNameFile()));
											CriptoUtils.encryptFile(uploadDto.getPath(), PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged", System
													.getProperties().get("user.dir") + Constantes.getValue("CAMINHO_CHAVE_PUBLICA"));
											anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
											arquivo.delete();
										}
									}

                                    anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
                                    if (controleGEDDTO != null) {
                                        anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
                                        anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
                                    }
                                    anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
                                    anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                                    try {
                                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                                    } catch (final Exception e) {
                                        e.printStackTrace();
                                    }

									anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

									listaAnexoBaseConhecimento.add(anexoBaseConhecimento);
								} else {
									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

									AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());
									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									final File arquivoAntigo = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + uploadDto.getPath().substring(3) + ".ged");

									this.copiarArquivo(arquivoAntigo, PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");

                                    anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
                                    anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
                                    anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
                                    anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
                                    anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
                                    anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                                    try {
                                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                                    } catch (final Exception e) {
                                        e.printStackTrace();
                                    }

									anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

									listaAnexoBaseConhecimento.add(anexoBaseConhecimento);
								}
							}
						}

						// Publicada, No arquivada e No excluda!
                        lucene.indexarBaseConhecimento(novaBaseConhecimento, listaAnexoBaseConhecimento);

						transactionControler.commit();

					} catch (final Exception e) {
						throw e;
					}
				}

				// A BASE NO SER PUBLICADA
            } else {
				// BASE NO APROVADA E QUE CONTINUAR NO APROVADA
                if (status.equalsIgnoreCase("N")) {
                    try {
                        notificacaoDto = this.criarNotificacao(novaBaseConhecimento, transactionControler);

						if (notificacaoDto.getIdNotificacao() != null) {
							novaBaseConhecimento.setIdNotificacao(notificacaoDto.getIdNotificacao());
						}

						novaBaseConhecimento = (BaseConhecimentoDTO) this.getDao().create(novaBaseConhecimento);

						Reflexao.copyPropertyValues(novaBaseConhecimento, historicoBaseConhecimentoDto);

						historicoBaseConhecimentoDto.setIdUsuarioAlteracao(usuarioDto.getIdUsuario());

						historicoBaseConhecimentoDto.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());

						if (historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento() == null) {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.create(historicoBaseConhecimentoDto);
						} else {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.createWithID(historicoBaseConhecimentoDto);
						}

						if (novaBaseConhecimento.getIdHistoricoBaseConhecimento() == null) {
							novaBaseConhecimento.setIdHistoricoBaseConhecimento(historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento());
							this.getDao().updateNotNull(novaBaseConhecimento);
						}

						// ENVIAR NOTIFICAO PARA O RESPONSVEL PELO GERENCIAMENTO DE CONHECIMENTO.
                        this.enviarEmailNotificacaoConhecimento(baseConhecimentoDto, transactionControler, "U");

                        // CRIAR RELACIONAMENTO ENTRE UMA BASE DE CONHECIMENTO COM UM PROBLEMA.
						if (novaBaseConhecimento.getIdProblema() != null && novaBaseConhecimento.getIdBaseConhecimento() != null) {

							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoRelacionadoDTO.setIdProblema(novaBaseConhecimento.getIdProblema());
							problemaBaseConhecimentoRelacionadoDTO.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.create(problemaBaseConhecimentoRelacionadoDTO);
						}

						if (arquivosUpados != null && !arquivosUpados.isEmpty()) {
							for (final UploadDTO uploadDto : arquivosUpados) {
								if (uploadDto.getTemporario().equalsIgnoreCase("S")) {

									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
									AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
										controleGEDDTO.setPathArquivo(uploadDto.getPath());
									} else {
										controleGEDDTO.setPathArquivo(null);
									}

									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {

										if (controleGEDDTO != null) {
											final File arquivo = new File(PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + "."
													+ Util.getFileExtension(uploadDto.getNameFile()));
											CriptoUtils.encryptFile(uploadDto.getPath(), PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged", System
													.getProperties().get("user.dir") + Constantes.getValue("CAMINHO_CHAVE_PUBLICA"));
											anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
											arquivo.delete();
										}
									}

                                    anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
                                    if (controleGEDDTO != null) {
                                        anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
                                        anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
                                    }
                                    anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
                                    anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                                    try {
                                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                                    } catch (final Exception e) {
                                        e.printStackTrace();
                                    }

									anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

								} else {

									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
									AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();
									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());
									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									final File arquivoAntigo = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + uploadDto.getPath().substring(3) + ".ged");

									this.copiarArquivo(arquivoAntigo, PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");

                                    anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
                                    anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
                                    anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
                                    anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
                                    anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
                                    anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									// Obtendo o contedo do arquivo armazenado em disco! O Service no traz este campo preenchido no list
                                    try {
                                        final Arquivo arquivo = new Arquivo(controleGEDDTO);
                                        anexoBaseConhecimento.setTextoDocumento(arquivo.getConteudo());
                                    } catch (final Exception e) {
                                        e.printStackTrace();
                                    }

									anexoBaseConhecimento = (AnexoBaseConhecimentoDTO) anexoBaseConhecimentoDao.create(anexoBaseConhecimento);
								}
							}
						}

						// EXCLUO BASE DE CONHECIMENTO ANTIGA
						baseConhecimentoRelacionadoService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);
//						importanciaConhecimentoUsuarioService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);
//						importanciaConhecimentoGrupoService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);
//						conhecimentoProblemaDao.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
//						conhecimentoICDao.updateIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), novaBaseConhecimento.getIdBaseConhecimento());

						final SolicitacaoServicoDao solicitacaoServicoDao = new SolicitacaoServicoDao();
						final ConhecimentoSolicitacaoDao conhecimentoSolicitacaoDao = new ConhecimentoSolicitacaoDao();
						solicitacaoServicoDao.setTransactionControler(transactionControler);
						conhecimentoSolicitacaoDao.setTransactionControler(transactionControler);

						final List<SolicitacaoServicoDTO> listaSolicitacoes = solicitacaoServicoDao.listaSolicitacoesRelacionadasBaseconhecimento(baseConhecimentoDto.getIdBaseConhecimento());

//						conhecimentoSolicitacaoDao.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());

						if (listaSolicitacoes != null) {
							for (final SolicitacaoServicoDTO solicitacaoServicoDTO : listaSolicitacoes) {
								final ConhecimentoSolicitacaoDTO obj = new ConhecimentoSolicitacaoDTO();
								obj.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
								obj.setIdSolicitacaoServico(solicitacaoServicoDTO.getIdSolicitacaoServico());
								conhecimentoSolicitacaoDao.create(obj);
							}
						}

						this.criarRelacionamentoMidiaDefinitiva(baseConhecimentoDto, novaBaseConhecimento, transactionControler);

						this.getDao().delete(baseConhecimentoDto);
						lucene.excluirBaseConhecimento(baseConhecimentoDto, true);

						// EXCLUO OS ANEXOS DA BASE DE CONHECIMENTO ANTIGA.

						final Collection<AnexoBaseConhecimentoDTO> anexosBaseConhecimento = anexoBaseConhecimentoDao.consultarAnexosDaBaseConhecimento(baseConhecimentoDto);

						if (anexosBaseConhecimento != null && !anexosBaseConhecimento.isEmpty()) {

							for (final AnexoBaseConhecimentoDTO anexo : anexosBaseConhecimento) {
								anexoBaseConhecimentoDao.delete(anexo);
								this.deleteDir(new File(anexo.getLink()));
							}
						}

						// EXCLUO OS GEDS DA BASE DE CONHECIMENTO ANTIGA.

						final Collection<ControleGEDDTO> gedsBaseConhecimento = controleGEDDao.listByIdTabelaAndIdBaseConhecimento(ControleGEDDTO.TABELA_BASECONHECIMENTO,
								baseConhecimentoDto.getIdBaseConhecimento());

						if (gedsBaseConhecimento != null && !gedsBaseConhecimento.isEmpty()) {
							for (final ControleGEDDTO ged : gedsBaseConhecimento) {
								controleGEDDao.delete(ged);
							}
						}

						idBaseConhecimento = novaBaseConhecimento.getIdBaseConhecimento();

						transactionControler.commit();

                    } catch (final Exception e) {
                        throw e;
                    }
                } else {
					// BASE APROVADA, ALTERADA NO SER PUBLICADA
                    novaBaseConhecimento.setStatus("N");

					novaBaseConhecimento.setIdBaseConhecimento(null);
					novaBaseConhecimento.setIdBaseConhecimentoPai(baseConhecimentoDto.getIdBaseConhecimento());

					try {
						novaBaseConhecimento = (BaseConhecimentoDTO) this.getDao().create(novaBaseConhecimento);

						notificacaoDto = this.criarNotificacao(novaBaseConhecimento, transactionControler);

						if (notificacaoDto.getIdNotificacao() != null) {
							novaBaseConhecimento.setIdNotificacao(notificacaoDto.getIdNotificacao());
						}

						Reflexao.copyPropertyValues(novaBaseConhecimento, historicoBaseConhecimentoDto);

						historicoBaseConhecimentoDto.setIdUsuarioAlteracao(usuarioDto.getIdUsuario());

						historicoBaseConhecimentoDto.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());

						if (historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento() == null) {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.create(historicoBaseConhecimentoDto);
						} else {
							historicoBaseConhecimentoDto = (HistoricoBaseConhecimentoDTO) historicoBaseConhecimentoDao.createWithID(historicoBaseConhecimentoDto);
						}

						if (novaBaseConhecimento.getIdHistoricoBaseConhecimento() == null) {
							novaBaseConhecimento.setIdHistoricoBaseConhecimento(historicoBaseConhecimentoDto.getIdHistoricoBaseConhecimento());
						}

						this.getDao().updateNotNull(novaBaseConhecimento);

						//this.getDao().restore(baseConhecimentoDto);
						this.getDao().restore(baseConhecimentoOld);

						//baseConhecimentoDto.setArquivado("S");
						baseConhecimentoOld.setArquivado("S");

						//this.getDao().updateNotNull(baseConhecimentoDto);
						this.getDao().updateNotNull(baseConhecimentoOld);

						lucene.excluirBaseConhecimento(baseConhecimentoDto, true);

						this.enviarEmailNotificacaoConhecimento(baseConhecimentoDto, transactionControler, "U");

						// CRIAR RELACIONAMENTO ENTRE UMA BASE DE CONHECIMENTO COM UM PROBLEMA.
						if (novaBaseConhecimento.getIdProblema() != null && novaBaseConhecimento.getIdBaseConhecimento() != null) {

							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoRelacionadoDTO.setIdProblema(novaBaseConhecimento.getIdProblema());
							problemaBaseConhecimentoRelacionadoDTO.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
							problemaBaseConhecimentoDAO.create(problemaBaseConhecimentoRelacionadoDTO);
						}

						idBaseConhecimento = novaBaseConhecimento.getIdBaseConhecimento();

						if (arquivosUpados != null && !arquivosUpados.isEmpty()) {

							for (final UploadDTO uploadDto : arquivosUpados) {

								if (uploadDto.getTemporario().equalsIgnoreCase("S")) {

									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

									final AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {
										controleGEDDTO.setPathArquivo(uploadDto.getPath());
									} else {
										controleGEDDTO.setPathArquivo(null);
									}

									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) {

										if (controleGEDDTO != null) {

											final File arquivo = new File(PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + "."
													+ Util.getFileExtension(uploadDto.getNameFile()));

											CriptoUtils.encryptFile(uploadDto.getPath(), PRONTUARIO_GED_DIRETORIO + "/" + 1 + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged", System
													.getProperties().get("user.dir") + Constantes.getValue("CAMINHO_CHAVE_PUBLICA"));

											anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");

											arquivo.delete();

										}
									}

									anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
									if (controleGEDDTO != null) {
										anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
										anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
									}
									anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
									anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									anexoBaseConhecimentoDao.create(anexoBaseConhecimento);

								} else {
									ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

									final AnexoBaseConhecimentoDTO anexoBaseConhecimento = new AnexoBaseConhecimentoDTO();

									controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BASECONHECIMENTO);
									controleGEDDTO.setId(novaBaseConhecimento.getIdBaseConhecimento());
									controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
									controleGEDDTO.setDescricaoArquivo(uploadDto.getDescricao());
									controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDto.getNameFile()));
									controleGEDDTO.setPasta(pasta);
									controleGEDDTO.setNomeArquivo(uploadDto.getNameFile());

									controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);

									final File arquivoAntigo = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + uploadDto.getPath().substring(3) + ".ged");

									this.copiarArquivo(arquivoAntigo, PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");

									anexoBaseConhecimento.setLink(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged");
									anexoBaseConhecimento.setDataInicio(UtilDatas.getDataAtual());
									anexoBaseConhecimento.setNomeAnexo(controleGEDDTO.getNomeArquivo());
									anexoBaseConhecimento.setExtensao(controleGEDDTO.getExtensaoArquivo());
									anexoBaseConhecimento.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
									anexoBaseConhecimento.setDescricao(uploadDto.getDescricao());
									anexoBaseConhecimentoDao.create(anexoBaseConhecimento);
								}
							}
						}

						transactionControler.commit();

					} catch (final Exception e) {
						throw e;
					}
				}
			}
		} catch (final Exception e) {
			this.rollbackTransaction(transactionControler, e);
			e.printStackTrace();
		} finally {
			try {
				transactionControler.close();
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}
		}

	}

	private void criarRelacionamentoMidiaDefinitiva(BaseConhecimentoDTO baseConhecimento, BaseConhecimentoDTO novaBaseConhecimento, TransactionControler transactionControler) throws PersistenceException {
		ConhecimentoMidiaSoftwareDAO conhecimentoMidiaSoftwareDAO = new ConhecimentoMidiaSoftwareDAO();
		conhecimentoMidiaSoftwareDAO.setTransactionControler(transactionControler);

		final List<ConhecimentoMidiaSoftwareDTO> listaConhecimentos = (List<ConhecimentoMidiaSoftwareDTO>) conhecimentoMidiaSoftwareDAO.findByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

		conhecimentoMidiaSoftwareDAO.deleteByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

		if (listaConhecimentos != null) {
			for (final ConhecimentoMidiaSoftwareDTO conhecimentoMidiaSoftwareDTO : listaConhecimentos) {
				conhecimentoMidiaSoftwareDTO.setIdBaseConhecimento(novaBaseConhecimento.getIdBaseConhecimento());
				conhecimentoMidiaSoftwareDAO.create(conhecimentoMidiaSoftwareDTO);
			}
		}
	}

	@Override
	public void excluir(final BaseConhecimentoDTO baseConhecimentoBean, final boolean isAprovaBaseConhecimento) throws Exception {

		if (isAprovaBaseConhecimento) {

			final Lucene lucene = new Lucene();
			lucene.excluirBaseConhecimento(baseConhecimentoBean, true);

			this.excluirBaseConhecimentoComentarios(baseConhecimentoBean);

			this.excluirBaseConhecimento(baseConhecimentoBean);

			this.enviarEmailNotificacaoConhecimento(baseConhecimentoBean, null, "D");

		}
	}

	/**
	 * Atribui os valores dos atributos da nova Base de Conhecimento a ser cadastrada.
	 *
	 * @return BaseConhecimentoDTO
	 * @author breno.guimaraes
	 * @throws Exception
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 */
	private BaseConhecimentoDTO atribuirValoresNovaBaseConhecimento(final BaseConhecimentoDTO baseConhecimento) throws ServiceException, Exception {
		final BaseConhecimentoDTO novaBaseConhecimentoBean = new BaseConhecimentoDTO();

		novaBaseConhecimentoBean.setIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());
		novaBaseConhecimentoBean.setIdBaseConhecimentoOrigem(baseConhecimento.getIdBaseConhecimentoOrigem());
		novaBaseConhecimentoBean.setTitulo(baseConhecimento.getTitulo());
		novaBaseConhecimentoBean.setConteudo(baseConhecimento.getConteudo());
		novaBaseConhecimentoBean.setDataExpiracao(baseConhecimento.getDataExpiracao());
		novaBaseConhecimentoBean.setDataInicio(UtilDatas.getDataAtual());
		novaBaseConhecimentoBean.setIdPasta(baseConhecimento.getIdPasta());
		novaBaseConhecimentoBean.setStatus(baseConhecimento.getStatus());
		novaBaseConhecimentoBean.setIdUsuarioAutor(baseConhecimento.getIdUsuarioAutor());
		novaBaseConhecimentoBean.setComentarios(baseConhecimento.getComentarios());
		novaBaseConhecimentoBean.setListImportanciaConhecimentoUsuario(baseConhecimento.getListImportanciaConhecimentoUsuario());
		novaBaseConhecimentoBean.setListImportanciaConhecimentoGrupo(baseConhecimento.getListImportanciaConhecimentoGrupo());
		novaBaseConhecimentoBean.setJustificativaObservacao(baseConhecimento.getJustificativaObservacao());
		novaBaseConhecimentoBean.setFonteReferencia(baseConhecimento.getFonteReferencia());
		novaBaseConhecimentoBean.setIdNotificacao(baseConhecimento.getIdNotificacao());
		novaBaseConhecimentoBean.setListaDeUsuarioNotificacao(baseConhecimento.getListaDeUsuarioNotificacao());
		novaBaseConhecimentoBean.setListaDeGrupoNotificacao(baseConhecimento.getListaDeGrupoNotificacao());
		novaBaseConhecimentoBean.setTituloNotificacao(baseConhecimento.getTituloNotificacao());
		novaBaseConhecimentoBean.setTipoNotificacao(baseConhecimento.getTipoNotificacao());
		novaBaseConhecimentoBean.setListBaseConhecimentoRelacionado(baseConhecimento.getListBaseConhecimentoRelacionado());
		novaBaseConhecimentoBean.setFaq(baseConhecimento.getFaq());
		novaBaseConhecimentoBean.setOrigem(baseConhecimento.getOrigem());
		novaBaseConhecimentoBean.setIdHistoricoBaseConhecimento(baseConhecimento.getIdHistoricoBaseConhecimento());
		novaBaseConhecimentoBean.setArquivado(baseConhecimento.getArquivado());
		novaBaseConhecimentoBean.setIdBaseConhecimentoPai(baseConhecimento.getIdBaseConhecimentoPai());
		novaBaseConhecimentoBean.setPrivacidade(baseConhecimento.getPrivacidade());
		novaBaseConhecimentoBean.setSituacao(baseConhecimento.getSituacao());
		novaBaseConhecimentoBean.setGerenciamentoDisponibilidade(baseConhecimento.getGerenciamentoDisponibilidade());
		novaBaseConhecimentoBean.setDireitoAutoral(baseConhecimento.getDireitoAutoral());
		novaBaseConhecimentoBean.setLegislacao(baseConhecimento.getLegislacao());
		novaBaseConhecimentoBean.setErroConhecido(baseConhecimento.getErroConhecido());
		novaBaseConhecimentoBean.setIdProblema(baseConhecimento.getIdProblema());
		novaBaseConhecimentoBean.setIdHistoricoBaseConhecimento(null);
		novaBaseConhecimentoBean.setIdsCategoriasOcorrenciasVinculadas(baseConhecimento.getIdsCategoriasOcorrenciasVinculadas());
		novaBaseConhecimentoBean.setTipoDocumento(baseConhecimento.getTipoDocumento());

		final String versao = ((BaseConhecimentoDTO) this.getDao().restore(baseConhecimento)).getVersao();
		novaBaseConhecimentoBean.setVersao(versao);

		return novaBaseConhecimentoBean;
	}

    /**
	 * Exclui diretrio e arquivos.
	 *
	 * @param dir
	 * @author valdoilo.damasceno
	 */
	public boolean deleteDir(final File dir) {
		if (dir.isDirectory()) {
			final String[] children = dir.list();
			if (children != null && children.length > 0) {
				for (final String element : children) {
					final boolean success = this.deleteDir(new File(dir, element));
					if (!success) {
						return false;
					}
				}
			}
		}
		return dir.delete();
	}

    /**
	 * Copia Arquivo do diretório temporário para Diretório definitivo.
	 *
	 * @param fonte
	 * @param destino
	 * @throws IOException
	 * @author valdoilo.damasceno
	 */
    public void copiarArquivo(final File fonte, final String destino) throws IOException {
        InputStream in;
        try {
            in = new FileInputStream(fonte);
            final OutputStream out = new FileOutputStream(new File(destino));

			final byte[] buf = new byte[1024];
			int len;
			try {
				while ((len = in.read(buf)) > 0) {
					out.write(buf, 0, len);
				}
			} catch (final IOException e) {
				e.printStackTrace();
			}
			in.close();
			out.close();
		} catch (final FileNotFoundException e) {
			e.printStackTrace();
		}
	}

    /**
	 * Seta dataFim  Base de Conhecimento.
	 *
	 * @param base
	 * @throws Exception
	 */
    private void excluirBaseConhecimento(final BaseConhecimentoDTO base) throws Exception {
        this.excluirAnexosBaseConhecimento(base);
        base.setDataFim(UtilDatas.getDataAtual());
        final Lucene lucene = new Lucene();
        lucene.excluirBaseConhecimento(base, true);
        this.getDao().update(base);
    }

    /**
	 * Seta dataFim  Comentarios.
	 *
	 * @param base
	 * @throws Exception
	 */
    private void excluirBaseConhecimentoComentarios(final BaseConhecimentoDTO base) throws Exception {
        final Collection<ComentariosDTO> comentarios = this.geComentariosDAO().consultarComentarios(base);
        if (comentarios != null) {
            for (final ComentariosDTO comentarioDto : comentarios) {
                comentarioDto.setDataFim(UtilDatas.getDataAtual());
                this.geComentariosDAO().update(comentarioDto);
            }
        }

	}

	/**
	 * Excluir Anexos da Base Conhecimento atribuindo sua dataFim.
	 *
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	private void excluirAnexosBaseConhecimento(final BaseConhecimentoDTO base) throws Exception {
		final AnexoBaseConhecimentoDAO anexoBaseConhecimentoDao = new AnexoBaseConhecimentoDAO();

		final Collection<AnexoBaseConhecimentoDTO> anexosBaseConhecimento = anexoBaseConhecimentoDao.consultarAnexosDaBaseConhecimento(base);

		if (anexosBaseConhecimento != null && !anexosBaseConhecimento.isEmpty()) {
			for (final AnexoBaseConhecimentoDTO anexo : anexosBaseConhecimento) {
				anexoBaseConhecimentoDao.delete(anexo);

				this.deleteDir(new File(anexo.getLink()));
			}
		}

		final Lucene lucene = new Lucene();
		lucene.excluiAnexosDaBaseConhecimento(Long.parseLong(String.valueOf(base.getIdBaseConhecimento())));
	}

	/**
	 * @return valor do atributo subDiretorio.
	 */
	public File getPastaDaBaseConhecimento() {
		return pastaDaBaseConhecimento;
	}

	/**
	 * Define valor do atributo subDiretorio.
	 *
	 * @param pastaDaBaseConhecimento
	 */
	public void setPastaDaBaseConhecimento(final File pastaDaBaseConhecimento) {
		this.pastaDaBaseConhecimento = pastaDaBaseConhecimento;
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBaseConhecimentoByPasta(final PastaDTO pasta) throws Exception {
		return this.getDao().listarBaseConhecimentoByPasta(pasta);
	}

	@Override
	public Long quantidadeBaseConhecimentoByPasta(PastaDTO pastaDto) throws Exception {
		return this.getDao().quantidadeBaseConhecimentoByPasta(pastaDto);
	}

	@Override
	public Double calcularNota(final Integer idBaseConhecimento) throws Exception {
		final ComentariosDAO comentarioDao = new ComentariosDAO();
		return comentarioDao.calcularNota(idBaseConhecimento);
	}

	@Override
	public Long contarVotos(final Integer idBaseConhecimento) throws Exception {
		return this.geComentariosDAO().contarVotos(idBaseConhecimento);
	}

	@Override
	public boolean verificarSeBaseConhecimentoJaPossuiNovaVersao(final BaseConhecimentoDTO baseConhecimento) throws Exception {
		return this.getDao().verificarSeBaseConhecimentoJaPossuiNovaVersao(baseConhecimento);
	}

	@Override
	public boolean verificarSeBaseConhecimentoPossuiVersaoAnterior(final BaseConhecimentoDTO baseConhecimento) throws Exception {
		final String versao = StringUtils.remove(baseConhecimento.getTitulo(), baseConhecimento.getVersao());
		if (StringUtils.isBlank(versao)) {
			return false;
		}
		return true;
	}

	@Override
	public boolean verificaBaseConhecimentoExistente(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		return this.getDao().verificaSeBaseConhecimentoExiste(baseConhecimentoDTO);
	}

	@Override
	public List<BaseConhecimentoDTO> validaNota(final BaseConhecimentoDTO baseconhecimento) throws Exception {
		return this.getDao().validaNota(baseconhecimento);
	}

	@Override
	public Collection<BaseConhecimentoDTO> listaBaseConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaBaseConhecimento(baseConhecimento);
	}

	@Override
	public Collection<BaseConhecimentoDTO> listaBaseConhecimentoUltimasVersoes(final BaseConhecimentoDTO baseConhecimento) throws Exception {
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaBaseConhecimentoUltimasVersoes(baseConhecimento);
	}

    /**
	 * Verifica se usurio aprova Base Conhecimento na pasta selecionada.
	 *
	 * @param usuarioDto
	 * @param idPasta
	 * @return true = aprova; false = no aprova.
	 * @throws ServiceException
	 * @throws Exception
	 */
    private boolean usuarioAprovaBaseConhecimento(final UsuarioDTO usuarioDto, final Integer idPasta) throws Exception {
        boolean aprovaBaseConhecimento = false;

		aprovaBaseConhecimento = this.getPerfilAcessoPastaService().verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(usuarioDto, idPasta);

		return aprovaBaseConhecimento;
	}

    /**
	 * Cria comentrios da Base de Conhecimento.
	 *
	 * @param baseConhecimentoDto
	 * @param transactionControler
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
    private void criarComentarios(final BaseConhecimentoDTO baseConhecimentoDto, final TransactionControler transactionControler) throws Exception {
        final Collection<ComentariosDTO> comentarios = baseConhecimentoDto.getComentarios();

		final ComentariosDAO comentariosDao = new ComentariosDAO();

		comentariosDao.setTransactionControler(transactionControler);

		if (comentarios != null && !comentarios.isEmpty()) {
			for (final ComentariosDTO comentario : comentarios) {
				comentario.setDataInicio(UtilDatas.getDataAtual());

				comentariosDao.create(comentario);
			}
		}
	}

	@Override
	public void criarImportanciaConhecimentoUsuario(final BaseConhecimentoDTO baseConhecimentoDto, TransactionControler transactionControler) throws ServiceException, Exception {
		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {

			final ImportanciaConhecimentoUsuarioService importanciaConhecimentoUsuarioService = (ImportanciaConhecimentoUsuarioService) ServiceLocator.getInstance().getService(
					ImportanciaConhecimentoUsuarioService.class, null);

			if (transactionControler == null) {
				transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());
			}

			importanciaConhecimentoUsuarioService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);

			final Collection<ImportanciaConhecimentoUsuarioDTO> listImportanciaConhecimentoUsuario = baseConhecimentoDto.getListImportanciaConhecimentoUsuario();
			if (listImportanciaConhecimentoUsuario != null && !listImportanciaConhecimentoUsuario.isEmpty()) {
				for (final ImportanciaConhecimentoUsuarioDTO importanciaConhecimentoUsuario : listImportanciaConhecimentoUsuario) {
					if (importanciaConhecimentoUsuario.getIdBaseConhecimento() == null) {
						importanciaConhecimentoUsuario.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
						importanciaConhecimentoUsuarioService.create(importanciaConhecimentoUsuario, transactionControler);
					} else {
						importanciaConhecimentoUsuario.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
						importanciaConhecimentoUsuarioService.create(importanciaConhecimentoUsuario, transactionControler);
					}
				}
			}
		}
	}

	@Override
	public void criarImportanciaConhecimentoGrupo(final BaseConhecimentoDTO baseConhecimentoDto, TransactionControler transactionControler) throws Exception {
		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {
			final ImportanciaConhecimentoGrupoService importanciaConhecimentoGrupoService = (ImportanciaConhecimentoGrupoService) ServiceLocator.getInstance().getService(
					ImportanciaConhecimentoGrupoService.class, null);

			if (transactionControler == null) {
				transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());
			}

			importanciaConhecimentoGrupoService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);

			final Collection<ImportanciaConhecimentoGrupoDTO> listImportanciaConhecimentoGrupo = baseConhecimentoDto.getListImportanciaConhecimentoGrupo();
			if (listImportanciaConhecimentoGrupo != null && !listImportanciaConhecimentoGrupo.isEmpty()) {
				for (final ImportanciaConhecimentoGrupoDTO importanciaConhecimentoGrupo : listImportanciaConhecimentoGrupo) {
					if (importanciaConhecimentoGrupo.getIdBaseConhecimento() == null) {
						importanciaConhecimentoGrupo.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
						importanciaConhecimentoGrupoService.create(importanciaConhecimentoGrupo, transactionControler);
					} else {
						importanciaConhecimentoGrupo.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
						importanciaConhecimentoGrupoService.create(importanciaConhecimentoGrupo, transactionControler);
					}
				}
			}
		}
	}

	@Override
	public void criarRelacionamentoEntreConhecimentos(final BaseConhecimentoDTO baseConhecimentoDto, TransactionControler transactionControler) throws Exception {
		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {
			final BaseConhecimentoRelacionadoService baseConhecimentoRelacionadoService = (BaseConhecimentoRelacionadoService) ServiceLocator.getInstance().getService(
					BaseConhecimentoRelacionadoService.class, null);

			if (transactionControler == null) {
				transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());
			}

			baseConhecimentoRelacionadoService.deleteByIdConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), transactionControler);

			final Collection<BaseConhecimentoRelacionadoDTO> listBaseConhecimentoRelacionado = baseConhecimentoDto.getListBaseConhecimentoRelacionado();
			if (listBaseConhecimentoRelacionado != null && !listBaseConhecimentoRelacionado.isEmpty()) {
				for (final BaseConhecimentoRelacionadoDTO baseConhecimentoRelacionado : listBaseConhecimentoRelacionado) {
					if (baseConhecimentoRelacionado.getIdBaseConhecimento() == null) {
						baseConhecimentoRelacionado.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
						baseConhecimentoRelacionadoService.create(baseConhecimentoRelacionado, transactionControler);
					} else {
						baseConhecimentoRelacionado.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
						baseConhecimentoRelacionadoService.create(baseConhecimentoRelacionado, transactionControler);
					}
				}
			}
		}
	}

	@Override
	public NotificacaoDTO criarNotificacao(final BaseConhecimentoDTO baseConhecimentoDto, TransactionControler transactionControler) throws ServiceException, Exception {

		final NotificacaoDTO notificacaoDto = new NotificacaoDTO();

		final NotificacaoService notificacaoService = (NotificacaoService) ServiceLocator.getInstance().getService(NotificacaoService.class, null);

		if (baseConhecimentoDto.getTituloNotificacao() != null && !StringUtils.isEmpty(baseConhecimentoDto.getTituloNotificacao().trim()) && baseConhecimentoDto.getTipoNotificacao() != null
				&& !StringUtils.isEmpty(baseConhecimentoDto.getTipoNotificacao().trim())) {

			if (transactionControler == null) {
				transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());
			}

			if (baseConhecimentoDto.getIdNotificacao() != null) {
				notificacaoDto.setIdNotificacao(baseConhecimentoDto.getIdNotificacao());
				notificacaoDto.setListaDeUsuario(baseConhecimentoDto.getListaDeUsuarioNotificacao());
				notificacaoDto.setListaDeGrupo(baseConhecimentoDto.getListaDeGrupoNotificacao());
				notificacaoDto.setTitulo(baseConhecimentoDto.getTituloNotificacao());
				notificacaoDto.setTipoNotificacao(baseConhecimentoDto.getTipoNotificacao());
				notificacaoDto.setOrigemNotificacao(Enumerados.OrigemNotificacao.B.name());

				notificacaoService.update(notificacaoDto, transactionControler);

				return notificacaoDto;

			} else {
				notificacaoDto.setListaDeUsuario(baseConhecimentoDto.getListaDeUsuarioNotificacao());
				notificacaoDto.setListaDeGrupo(baseConhecimentoDto.getListaDeGrupoNotificacao());
				notificacaoDto.setTitulo(baseConhecimentoDto.getTituloNotificacao());
				notificacaoDto.setTipoNotificacao(baseConhecimentoDto.getTipoNotificacao());
				notificacaoDto.setOrigemNotificacao(Enumerados.OrigemNotificacao.B.name());

				return notificacaoService.create(notificacaoDto, transactionControler);
			}
		} else {
			return notificacaoDto;
		}
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBaseConhecimentoFAQByPasta(final PastaDTO pasta) throws Exception {
		return this.getDao().listarBaseConhecimentoFAQByPasta(pasta);
	}

    private void enviarEmailNotificacaoConhecimento(final BaseConhecimentoDTO baseConhecimentoDTO, final TransactionControler transactionControler, final String crud)
            throws Exception {

        final EmpregadoDao empregadoDao = new EmpregadoDao();
        final NotificacaoDao notificacaoDao = new NotificacaoDao();

        Collection<EmpregadoDTO> colEmpregados = new ArrayList();

        if (transactionControler != null) {
            empregadoDao.setTransactionControler(transactionControler);
            notificacaoDao.setTransactionControler(transactionControler);
        }

        if (baseConhecimentoDTO.getIdNotificacao() != null && baseConhecimentoDTO.getIdNotificacao() != 0) {

			final String remetente = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao, null);
            String ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO, "8");
            String ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO = ParametroUtil.getValorParametroCitSmartHashMap(
                    ParametroSistema.ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO, "9");
            String ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO,
                    "10");
            String ID_MODELO_EMAIL = "";

            if (ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO == null || ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO.isEmpty()) {
                ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO = "11";
            }

            if (ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO == null || ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO.isEmpty()) {
                ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO = "12";
            }

            if (ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO == null || ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO.isEmpty()) {
                ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO = "13";
            }

            if (crud.equals("C")) {
                if (baseConhecimentoDTO.getTipoNotificacao().equals("T") || baseConhecimentoDTO.getTipoNotificacao().equals("C")) {
                    ID_MODELO_EMAIL = ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO;
                }
            } else if (crud.equals("U")) {
                if (baseConhecimentoDTO.getTipoNotificacao().equals("T") || baseConhecimentoDTO.getTipoNotificacao().equals("A")) {
                    ID_MODELO_EMAIL = ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO;
                }
            } else {
                if (baseConhecimentoDTO.getTipoNotificacao().equals("T") || baseConhecimentoDTO.getTipoNotificacao().equals("E")) {
                    ID_MODELO_EMAIL = ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO;
                }
            }

            if (!ID_MODELO_EMAIL.isEmpty()) {

                colEmpregados = empregadoDao.listarEmailsNotificacoesConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());

                if (colEmpregados != null) {

                    for (final EmpregadoDTO empregados : colEmpregados) {

                        final MensagemEmail mensagem = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL.trim()), new IDto[] {baseConhecimentoDTO});

                        if (empregados.getEmail() != null) {
                            mensagem.envia(empregados.getEmail(), "", remetente);
                        }

                    }
                }

            }
        }
    }

    @Override
    public BaseConhecimentoDTO getBaseConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {
        return this.getDao().getBaseConhecimento(baseConhecimento);
    }

	@Override
	public Collection<BaseConhecimentoDTO> listPesquisaBaseConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {
		return this.getDao().listPesquisaBaseConhecimento(baseConhecimento);
	}

	@Override
	public void arquivarConhecimento(final BaseConhecimentoDTO baseConhecimentoDto) throws Exception {
		baseConhecimentoDto.setArquivado("S");
		this.getDao().arquivarConhecimento(baseConhecimentoDto);

		/*
		 * Desenvolvedor: Euler Ramos - Data: 06/05/2015 - Horrio: 09:54 - ID
		 * Citsmart: 171466 - Motivo/Comentrio: O arquivamento ainda no tinha
		 * sido tratado.
		 */
		final Lucene lucene = new Lucene();
		lucene.excluirBaseConhecimento(baseConhecimentoDto, true);
	}

    @Override
    public Integer obterGrauDeImportanciaParaUsuario(final BaseConhecimentoDTO baseConhecimentoDto, final UsuarioDTO usuarioDto) throws Exception {
        final ImportanciaConhecimentoGrupoService importanciaConhecimentoGrupoService = (ImportanciaConhecimentoGrupoService) ServiceLocator.getInstance().getService(
                ImportanciaConhecimentoGrupoService.class, null);
        final GrupoEmpregadoService grupoEmpregadoService = (GrupoEmpregadoService) ServiceLocator.getInstance().getService(GrupoEmpregadoService.class, null);

        final Collection<GrupoEmpregadoDTO> listGrupoEmpregadoDto = grupoEmpregadoService.findByIdEmpregado(usuarioDto.getIdEmpregado());

        final ImportanciaConhecimentoGrupoDTO importanciaConhecimento = importanciaConhecimentoGrupoService.obterGrauDeImportancia(baseConhecimentoDto, listGrupoEmpregadoDto,
                usuarioDto);

        if (importanciaConhecimento != null) {
            return Integer.parseInt(importanciaConhecimento.getGrauImportancia());
        }
        return 0;
    }

	@Override
	public void restaurarConhecimento(final BaseConhecimentoDTO baseConhecimentoDto) throws Exception {
		baseConhecimentoDto.setArquivado("N");
		this.getDao().restaurarConhecimento(baseConhecimentoDto);

		// @Author euler.ramos
		// INDEXAO LUCENE
		// Indexando Base de Conhecimento
		final Lucene lucene = new Lucene();
		// Publicada, No arquivada e No excluda!
		AnexoBaseConhecimentoService anexoBaseConhecimentoService = (AnexoBaseConhecimentoService) ServiceLocator.getInstance().getService(AnexoBaseConhecimentoService.class, null);
		List<AnexoBaseConhecimentoDTO> listaAnexoBaseConhecimento = (List<AnexoBaseConhecimentoDTO>) anexoBaseConhecimentoService.consultarAnexosDaBaseConhecimento(baseConhecimentoDto);
		lucene.indexarBaseConhecimento(baseConhecimentoDto, listaAnexoBaseConhecimento);
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBaseConhecimentoByPastaRelatorio(final PastaDTO pasta) throws Exception {
		return this.getDao().listarBaseConhecimentoByPastaRelatorio(pasta);
	}

	@Override
	public Collection<BaseConhecimentoDTO> obterHistoricoDeVersoes(final BaseConhecimentoDTO baseConhecimento) throws Exception {
		return this.getDao().obterHistoricoDeVersoes(baseConhecimento);
	}

	@Override
	public void gravarSolicitacoesConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {
		if (baseConhecimento.getIdBaseConhecimento() != null) {
			final ConhecimentoSolicitacaoDao conhecimentoSolicitacaoDao = new ConhecimentoSolicitacaoDao();

			conhecimentoSolicitacaoDao.deleteByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

			try {
				if (baseConhecimento.getColItensIncidentes() != null) {
					for (final Object element : baseConhecimento.getColItensIncidentes()) {

						final SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) element;

						final ConhecimentoSolicitacaoDTO conhecimentoSolicitacaoDto = new ConhecimentoSolicitacaoDTO();

						conhecimentoSolicitacaoDto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
						conhecimentoSolicitacaoDto.setIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

						conhecimentoSolicitacaoDao.create(conhecimentoSolicitacaoDto);
					}
				}
			} catch (final Exception e) {
				System.err.println(e);
			}
		}
	}

	@Override
	public void gravarProblemasConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {
		if (baseConhecimento.getIdBaseConhecimento() != null) {
			final ProblemaBaseConhecimentoDAO problemaBaseConhecimentoDAO = new ProblemaBaseConhecimentoDAO();

			problemaBaseConhecimentoDAO.deleteByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

			try {
				if (baseConhecimento.getColItensProblema() != null) {
					for (final Object element : baseConhecimento.getColItensProblema()) {
						final ProblemaDTO problemaDTO = (ProblemaDTO) element;

						final ProblemaBaseConhecimentoRelacionadoDTO problemaBaseConhecimentoRelacionadoDTO = new ProblemaBaseConhecimentoRelacionadoDTO();
						problemaBaseConhecimentoDAO.deleteByIdProblema(problemaDTO.getIdProblema());
						problemaBaseConhecimentoRelacionadoDTO.setIdProblema(problemaDTO.getIdProblema());
						problemaBaseConhecimentoRelacionadoDTO.setIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

						problemaBaseConhecimentoDAO.create(problemaBaseConhecimentoRelacionadoDTO);
					}
				}

			} catch (final Exception e) {
				System.err.println(e);
			}
		}
	}

	@Override
	public void gravarMudancaConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {

		if (baseConhecimento.getIdBaseConhecimento() != null) {

			final MudancaBaseConhecimentoDao mudancaBaseConhecimentoDao = new MudancaBaseConhecimentoDao();
			mudancaBaseConhecimentoDao.deleteByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

			try {
				if (baseConhecimento.getColItensMudanca() != null) {

					for (final Object element : baseConhecimento.getColItensMudanca()) {

						final RequisicaoMudancaDTO requisicaoMudancaDTO = (RequisicaoMudancaDTO) element;

						final MudancaBaseConhecimentoDTO mudancaBaseConhecimentoDTO = new MudancaBaseConhecimentoDTO();

						mudancaBaseConhecimentoDTO.setIdRequisicaoMudanca(requisicaoMudancaDTO.getIdRequisicaoMudanca());
						mudancaBaseConhecimentoDTO.setIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

						mudancaBaseConhecimentoDao.create(mudancaBaseConhecimentoDTO);
					}
				}
			} catch (final Exception e) {
				System.err.println(e);
			}
		}
	}

	@Override
	public void gravarLiberacaoConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {

		if (baseConhecimento.getIdBaseConhecimento() != null) {

			final LiberacaoBaseConhecimentoDao liberacaoBaseConhecimentoDao = new LiberacaoBaseConhecimentoDao();

			liberacaoBaseConhecimentoDao.deleteByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

			try {
				if (baseConhecimento.getColItensLiberacao() != null) {

					for (final Object element : baseConhecimento.getColItensLiberacao()) {

						final RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) element;

						final LiberacaoBaseConhecimentoDTO liberacaoBaseConhecimentoDTO = new LiberacaoBaseConhecimentoDTO();

						liberacaoBaseConhecimentoDTO.setIdLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
						liberacaoBaseConhecimentoDTO.setIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

						liberacaoBaseConhecimentoDao.create(liberacaoBaseConhecimentoDTO);
					}
				}
			} catch (final Exception e) {
				System.err.println(e);
			}
		}
	}

	@Override
	public void gravarICConhecimento(final BaseConhecimentoDTO baseConhecimento) throws Exception {

		if (baseConhecimento.getIdBaseConhecimento() != null) {
			final ConhecimentoICDao conhecimentoICDao = new ConhecimentoICDao();

			conhecimentoICDao.deleteByIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

			try {
				if (baseConhecimento.getColItensICSerialize() != null) {

					for (final Object element : baseConhecimento.getColItensICSerialize()) {

						final ItemConfiguracaoDTO itemConfiguracaoDto = (ItemConfiguracaoDTO) element;

						final ConhecimentoICDTO conhecimentoICDTO = new ConhecimentoICDTO();

						conhecimentoICDTO.setIdItemConfiguracao(itemConfiguracaoDto.getIdItemConfiguracao());
						conhecimentoICDTO.setIdBaseConhecimento(baseConhecimento.getIdBaseConhecimento());

						conhecimentoICDao.create(conhecimentoICDTO);
					}
				}
			} catch (final Exception e) {
				System.err.println(e);
			}
		}
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBaseConhecimentoByIds(final Integer[] ids) throws Exception {
		return this.getDao().listarBaseConhecimentoByIds(ids);
	}

	@Override
	public void updateNotNull(final IDto obj) throws Exception {
		this.getDao().updateNotNull(obj);
	}

	@Override
	public Collection<BaseConhecimentoDTO> quantidadeBaseConhecimentoPorPeriodo(final BaseConhecimentoDTO filtroDTO) throws Exception {

		final Collection<BaseConhecimentoDTO> listaQuantitativoBaseConhecimentoDTOs = new ArrayList<BaseConhecimentoDTO>();

		BaseConhecimentoDTO relatorioBaseConhecimentoDTO = new BaseConhecimentoDTO();

		try {
			relatorioBaseConhecimentoDTO = this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).recuperaContadoresRelatorioQuantitativoBaseConhecimento(filtroDTO);
			
			if (relatorioBaseConhecimentoDTO != null) {
				if (relatorioBaseConhecimentoDTO.getQtdArquivados() == null) {
					relatorioBaseConhecimentoDTO.setQtdArquivados(0);
				}

				if (relatorioBaseConhecimentoDTO.getQtdAtualizados() == null) {
					relatorioBaseConhecimentoDTO.setQtdAtualizados(0);
				}

				if (relatorioBaseConhecimentoDTO.getQtdNaoPublicados() == null) {
					relatorioBaseConhecimentoDTO.setQtdNaoPublicados(0);
				}

				if (relatorioBaseConhecimentoDTO.getQtdPublicados() == null) {
					relatorioBaseConhecimentoDTO.setQtdPublicados(0);
				}

				if (relatorioBaseConhecimentoDTO.getTipoFaq() == null) {
					relatorioBaseConhecimentoDTO.setTipoFaq(0);
				}

				if (relatorioBaseConhecimentoDTO.getQtdErroConhecido() == null) {
					relatorioBaseConhecimentoDTO.setQtdErroConhecido(0);
				}

				if (relatorioBaseConhecimentoDTO.getQtdDocumentos() == null) {
					relatorioBaseConhecimentoDTO.setQtdDocumentos(0);
				}

				// Conta acessados no perodo
				final ContadorAcessoService contadorAcessoService = (ContadorAcessoService) ServiceLocator.getInstance().getService(ContadorAcessoService.class, null);
				final Integer contadorAcesso = contadorAcessoService.quantidadesDeAcessoPorPeriodo(filtroDTO);
				if (contadorAcesso != null) {
					relatorioBaseConhecimentoDTO.setQtdAcessados(contadorAcesso);
				} else {
					relatorioBaseConhecimentoDTO.setQtdAcessados(0);
				}

				// Conta avaliados no perodo
				final ComentariosService comentariosService = (ComentariosService) ServiceLocator.getInstance().getService(ComentariosService.class, null);
				final Integer contadorComentarios = comentariosService.consultarComentariosPorPeriodo(filtroDTO);
				if (contadorComentarios != null) {
					relatorioBaseConhecimentoDTO.setQtdAvaliados(contadorComentarios);
				} else {
					relatorioBaseConhecimentoDTO.setQtdAvaliados(0);
				}

				// conta quantidade de excluidos//
				final Integer contadorExcluidos = this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).contaConhecimentosExcluidos(filtroDTO);
				if (contadorExcluidos != null) {
					relatorioBaseConhecimentoDTO.setQtdExcluidos(contadorExcluidos);
				} else {
					relatorioBaseConhecimentoDTO.setQtdExcluidos(0);
				}

				listaQuantitativoBaseConhecimentoDTOs.add(relatorioBaseConhecimentoDTO);
			}

		} catch (final ServiceException e) {
			e.printStackTrace();
		} catch (final Exception e) {
			e.printStackTrace();
		}
		return listaQuantitativoBaseConhecimentoDTOs;
	}

	@Override
	public Collection<ComentariosDTO> consultaConhecimentosAvaliados(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		final ComentariosDAO dao = new ComentariosDAO(CITCorporeUtil.JDBC_ALIAS_REPORTS);
		Collection<ComentariosDTO> listaComentarios = new ArrayList<ComentariosDTO>();
		try {
			listaComentarios = dao.consultarComentariosPorPeriodo(baseConhecimentoDTO);
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return listaComentarios;
	}

	@Override
	public Collection<BaseConhecimentoDTO> consultaConhecimentosPorAutores(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		List<BaseConhecimentoDTO> listaConhecimentoPorAutor = new ArrayList<BaseConhecimentoDTO>();
		try {
			listaConhecimentoPorAutor = (List<BaseConhecimentoDTO>) this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).consultaConhecimentoPorAutor(baseConhecimentoDTO);
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return listaConhecimentoPorAutor;
	}

	@Override
	public Collection<BaseConhecimentoDTO> consultaConhecimentosPorAprovadores(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		List<BaseConhecimentoDTO> listaConhecimentoPorAprovador = new ArrayList<BaseConhecimentoDTO>();
		try {
			listaConhecimentoPorAprovador = (List<BaseConhecimentoDTO>) this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).consultaConhecimentoPorAprovador(baseConhecimentoDTO);
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return listaConhecimentoPorAprovador;
	}

	@Override
	public Collection<BaseConhecimentoDTO> consultaConhecimentosPublicadosPorOrigem(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		List<BaseConhecimentoDTO> listaConsultaConhecimentoPublicadosPorOrigem = new ArrayList<BaseConhecimentoDTO>();
		try {
			listaConsultaConhecimentoPublicadosPorOrigem = (List<BaseConhecimentoDTO>) this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).consultaConhecimentosPublicadosPorOrigem(baseConhecimentoDTO);
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return listaConsultaConhecimentoPublicadosPorOrigem;
	}

	@Override
	public Collection<BaseConhecimentoDTO> consultaConhecimentosNaoPublicadosPorOrigem(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		List<BaseConhecimentoDTO> listaConsultaConhecimentoNaoPublicadosPorOrigem = new ArrayList<BaseConhecimentoDTO>();
		try {
			listaConsultaConhecimentoNaoPublicadosPorOrigem = (List<BaseConhecimentoDTO>) this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).consultaConhecimentosNaoPublicadosPorOrigem(baseConhecimentoDTO);
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return listaConsultaConhecimentoNaoPublicadosPorOrigem;
	}

	@Override
	public Collection<BaseConhecimentoDTO> consultaConhecimentoQuantitativoEmLista(final BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		List<BaseConhecimentoDTO> listaConsultaConhecimentoQuantitativoEmLista = new ArrayList<BaseConhecimentoDTO>();
		List<BaseConhecimentoDTO> listaIncidente = new ArrayList<BaseConhecimentoDTO>();
		List<BaseConhecimentoDTO> listaRequisitos = new ArrayList<BaseConhecimentoDTO>();
		List<BaseConhecimentoDTO> listaProblema = new ArrayList<BaseConhecimentoDTO>();
		List<BaseConhecimentoDTO> listaMudanca = new ArrayList<BaseConhecimentoDTO>();
		List<BaseConhecimentoDTO> listaIC = new ArrayList<BaseConhecimentoDTO>();
		List<BaseConhecimentoDTO> listaServico = new ArrayList<BaseConhecimentoDTO>();

		try {
            listaConsultaConhecimentoQuantitativoEmLista = (List<BaseConhecimentoDTO>) this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).consultaConhecimentoQuantitativoEmLista(baseConhecimentoDTO);
			for (final BaseConhecimentoDTO baseConhecimentoDTO2 : listaConsultaConhecimentoQuantitativoEmLista) {
				listaIncidente = (List<BaseConhecimentoDTO>) this.getDao().consultaIncidenteLista(baseConhecimentoDTO2);
				baseConhecimentoDTO2.setListaIncidente(listaIncidente);
				listaRequisitos = (List<BaseConhecimentoDTO>) this.getDao().consultaRequisicaoLista(baseConhecimentoDTO2);
				baseConhecimentoDTO2.setListaRequisitos(listaRequisitos);
				listaProblema = (List<BaseConhecimentoDTO>) this.getDao().consultaProblemaLista(baseConhecimentoDTO2);
				baseConhecimentoDTO2.setListaProblema(listaProblema);
				listaMudanca = (List<BaseConhecimentoDTO>) this.getDao().consultaMudancaLista(baseConhecimentoDTO2);
				baseConhecimentoDTO2.setListaMudanca(listaMudanca);
				listaIC = (List<BaseConhecimentoDTO>) this.getDao().consultaItemConfiguracaoLista(baseConhecimentoDTO2);
				baseConhecimentoDTO2.setListaIC(listaIC);
				listaServico = (List<BaseConhecimentoDTO>) this.getDao().consultaServicoLista(baseConhecimentoDTO2);
				baseConhecimentoDTO2.setListaServico(listaServico);
			}
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return listaConsultaConhecimentoQuantitativoEmLista;
	}

	@Override
	public Collection findByServico(final SolicitacaoServicoDTO solicitacaoServicoDto) throws ServiceException, LogicException {
		try {
			return this.getDao().findByServico(solicitacaoServicoDto);
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBaseConhecimentoErroConhecidoByPasta(final PastaDTO pasta) throws Exception {
		return this.getDao().listarBaseConhecimentoErroConhecidoByPasta(pasta);
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBaseConhecimentoFAQ() throws Exception {
		return this.getDao().listarBaseConhecimentoFAQ();
	}

	@Override
	public Collection<BaseConhecimentoDTO> listarBasesConhecimentoPublicadas() throws Exception {
		return this.getDao().listarBasesConhecimentoPublicadas();
	}

    @Override
    public String verificaIdScriptOrientacao(final HashMap mapFields) throws Exception {
        List<BaseConhecimentoDTO> listaBaseConhecimento = null;
        String id = mapFields.get("IDBASECONHECIMENTO").toString().trim();
        if (id == null || id.equals("")) {
			// Campo SCRIPT de Orientao (Base de Conhecimento) no  obrigatorio, por isso passei um valor qualquer para no validar mais.
            id = "campoVazio";
            return id;
        }
        if (UtilStrings.soContemNumeros(id)) {
            final Integer idBaseConhecimento = Integer.parseInt(id);
            listaBaseConhecimento = this.getDao().findByIdBaseConhecimento(idBaseConhecimento);
        } else {
            listaBaseConhecimento = this.getDao().findByBaseConhecimento(id);
        }
        if (listaBaseConhecimento != null && listaBaseConhecimento.size() > 0) {
            return String.valueOf(listaBaseConhecimento.get(0).getIdBaseConhecimento());
        } else {
            return "0";
        }
    }

    @Override
    public Page<BaseConhecimentoDTO> listarBaseConhecimentoPortal(final Pageable pageable, final boolean isTotalizacao) throws PersistenceException{
    	return this.getDao().listarBaseConhecimentoPortal(pageable, isTotalizacao, null);
    }

    @Override
    public Page<BaseConhecimentoDTO> listarBaseConhecimentoFAQPortal(final Pageable pageable, final boolean isTotalizacao) throws PersistenceException{
    	return this.getDao().listarBaseConhecimentoFAQPortal(pageable, isTotalizacao, null);
    }

	@Override
	public Page<BaseConhecimentoDTO> pesquisaBaseConhecimentoPortal(Pageable pageable, boolean isTotalizacao, String titulo) throws PersistenceException {
		return this.getDao().listarBaseConhecimentoPortal(pageable, isTotalizacao, titulo);
	}

	@Override
	public Page<BaseConhecimentoDTO> pesquisaBaseConhecimentoFAQPortal(Pageable pageable, boolean isTotalizacao, String titulo) throws PersistenceException {
		return this.getDao().listarBaseConhecimentoFAQPortal(pageable, isTotalizacao, titulo);
	}

    /**
	 * 1 - Verifica a permisso de acesso, em nvel de privacidade confidencial, de um usurio sobre uma base de conhecimento.
	 * 2 - Caso o usurio no seja o autor da base de conhecimento, verifica-se se o mesmo tem perfil de administrador da Pasta em que est a base de conhecimento.
	 *
	 * Caso o usurio seja verdadeiro ('true'), para um dos casos descritos acima, este mtodo retornar 'true', indicando que aquela base de conhecimento  permitada o acesso para o usurio.
	 *
	 * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
	 * @param Integer
	 *            idBaseConhecimento
	 * @param Integer
	 *            idUsuario
	 * @return boolean
	 * @since 25/06/2015
	 */
    @Override
	public boolean verificaPermissaoDeAcessoConfidencialDoUsuarioParaBaseConhecimentoOuAdministradorPasta(final BaseConhecimentoDTO baseConhecimentoDto, final Integer idUsuario) {
        boolean usuarioTemPermissaoConfidencialOuAdministrador = false;

        try {
            usuarioTemPermissaoConfidencialOuAdministrador = this.getDao().verificaPermissaoDeAcessoConfidencialDoUsuarioParaBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento(), idUsuario);

            if (usuarioTemPermissaoConfidencialOuAdministrador == false) {
                usuarioTemPermissaoConfidencialOuAdministrador = this.getPerfilAcessoPastaService().verificaPermissaoDeAcessoAdministradorDoUsuarioNaPasta(baseConhecimentoDto.getIdPasta(), idUsuario);
            }
        } catch (IllegalArgumentException illegArgExc) {
            illegArgExc.printStackTrace();
            usuarioTemPermissaoConfidencialOuAdministrador = false;
        } catch (NullPointerException nullPointExc) {
            nullPointExc.printStackTrace();
            usuarioTemPermissaoConfidencialOuAdministrador = false;
        } catch (Exception exc) {
            exc.printStackTrace();
            usuarioTemPermissaoConfidencialOuAdministrador = false;
        }

        return usuarioTemPermissaoConfidencialOuAdministrador;
    }

    /**
	 * Verifica a permisso de um usurio sobre uma base conhecimento, dado a privacidade da base de conhecimento.
	 *
	 * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
	 * @param baseConhecimentoDto
	 * @return boolean
	 * @since 25/06/2015
	 */
    @Override
	public boolean verificaPermissaoDeAcessoDoUsuarioParaBaseConhecimento(final PastaDTO pastaDto, final BaseConhecimentoDTO baseConhecimentoDto, final UsuarioDTO usuarioDto) {
        boolean usuarioTemPermissao = false;

        try {
            if (baseConhecimentoDto!=null&&baseConhecimentoDto.getPrivacidade()!=null){
            	switch (baseConhecimentoDto.getPrivacidade()) {
                case "C":
                    usuarioTemPermissao = this.verificaPermissaoDeAcessoConfidencialDoUsuarioParaBaseConhecimentoOuAdministradorPasta(baseConhecimentoDto, usuarioDto.getIdUsuario());
                    break;
                case "I":
                    usuarioTemPermissao = this.getPerfilAcessoPastaService().verificaPermissaoDeAcessoNaPasta(usuarioDto, pastaDto);
                    break;
                default:
                    usuarioTemPermissao = true;
                    break;
            	}
            }
        } catch (IllegalArgumentException iArgExc) {
            iArgExc.printStackTrace();
            usuarioTemPermissao = false;
        } catch (NullPointerException nullPointExc) {
            nullPointExc.printStackTrace();
            usuarioTemPermissao = false;
        } catch (Exception exc) {
            exc.printStackTrace();
            usuarioTemPermissao = false;
        }

        return usuarioTemPermissao;
    }

	@Override
	public Collection<BaseConhecimentoDTO> findByIdMedidaRecuperacao(Integer idMedidaRecuperacao) throws Exception {
		return this.getDao().findByIdMedidaRecuperacao(idMedidaRecuperacao);
	}

}
