package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.CadastroHabilidadeDTO;
import br.com.centralit.citcorpore.integracao.CadastroHabilidadeDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public class CadastroHabilidadeServiceEjb extends CrudServiceImpl implements CadastroHabilidadeService {

private CadastroHabilidadeDao cadastroHabilidadeDao;

	@Override
	protected CadastroHabilidadeDao getDao() {
		if(cadastroHabilidadeDao == null){
			cadastroHabilidadeDao = new CadastroHabilidadeDao();
		}
		return cadastroHabilidadeDao;
	}

	@Override
	public IDto create(final IDto model) throws ServiceException, LogicException {
		CadastroHabilidadeDTO cadastroHabilidadeDTO = (CadastroHabilidadeDTO) model;

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {
			this.validaCreate(model);

			this.getDao().setTransactionControler(tc);

			tc.start();

			cadastroHabilidadeDTO = (CadastroHabilidadeDTO) this.getDao().create(cadastroHabilidadeDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}

		}
		return cadastroHabilidadeDTO;
	}

	@Override
	public void delete(final IDto model) throws ServiceException, LogicException {
		final CadastroHabilidadeDTO cadastroHabilidadeDTO = (CadastroHabilidadeDTO) model;

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {

			this.getDao().setTransactionControler(tc);

			tc.start();

			cadastroHabilidadeDTO.setDataHoraFim(UtilDatas.getDataHoraAtual());
			this.getDao().update(cadastroHabilidadeDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}

		}
	}

	/**
	 * Retorna verdadeiro caso a habilidade j esteja cadastrada com mesmo nome e categoria
	 *
	 * @author joao.morais
	 * @since 02.02.2016
	 */
	@Override
	public boolean verificaHabilidade(CadastroHabilidadeDTO cadastroHabilidadeDTO){
		try {
			Collection<CadastroHabilidadeDTO> listaHabilidades = this.getDao().verificaHabilidade(cadastroHabilidadeDTO);
			if (listaHabilidades == null || listaHabilidades.isEmpty()) {
				return false;
			} else {
				for(CadastroHabilidadeDTO habilidade : listaHabilidades){
					if (habilidade.getIdHabilidade().equals(cadastroHabilidadeDTO.getIdHabilidade())) {
						return false;
					}
				}
				return true;
			}
		} catch (PersistenceException e) {
			e.printStackTrace();
		}
		return true;
	}

	@Override
	public Collection<CadastroHabilidadeDTO> findHabilidadeByIdHabilidade(Integer idHabilidade) throws PersistenceException {
		Collection<CadastroHabilidadeDTO> listaHabilidades = this.getDao().getListHabilidadesByIdServico(idHabilidade);
		if (listaHabilidades == null || listaHabilidades.isEmpty()) {
			listaHabilidades = new ArrayList<CadastroHabilidadeDTO>();
			return listaHabilidades;
		}
		return listaHabilidades;
	}

}
