package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoICDTO;
import br.com.centralit.citcorpore.integracao.CadastroTemplateIncidenteRequisicaoICDAO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

public class CadastroTemplateIncidenteRequisicaoICServiceEjb extends CrudServiceImpl implements CadastroTemplateIncidenteRequisicaoICService {
	private CadastroTemplateIncidenteRequisicaoICDAO cadastroTemplateIncidenteRequisicaoICDAO;

	@Override
	protected CadastroTemplateIncidenteRequisicaoICDAO getDao() {
		if (cadastroTemplateIncidenteRequisicaoICDAO == null) {
			cadastroTemplateIncidenteRequisicaoICDAO = new CadastroTemplateIncidenteRequisicaoICDAO();
		}
		return cadastroTemplateIncidenteRequisicaoICDAO;
	}

	@Override
	public Collection<CadastroTemplateIncidenteRequisicaoICDTO> listByIdTemplateIncidenteRequisicao(Integer idTemplateIncidenteRequisicao) {
		try {
			return getDao().listByIdTemplateIncidenteRequisicao(idTemplateIncidenteRequisicao);
		} catch (PersistenceException e) {
			e.printStackTrace();
		}

		return new ArrayList<CadastroTemplateIncidenteRequisicaoICDTO>();
	}

	@Override
	public void deleteByIdTemplateIncidenteRequisicao(Integer idTemplateIncidenteRequisicao) {
		try {
			getDao().deleteByIdTemplateIncidenteRequisicao(idTemplateIncidenteRequisicao);
		} catch (PersistenceException e) {
			e.printStackTrace();
		}
	}

}