package br.com.centralit.citcorpore.negocio;

import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoDTO;
import br.com.centralit.citcorpore.integracao.CadastroTemplateIncidenteRequisicaoDAO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

public class CadastroTemplateIncidenteRequisicaoServiceEjb extends CrudServiceImpl implements CadastroTemplateIncidenteRequisicaoService {
	private CadastroTemplateIncidenteRequisicaoDAO cadastroTemplateIncidenteRequisicaoDAO;

	@Override
	protected CadastroTemplateIncidenteRequisicaoDAO getDao() {
		if (cadastroTemplateIncidenteRequisicaoDAO == null) {
			cadastroTemplateIncidenteRequisicaoDAO = new CadastroTemplateIncidenteRequisicaoDAO();
		}
		return cadastroTemplateIncidenteRequisicaoDAO;
	}

	@Override
	public boolean delete(CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO) throws ServiceException, LogicException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {
			cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) this.restore(cadastroTemplateIncidenteRequisicaoDTO);

			this.getDao().setTransactionControler(tc);

			tc.start();

			cadastroTemplateIncidenteRequisicaoDTO.setDataFim(UtilDatas.getDataAtual());
			this.getDao().update(cadastroTemplateIncidenteRequisicaoDTO);

			tc.commit();
			tc.close();

			return true;
		} catch (final Exception e) {
			this.rollbackTransaction(tc, e);
		}
		return false;
	}

}