package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.CadastroTipoFinanceiroDTO;
import br.com.centralit.citcorpore.integracao.CadastroTipoFinanceiroDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

/**
 * @author CentralIT
 */
@SuppressWarnings({ "unchecked" })
public class CadastroTipoFinanceiroServiceEjb extends CrudServiceImpl implements CadastroTipoFinanceiroService {

	private CadastroTipoFinanceiroDao cadastroTipoFinanceiroDao;

	@Override
	public void deleteLogico(final IDto model) throws Exception {
		final CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = (CadastroTipoFinanceiroDTO) model;
		cadastroTipoFinanceiroDTO.setIdTipo(cadastroTipoFinanceiroDTO.getIdTipoSelecionado());
		cadastroTipoFinanceiroDTO.setDataFim(UtilDatas.getDataAtual());
		this.getDao().update(cadastroTipoFinanceiroDTO);

	}

	protected CadastroTipoFinanceiroDao getCadastroTipoFinanceirosDao() {
		if (cadastroTipoFinanceiroDao == null) {
			cadastroTipoFinanceiroDao = new CadastroTipoFinanceiroDao();
		}
		return cadastroTipoFinanceiroDao;
	}

	@Override
	protected CadastroTipoFinanceiroDao getDao() {
		if (cadastroTipoFinanceiroDao == null) {
			cadastroTipoFinanceiroDao = new CadastroTipoFinanceiroDao();
		}
		return cadastroTipoFinanceiroDao;
	}

	public boolean findTipoFinanceiro(CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO) throws PersistenceException{
		Collection<CadastroTipoFinanceiroDTO> cadastroTipoFinanceiro = this.getDao().verificaTipofinanceiro(cadastroTipoFinanceiroDTO);
		if(cadastroTipoFinanceiro.size() == 0){
			return false;
		}else{
			return true;
		}
	}
	
	public String getPerfil(Integer idTipo) throws PersistenceException{
		CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = this.getDao().getPerfil(idTipo);
		return cadastroTipoFinanceiroDTO.getPerfil();
	}

}
