package br.com.centralit.citcorpore.negocio;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.CalculoJornadaDTO;
import br.com.centralit.citcorpore.bean.CalendarioDTO;
import br.com.centralit.citcorpore.bean.ExcecaoCalendarioDTO;
import br.com.centralit.citcorpore.bean.JornadaTrabalhoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.TipoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.TipoMudancaDTO;
import br.com.centralit.citcorpore.integracao.CalendarioDao;
import br.com.centralit.citcorpore.integracao.ExcecaoCalendarioDao;
import br.com.centralit.citcorpore.integracao.FeriadoDao;
import br.com.centralit.citcorpore.integracao.JornadaTrabalhoDao;
import br.com.centralit.citcorpore.integracao.ServicoContratoDao;
import br.com.centralit.citcorpore.integracao.TipoLiberacaoDAO;
import br.com.centralit.citcorpore.integracao.TipoMudancaDAO;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.integracao.CrudDAO;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({"rawtypes"})
public class CalendarioServiceEjb extends CrudServiceImpl implements CalendarioService {

	public static final String HORA_INICIO_CALCULADA = "IC";
	public static final String HORA_TERMINO_CALCULADA = "TC";
	public static final String HORA_INICIO_JORNADA = "IJ";
	public static final String HORA_TERMINO_JORNADA = "TJ";

	public static final String FOLGA = "F";
	public static final String TRABALHO = "T";

	private TransactionControler transactionControler;
	
	private ExcecaoCalendarioDao excecaoCalendarioDAO;
	private FeriadoDao feriadoDAO;
	private JornadaTrabalhoDao jornadaTrabalhoDAO;
	private ServicoContratoDao servicoContratoDao;
	private TipoLiberacaoDAO tipoLiberacaoDAO;
	private TipoMudancaDAO tipoMudancaDAO;

	private ExcecaoCalendarioDao getExcecaoCalendarioDAO() throws Exception {
		if (excecaoCalendarioDAO == null) {
			excecaoCalendarioDAO = new ExcecaoCalendarioDao();
			this.setTransacaoDao(excecaoCalendarioDAO);
		}
		return excecaoCalendarioDAO;
	}
	
	private FeriadoDao getFeriadoDAO() throws Exception {
		if (feriadoDAO == null) {
			feriadoDAO = new FeriadoDao();
			this.setTransacaoDao(feriadoDAO);
		}
		return feriadoDAO;
	}

	private JornadaTrabalhoDao getJornadaTrabalhoDAO() throws Exception {
		if (jornadaTrabalhoDAO == null) {
			jornadaTrabalhoDAO = new JornadaTrabalhoDao();
			this.setTransacaoDao(jornadaTrabalhoDAO);
		}
		return jornadaTrabalhoDAO;
	}

	private ServicoContratoDao getServicoContratoDAO() throws Exception {
		if (servicoContratoDao == null) {
			servicoContratoDao = new ServicoContratoDao();
			this.setTransacaoDao(servicoContratoDao);
		}
		return servicoContratoDao;
	}

	private TipoLiberacaoDAO getTipoLiberacaoDAO() throws Exception {
		if (tipoLiberacaoDAO == null) {
			tipoLiberacaoDAO = new TipoLiberacaoDAO();
			this.setTransacaoDao(tipoLiberacaoDAO);
		}
		return tipoLiberacaoDAO;
	}

	private TipoMudancaDAO getTipoMudancaDAO() throws Exception {
		if (tipoMudancaDAO == null) {
			tipoMudancaDAO = new TipoMudancaDAO();
			this.setTransacaoDao(tipoMudancaDAO);
		}
		return tipoMudancaDAO;
	}

	private <DAO extends CrudDAO> void setTransacaoDao(final DAO dao) throws Exception {
		if (transactionControler != null) {
			this.getDao().setTransactionControler(transactionControler);
		}
	}

	private void setTransacao(final TransactionControler transactionControler) throws Exception {
		this.transactionControler = transactionControler;
	}

	private CalendarioDao dao;

	@Override
	protected CalendarioDao getDao() {
		if (dao == null) {
			dao = new CalendarioDao();
		}
		return dao;
	}
	
	/**
	 * Determina a Data Hora final, ou seja, o Prazo Limite.
	 *
	 * @param calculoDto
	 * @param bCalculaHoraInicio
	 * @return CalculoJornadaDTO
	 * @throws Exception
	 */
	public CalculoJornadaDTO calculaDataHoraFinal(final CalculoJornadaDTO calculoDto, final boolean bCalculaHoraInicio, final TransactionControler tc) throws Exception {
		
		if (calculoDto.getIdCalendario() == null) {
			throw new Exception("ID do calendrio no informado para clculo da data e hora");
		}
		if (calculoDto.getDataHoraInicial() == null) {
			throw new Exception("Data e hora inicial no informadas para clculo da data e hora");
		}
		if (calculoDto.getPrazoHH() == null) {
			throw new Exception("Prazo em horas no informado para clculo da data e hora");
		}
		if (calculoDto.getPrazoMM() == null) {
			throw new Exception("Prazo em minutos no informado para clculo da data e hora");
		}

		this.setTransacao(tc);
		final CalendarioDTO calendarioDto = this.recuperaCalendario(calculoDto.getIdCalendario());

		if (calendarioDto == null) {
			throw new Exception("Servio Contrato sem calendrio. Por favor selecione Calendrio em Servio Contrato!");
		}

		final double slaDefinido = calculoDto.getPrazoHH() + new Double(calculoDto.getPrazoMM()).doubleValue() / 60;

		final Timestamp dataHoraInicioSlaJornada = this.retornaDataHoraInicioDaProximaJornadaDeTrabalho(calendarioDto, calculoDto.getDataHoraInicial(), HORA_INICIO_JORNADA, true);
		
		final Timestamp dataHoraInicioSla = this.retornaDataHoraInicioDaProximaJornadaDeTrabalho(calendarioDto, calculoDto.getDataHoraInicial(), HORA_INICIO_CALCULADA, true);

		final double dataHoraInicioSlaDbl = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataHoraInicioSla));

		double prazoDisponivel = this.calculaCargaHoraria(calendarioDto, dataHoraInicioSla);

		double cargaHoraria = prazoDisponivel;

		int difDias = 0;

		Timestamp dataHoraTermino = this.retornaDataHoraInicioDaProximaJornadaDeTrabalho(calendarioDto, dataHoraInicioSla, HORA_TERMINO_JORNADA, false);
		boolean isDataTerminoMenoDataInicio = false;
		if(dataHoraTermino.before(dataHoraInicioSlaJornada)){
			dataHoraTermino = new Timestamp(dataHoraTermino.getTime() + (24 * 60 * 60 * 1000));
			isDataTerminoMenoDataInicio = true;
		}

		while (prazoDisponivel < slaDefinido) {
			dataHoraTermino = this.incrementaDias(dataHoraTermino, 1);
			dataHoraTermino = this.retornaDataHoraInicioDaProximaJornadaDeTrabalho(calendarioDto, dataHoraTermino, HORA_TERMINO_JORNADA, false);
			cargaHoraria = this.calculaCargaHorariaTotal(calendarioDto, dataHoraTermino);
			prazoDisponivel += cargaHoraria;
			difDias++;
		}
		
		if(difDias > 0 && isDataTerminoMenoDataInicio && !(prazoDisponivel == slaDefinido)){
			dataHoraTermino = new Timestamp(dataHoraTermino.getTime() - (24 * 60 * 60 * 1000));
		}

		if (prazoDisponivel > slaDefinido) {
			double hora = 0;

			if (difDias > 0) {
				double diferenca = cargaHoraria - (prazoDisponivel - slaDefinido);
				final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, new Date(dataHoraTermino.getTime()), -1);
				final double inicio[] = jornadaDto.getInicio();
				final double termino[] = jornadaDto.getTermino();
				int i = 1;
				while (i <= 5 && inicio[i] != 99 && diferenca > 0) {
					double ch = termino[i] - inicio[i];
					if(ch < 0){
						ch = 24d - inicio[i];
						ch += termino[i];
					}
					if (diferenca > ch) {
						diferenca = diferenca - (termino[i] - inicio[i]);
						if (diferenca < 0) {
							diferenca = 0;
						}
						hora = inicio[i] + diferenca;
					} else {
						hora = inicio[i] + diferenca;
						diferenca = 0;
					}
					i++;
				}
			} else {
				double diferenca = cargaHoraria - (prazoDisponivel - slaDefinido);
				final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, new Date(dataHoraTermino.getTime()), -1);
				final double inicio[] = jornadaDto.getInicio();
				final double termino[] = jornadaDto.getTermino();
				int i = 1;
				while (i <= 5 && inicio[i] != 99 && diferenca > 0) {
					if (dataHoraInicioSlaDbl >= inicio[i] && dataHoraInicioSlaDbl <= termino[i]) {

						hora = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataHoraInicioSla)) + diferenca;

						for (int j = i; j <= 5; j++) {
							if (termino[j] != 0.0 && hora > termino[j] && inicio[j + 1] != 99.9) {
								hora += inicio[j + 1] - termino[j];
								diferenca = 0;
							}
						}
					} else if (termino[i] < inicio[i]){
						hora = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataHoraInicioSla)) + diferenca - 24d;

						for (int j = i; j <= 5; j++) {
							if (termino[j] != 0.0 && hora > termino[j] && inicio[j + 1] != 99.9) {
								hora += inicio[j + 1] - termino[j];
								diferenca = 0;
							}
						}
					}
					i++;
				}
			}

			hora = (hora >= 24d ? hora - 24d : hora);
			
			final Date dataRef = new Date(dataHoraTermino.getTime());

			dataHoraTermino = Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(hora) + ":00");
		}

		calculoDto.setDataHoraFinal(dataHoraTermino);
		return calculoDto;
	}

	/**
	 * Realiza o clculo de Tempo Decorrido de acordo com a data hora atual informada e o calendrio.
	 *
	 * @param calculoDto
	 *            - Instancia de CalculoJornadaDTO que dever ser instanciada utilizando o construtor sobrecarregado que recebe o ID do Calendrio e a Data Hora inicial.
	 * @param dataHoraAtual
	 *            - Timestamp da data hora atual.
	 * @return CalculoJornadaDTO - DTO de CalculoJornada com os atributos TempoDecorridoHH e TempoDecorridoMM
	 * @throws Exception
	 * @author carlos.santos
	 * @author gilberto.nery - alterado em 2016-09-28
	 * @version 1.0 de 03.07.2013 por valdoilo.damasceno
	 */
	public CalculoJornadaDTO calculaPrazoDecorrido(final CalculoJornadaDTO calculoDto, final Timestamp dataHoraAtual, final TransactionControler tc) throws Exception {
		calculoDto.setDataHoraFinal(dataHoraAtual);
		return calculaTempoDecorridoPelaJornadaDeTrabalho(calculoDto, tc);
	}

	public boolean horaAtualDepoisDoUltimoTerminoDeJornada(JornadaTrabalhoDTO jornadaDto, double horaAtual) {
		boolean horaAtualDepoisDoUltimoTerminoDeJornada = true;
		final double termino[] = jornadaDto.getTermino();
		for (int i = 1; i <= 5; i++) {
			if (horaAtual <= termino[i]) {
				horaAtualDepoisDoUltimoTerminoDeJornada = false;
				break;
			}
		}

		return horaAtualDepoisDoUltimoTerminoDeJornada;
	}


	/**
	 * Converte o prazo decorrido considerando as horas, minutos e segundos para o HH:MM:SS
	 * Alterado em 28/12/2015 por @gilberto.nery
	 * Solicitacao: 183396
	 * 
	 * @param calculoDto
	 * @param dataHoraAtual
	 * @param tc
	 * @return
	 * @throws Exception
	 */
	@Override
	public CalculoJornadaDTO calculaPrazoDecorridoComSegundos(final CalculoJornadaDTO calculoDto, Timestamp dataHoraAtual, final TransactionControler tc) throws Exception {

		this.setTransacao(tc);
		
		double prazoDecorrido = calcularPrazoDecorridoComSegundos(calculoDto, dataHoraAtual, tc);
        
        calculoDto.setTempoDecorridoHH(new Integer(Util.getHoraHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoMM(new Integer(Util.getMinutoHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoSS(new Integer(Util.getSegundoHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoTotalEmSegundos(prazoDecorrido);
        
		return calculoDto;
	}
	
	/**
	 * Converte o prazo decorrido considerando as horas, minutos e segundos para o HH:MM:SS
	 * Alterado em 28/12/2015 por @gilberto.nery
	 * Solicitacao: 183396
	 * 
	 * @param calculoDto
	 * @param dataHoraAtual
	 * @param tc
	 * @return
	 * @throws Exception
	 */
	public CalculoJornadaDTO calculaPrazoDecorridoComSegundos(Integer idCalendario, Timestamp dataHoraInicial, Timestamp dataHoraFinal, final TransactionControler tc) throws Exception {

		this.setTransacao(tc);
		
		return calcularPrazoDecorridoComSegundos(idCalendario, dataHoraInicial, dataHoraFinal, tc);
        
	}
	
	/**
	 * Calcula o prazo decorrido considerando as horas, minutos e segundos
	 * Alterado em 28/12/2015 por @gilberto.nery
	 * Solicitacao: 183396
	 * 
	 * @param calculoDto
	 * @param dataHoraAtual
	 * @param tc
	 * @return
	 * @throws Exception
	 * 
	 * 
	 * Existe um erro nesse metodo que acontece quando a solicitacao e fechada fora da jornada de trabalho, refatorar metodo para melhor entendimento
	 * Ex.: calcularPrazoDecorridoEmSegundosConsiderandoJornadaDeTrabalho
	 * 
	 */
	@Deprecated
	public double calcularPrazoDecorridoComSegundos(final CalculoJornadaDTO calculoDto, Timestamp dataHoraAtual, final TransactionControler tc) throws Exception {

        if (calculoDto.getIdCalendario() == null) throw new Exception("ID do calendrio no informado para clculo da data e hora");
        
        if (calculoDto.getDataHoraInicial() == null) throw new Exception("Data e hora inicial no informadas para clculo da data e hora");

		this.setTransacao(tc);
        
		final CalendarioDTO calendarioDto = this.recuperaCalendario(calculoDto.getIdCalendario());

        if (calculoDto.getDataHoraInicial().compareTo(dataHoraAtual) > 0) throw new Exception("Data e Hora Inicial maior que Data e Hora Final");

        //Calcula data somente HH:MM porque na jornada de trabalho so cadastra HH:MM tambem
        Timestamp dataHoraInicial = this.calculaDataHoraJornadaContabilizandoOsSegundos(calendarioDto, calculoDto.getDataHoraInicial(), HORA_INICIO_CALCULADA, true);

        Calendar calendarDataHoraAtual = Calendar.getInstance();
		calendarDataHoraAtual.setTimeInMillis(dataHoraAtual.getTime());

        dataHoraAtual = new Timestamp(calendarDataHoraAtual.getTimeInMillis()); 

		double prazoDecorrido = 0.00;
		int difDias = this.calculaDiferencaDeDiasEntreAsDatas(dataHoraAtual, dataHoraInicial);
		boolean bMaisDeUmDia = difDias > 0;
        
        //Todos os metodos daqui para frente que realizam calculo de horas, estao considerando os segundos
		if (difDias > 0) {
            prazoDecorrido += this.calculaCargaHorariaContandoMinutosESegundos(calendarioDto, dataHoraInicial);
			while (difDias > 0) {
				dataHoraInicial = this.incrementaDias(dataHoraInicial, 1);
                dataHoraInicial = this.calculaDataHoraJornadaContabilizandoOsSegundos(calendarioDto, dataHoraInicial, HORA_INICIO_JORNADA, false);
				difDias = this.calculaDiferencaDeDiasEntreAsDatas(dataHoraAtual, dataHoraInicial);
				if (difDias > 0) {
                    prazoDecorrido += this.calculaCargaHorariaTotalContabilizandoMinutoESegundo(calendarioDto, dataHoraInicial);
				} else {
					bMaisDeUmDia = false;
				}
			}
		}
		
		if (difDias == 0) {
			final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, new Date(dataHoraInicial.getTime()), -1);
            final double horaAtual = Util.getHoraMinutoESegundosDbl(UtilDatas.getHoraHHMMSS(dataHoraAtual));
            final double inicio[] = jornadaDto.getInicioComSegundos();
			if (inicio[1] < horaAtual) {
				boolean bCalculou = false;
                final double termino[] = jornadaDto.getTerminoComSegundos();
				for (int i = 1; i <= 5; i++) {
					if (inicio[i] == 99) {
						break;
					}
					if (inicio[i] <= horaAtual && termino[i] > horaAtual) {
						int p = i;

						if (bMaisDeUmDia) {
							while (p > 1) {
								prazoDecorrido += termino[p] - inicio[p]; // Acumula turnos da jornada - OBS VALDOILO - ISSO S FUNCIONA QUANDO O NMERO DE DIAS  MAIOR QUE 1
								p = p - 1;
							}
						}

						if (horaAtual < termino[i]) {
							double hrInicio = inicio[i];

							if (bMaisDeUmDia) {
								prazoDecorrido += horaAtual - hrInicio; // Acumula o tempo decorrido dentro do turno - OBS. VALDOLO - ISSO S FUNCIONA QUANDO O NMERO DE DIAS 
																		// MAIOR QUE 1
							} else {
                                hrInicio = Util.getHoraMinutoESegundosDbl(UtilDatas.getHoraHHMMSS(dataHoraInicial));
								prazoDecorrido += horaAtual - hrInicio;

								double intervalo = 0;
								for (int j = 1; j <= 5; j++) {
									if (jornadaDto.getTermino(j) != null && jornadaDto.getInicio(j + 1) != null) {
                                        final double hrTermino = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino(j));
										if (horaAtual > hrTermino && hrTermino > hrInicio) {
                                            intervalo += Util.calculaDuracaoComMinutoESegundo(jornadaDto.getTermino(j), jornadaDto.getInicio(j + 1));
										}
									}
								}

								if (intervalo < prazoDecorrido) {
									prazoDecorrido -= intervalo;
								}
							}

						} else {
							prazoDecorrido += termino[i] - inicio[i]; // Acumula turno integral da jornada
						}
						bCalculou = true;
					}
				}
				if (!bCalculou) { // Ocorre quando a hora do tsRef est acima do horrio de trmino da jornada
					if (bMaisDeUmDia) { // Quando  mais de um dia, acumula a jornada total
                        prazoDecorrido += this.calculaCargaHorariaTotalContabilizandoMinutoESegundo(calendarioDto, dataHoraInicial);
					} else {
                        final double horaInicioSlaDbl = Util.getHoraMinutoESegundosDbl(UtilDatas.getHoraHHMMSS(dataHoraInicial));
                        if (this.verificarSeHoraMinutoSegundoEstaForaDaJornadaDeTrabalho(jornadaDto, horaAtual)) { // Verifica se a hora do tsRef est num intervalo da jornada
                            prazoDecorrido += this.retornaProximaHoraMinutoSegundoTerminoJornada(jornadaDto, horaInicioSlaDbl) - horaInicioSlaDbl;
						} else {
                        	prazoDecorrido += this.calculaCargaHorariaContandoMinutosESegundos(calendarioDto, dataHoraInicial);
						}
					}
				}
			}
		}

		return prazoDecorrido;
		
	}
	
	/**
	 * Calcula o prazo decorrido considerando as horas, minutos e segundos
	 * Alterado em 28/12/2015 por @gilberto.nery
	 * Solicitacao: 183396
	 * 
	 * @param calculoDto
	 * @param dataHoraAtual
	 * @param tc
	 * @return
	 * @throws Exception
	 */
	@Deprecated
	public CalculoJornadaDTO calcularPrazoDecorridoComSegundos(Integer idCalendario, Timestamp dataHoraInicio, Timestamp dataHoraFim, final TransactionControler tc) throws Exception {

		CalculoJornadaDTO calculoDto = new CalculoJornadaDTO(idCalendario, dataHoraInicio, dataHoraFim);
		
        if (calculoDto.getIdCalendario() == null) throw new Exception("ID do calendrio no informado para clculo da data e hora");
        
        if (calculoDto.getDataHoraInicial() == null) throw new Exception("Data e hora inicial no informadas para clculo da data e hora");

		this.setTransacao(tc);
        
		final CalendarioDTO calendarioDto = this.recuperaCalendario(calculoDto.getIdCalendario());

        if (calculoDto.getDataHoraInicial().compareTo(calculoDto.getDataHoraFinal()) > 0) throw new Exception("Data e Hora Inicial maior que Data e Hora Final");

		double prazoDecorrido = 0.00;
		int qtdDiasDiferencaEntreInicialFinal = this.calculaDiferencaDeDiasEntreAsDatas(calculoDto.getDataHoraInicial(), calculoDto.getDataHoraInicial());
		boolean isMaisDeUmDia = qtdDiasDiferencaEntreInicialFinal > 0;
        
		if (qtdDiasDiferencaEntreInicialFinal > 0) {
			
			while (qtdDiasDiferencaEntreInicialFinal > 0) {
				
				prazoDecorrido += this.calculaCargaHorariaContandoMinutosESegundos(calendarioDto, calculoDto.getDataHoraInicial());
				
                dataHoraInicio = this.calculaDataHoraJornadaContabilizandoOsSegundos(calendarioDto, dataHoraInicio, HORA_INICIO_JORNADA, false);
                    prazoDecorrido += this.calculaCargaHorariaTotalContabilizandoMinutoESegundo(calendarioDto, dataHoraInicio);
				
				qtdDiasDiferencaEntreInicialFinal--;
				this.incrementaDias(dataHoraInicio, 1);
			}
		}
		
		prazoDecorrido = Util.converteHoraParaSegundos(prazoDecorrido);
		
		if (qtdDiasDiferencaEntreInicialFinal == 0) {
			final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, new Date(dataHoraInicio.getTime()), -1);
            final double horaAtual = Util.getHoraMinutoESegundosDbl(UtilDatas.getHoraHHMMSS(dataHoraInicio));
            final double inicio[] = jornadaDto.getInicioComSegundos();
			if (inicio[1] < horaAtual) {
				boolean bCalculou = false;
                final double termino[] = jornadaDto.getTerminoComSegundos();
				for (int i = 1; i <= 5; i++) {
					if (inicio[i] == 99) {
						break;
					}
					if (inicio[i] <= horaAtual && termino[i] > horaAtual) {
						int p = i;

						if (isMaisDeUmDia) {
							while (p > 1) {
								prazoDecorrido += termino[p] - inicio[p]; // Acumula turnos da jornada - OBS VALDOILO - ISSO S FUNCIONA QUANDO O NMERO DE DIAS  MAIOR QUE 1
								p = p - 1;
							}
						}

						if (horaAtual < termino[i]) {
							double hrInicio = inicio[i];

							if (isMaisDeUmDia) {
								prazoDecorrido += horaAtual - hrInicio; // Acumula o tempo decorrido dentro do turno - OBS. VALDOLO - ISSO S FUNCIONA QUANDO O NMERO DE DIAS 
																		// MAIOR QUE 1
							} else {
                                hrInicio = Util.getHoraMinutoESegundosDbl(UtilDatas.getHoraHHMMSS(dataHoraInicio));
								prazoDecorrido += horaAtual - hrInicio;

								double intervalo = 0;
								for (int j = 1; j <= 5; j++) {
									if (jornadaDto.getTermino(j) != null && jornadaDto.getInicio(j + 1) != null) {
                                        final double hrTermino = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino(j));
										if (horaAtual > hrTermino && hrTermino > hrInicio) {
                                            intervalo += Util.calculaDuracaoComMinutoESegundo(jornadaDto.getTermino(j), jornadaDto.getInicio(j + 1));
										}
									}
								}

								if (intervalo < prazoDecorrido) {
									prazoDecorrido -= intervalo;
								}
							}

						} else {
							prazoDecorrido += termino[i] - inicio[i]; // Acumula turno integral da jornada
						}
						bCalculou = true;
					}
				}
				if (!bCalculou) { // Ocorre quando a hora do tsRef est acima do horrio de trmino da jornada
					if (isMaisDeUmDia) { // Quando  mais de um dia, acumula a jornada total
                        prazoDecorrido += this.calculaCargaHorariaTotalContabilizandoMinutoESegundo(calendarioDto, dataHoraInicio);
					} else {
                        final double horaInicioSlaDbl = Util.getHoraMinutoESegundosDbl(UtilDatas.getHoraHHMMSS(dataHoraInicio));
                        if (this.verificarSeHoraMinutoSegundoEstaForaDaJornadaDeTrabalho(jornadaDto, horaAtual)) { // Verifica se a hora do tsRef est num intervalo da jornada
                            prazoDecorrido = this.retornaProximaHoraMinutoSegundoTerminoJornada(jornadaDto, horaInicioSlaDbl) - horaInicioSlaDbl;
						} else {
                        	prazoDecorrido = this.calculaCargaHorariaContandoMinutosESegundos(calendarioDto, dataHoraInicio);
						}
					}
				}
			}
		}

		calculoDto.setTempoDecorridoHH(new Integer(Util.getHoraHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoMM(new Integer(Util.getMinutoHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoSS(new Integer(Util.getSegundoHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoTotalEmSegundos(prazoDecorrido);
        
		return calculoDto;
		
	}

	private int calculaDiferencaDeDiasEntreAsDatas(final Timestamp tsFinal, final Timestamp tsInicial) throws Exception {
    	
        if (tsFinal.compareTo(tsInicial) < 0) return -1;
        
		int i = 0;
        
        SimpleDateFormat spd = new SimpleDateFormat("yyyyMMdd");
		Date dataRef = new Date(tsInicial.getTime());
		String dataRefInv = spd.format(dataRef).trim();
        
        String dataFinalInv = spd.format(new Date(tsFinal.getTime())).trim();
        
		while (dataRefInv.compareTo(dataFinalInv) < 0) {
			dataRef = new Date(UtilDatas.incrementaDiasEmData(dataRef, 1).getTime());
			dataRefInv = spd.format(dataRef).trim();
			i++;
		}
        
		return i;
        
	}

	public Timestamp incrementaDias(final Timestamp ts, final int qtdeDias) throws Exception {
		Date dataRef = new Date(ts.getTime());
		dataRef = new Date(UtilDatas.incrementaDiasEmData(dataRef, qtdeDias).getTime());
		return Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + "00:00:00");
	}

	
	/**
	 * Retorna a data/hora inicio da jornada de trabalho a partir da data de referencia
	 * 
	 * @param calendarioDto
	 * @param dataHoraRef
	 * @param tipoCalculoHora
	 * @param bUtilizaHorarioTimestamp
	 * @return
	 * @throws Exception
	 */
	private Timestamp retornaDataHoraInicioDaProximaJornadaDeTrabalho(final CalendarioDTO calendarioDto, final Timestamp dataHoraRef, final String tipoCalculoHora, final boolean bUtilizaHorarioTimestamp) throws Exception {
		final JornadaTrabalhoDTO jornadaDto = this.retornaProximoDiaUtil(calendarioDto, dataHoraRef, bUtilizaHorarioTimestamp);
		if (jornadaDto == null) {
			throw new Exception("No existem jornadas configuradas para este calendrio nos prximos 30 dias");
		}

		final double hora = Util.getHoraDbl(UtilDatas.getHoraHHMM(jornadaDto.getDataHoraInicial()));
		double horaUtil = hora;
		if (tipoCalculoHora.equalsIgnoreCase(HORA_INICIO_CALCULADA)) {
			horaUtil = this.calculaHoraUtilInicial(jornadaDto, hora);
		} else if (tipoCalculoHora.equalsIgnoreCase(HORA_INICIO_JORNADA)) {
			horaUtil = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		} else if (tipoCalculoHora.equalsIgnoreCase(HORA_TERMINO_JORNADA)) {
			horaUtil = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		} else {
			horaUtil = this.calculaHoraUtilFinal(jornadaDto, hora);
		}

		final Date dataRef = new Date(jornadaDto.getDataHoraInicial().getTime());
		return Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(horaUtil) + ":00");
	}

    /**
     * Calcula a data hora jornada contabilizando os segundos 
     * 
     * @param calendarioDto
     * @param dataHoraRef
     * @param tipoCalculoHora
     * @param bUtilizaHorarioTimestamp
     * @return
     * @throws Exception
     */
    private Timestamp calculaDataHoraJornadaContabilizandoOsSegundos(final CalendarioDTO calendarioDto, final Timestamp dataHoraRef, final String tipoCalculoHora,
            final boolean bUtilizaHorarioTimestamp) throws Exception {
        final JornadaTrabalhoDTO jornadaDto = this.verificaDiaUtilContabilizandoOsSegundos(calendarioDto, dataHoraRef, bUtilizaHorarioTimestamp);
		if (jornadaDto == null) {
			throw new Exception("No existem jornadas configuradas para este calendrio nos prximos 30 dias");
		}

		final Calendar calendarDataHoraInicial = Calendar.getInstance();
		calendarDataHoraInicial.setTimeInMillis(jornadaDto.getDataHoraInicial().getTime());
		final int segundos = calendarDataHoraInicial.get(Calendar.SECOND);

        
		final double hora = Util.getHoraDbl(UtilDatas.getHoraHHMM(jornadaDto.getDataHoraInicial()));
		double horaUtil = hora;
		if (tipoCalculoHora.equalsIgnoreCase(HORA_INICIO_CALCULADA)) {
			horaUtil = this.calculaHoraUtilInicial(jornadaDto, hora);
		} else if (tipoCalculoHora.equalsIgnoreCase(HORA_INICIO_JORNADA)) {
			horaUtil = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		} else if (tipoCalculoHora.equalsIgnoreCase(HORA_TERMINO_JORNADA)) {
			horaUtil = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		} else {
			horaUtil = this.calculaHoraUtilFinal(jornadaDto, hora);
		}

		final Date dataRef = new Date(jornadaDto.getDataHoraInicial().getTime());
		return Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(horaUtil) + ":" + UtilDatas.adicionaZeroAEsquerda(segundos));
	}

	public JornadaTrabalhoDTO retornaProximoDiaUtil(final CalendarioDTO calendarioDto, final Timestamp dataHoraRef, final boolean bUtilizaHorarioTimestamp) throws Exception {
		double horaRef = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataHoraRef));
		Date dataRef = new Date(dataHoraRef.getTime());
		double horaCalculo = -1;
		if (bUtilizaHorarioTimestamp) {
			horaCalculo = horaRef;
		}
		JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef, horaCalculo);
		int i = 0;
		while (jornadaDto == null && i < 30) {
			dataRef = new Date(UtilDatas.incrementaDiasEmData(dataRef, 1).getTime());
			jornadaDto = this.recuperaJornada(calendarioDto, dataRef, -1);
			if (jornadaDto != null) {
				horaRef = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
			}
			i++;
		}

		if (jornadaDto != null) {
			final double horaInicio = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
			if (horaRef > horaInicio) {
				jornadaDto.setDataHoraInicial(Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(horaRef) + ":00"));
			} else {
				jornadaDto.setDataHoraInicial(Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(horaInicio) + ":00"));
			}
		}

		return jornadaDto;
	}
	
    public JornadaTrabalhoDTO verificaDiaUtilContabilizandoOsSegundos(final CalendarioDTO calendarioDto, final Timestamp dataHoraRef, final boolean bUtilizaHorarioTimestamp) throws Exception {

		final Calendar calendarDataHoraRef = Calendar.getInstance();
		calendarDataHoraRef.setTimeInMillis(dataHoraRef.getTime());
		final int segundos = calendarDataHoraRef.get(Calendar.SECOND);

		double horaRef = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataHoraRef));
		Date dataRef = new Date(dataHoraRef.getTime());
		double horaCalculo = -1;
		if (bUtilizaHorarioTimestamp) {
			horaCalculo = horaRef;
		}
		JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef, horaCalculo);
		int i = 0;
		while (jornadaDto == null && i < 30) {
			dataRef = new Date(UtilDatas.incrementaDiasEmData(dataRef, 1).getTime());
			jornadaDto = this.recuperaJornada(calendarioDto, dataRef, -1);
			if (jornadaDto != null) {
				horaRef = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
			}
			i++;
		}

		if (jornadaDto != null) {
			final double horaInicio = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
			if (horaRef > horaInicio) {
				jornadaDto.setDataHoraInicial(Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(horaRef) + ":"
						+ UtilDatas.adicionaZeroAEsquerda(segundos)));
			} else {
				jornadaDto.setDataHoraInicial(Timestamp.valueOf(UtilDatas.dateToSTRWithFormat(dataRef, "yyyy-MM-dd") + " " + Util.getHoraFmtStr(horaInicio) + ":"
                        + UtilDatas.adicionaZeroAEsquerda(0)));
			}
		}

		return jornadaDto;
	}

	public JornadaTrabalhoDTO recuperaJornada(final CalendarioDTO calendarioDto, final Date dataRef, final double horaRef) throws Exception {
		final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
		if (jornadaDto == null) {
			return null;
		}

		return jornadaDto;
	}

	@Override
	public CalendarioDTO recuperaCalendario(final Integer idCalendario) throws Exception {
		if (transactionControler != null && transactionControler.isStarted() == true) {
			this.getDao().setTransactionControler(transactionControler);
		}
		final CalendarioDTO calendarioDto = new CalendarioDTO();
		calendarioDto.setIdCalendario(idCalendario);
		return (CalendarioDTO) this.getDao().restore(calendarioDto);
	}

	@Override
	public JornadaTrabalhoDTO recuperaJornada(final CalendarioDTO calendarioDto, final Date dataRef) throws Exception {
		Integer idJornada = calendarioDto.getIdJornada(dataRef);

		final ExcecaoCalendarioDTO excecaoDto = this.getExcecaoCalendarioDAO().findByIdCalendarioAndData(calendarioDto.getIdCalendario(), dataRef);
		if (excecaoDto != null && excecaoDto.getTipo().equalsIgnoreCase(TRABALHO)) {
			idJornada = excecaoDto.getIdJornada();
		}
		if (excecaoDto != null && excecaoDto.getTipo().equalsIgnoreCase(FOLGA)) {
			return null;
		}

		if (idJornada == null) {
			return null;
		}

		boolean bFeriado = false;
		if (calendarioDto.getConsideraFeriados() != null && calendarioDto.getConsideraFeriados().equalsIgnoreCase("S")) {
			bFeriado = this.getFeriadoDAO().isFeriado(dataRef, null, null);
		}

		if (bFeriado) {
			return null;
		}

		JornadaTrabalhoDTO jornadaDto = new JornadaTrabalhoDTO();
		jornadaDto.setIdJornada(idJornada);
		jornadaDto = (JornadaTrabalhoDTO) this.getJornadaTrabalhoDAO().restore(jornadaDto);
		return jornadaDto;
	}

	private double calculaHoraUtilInicial(final JornadaTrabalhoDTO jornadaDto, final double horaRef) throws Exception {
		if (jornadaDto == null) {
			return 0.0;
		}

		final double[] hrInicio = new double[] { 99, 99, 99, 99, 99, 99 };
		final double[] hrTermino = new double[] { 0, 0, 0, 0, 0, 0 };

		for (int i = 1; i <= 5; i++) {
			if (jornadaDto.getInicio(i) != null) {
				hrInicio[i] = Util.getHoraDbl(jornadaDto.getInicio(i));
				hrTermino[i] = Util.getHoraDbl(jornadaDto.getTermino(i));
			}
		}

		double horaUtilDbl = 0.0;
		int i = 1;
		while (horaUtilDbl == 0.0 && i <= 5) {
			if (hrInicio[i] != 99 && (hrInicio[i] <= horaRef || i > 1) && hrTermino[i] >= horaRef) {
				horaUtilDbl = hrInicio[i];
			}
			i++;
		}

		if (horaUtilDbl > horaRef) {
			return horaUtilDbl;
		} else {
			return horaRef;
		}
	}

	private double calculaHoraUtilFinal(final JornadaTrabalhoDTO jornadaDto, final double horaRef) throws Exception {
		if (jornadaDto == null) {
			return 0.0;
		}

		final double[] hrInicio = new double[] { 99, 99, 99, 99, 99, 99 };
		final double[] hrTermino = new double[] { 0, 0, 0, 0, 0, 0 };

		for (int i = 1; i <= 5; i++) {
			if (jornadaDto.getInicio(i) != null) {
				hrInicio[i] = Util.getHoraDbl(jornadaDto.getInicio(i));
				hrTermino[i] = Util.getHoraDbl(jornadaDto.getTermino(i));
			}
		}

		double horaUtilDbl = 99;
		int i = 1;
		while (horaUtilDbl == 99 && i <= 5) {
			if (hrTermino[i] != 99 && hrTermino[i] >= horaRef) {
				horaUtilDbl = hrTermino[i];
			}
			i++;
		}

		if (horaUtilDbl > horaRef) {
			return horaUtilDbl;
		} else {
			return horaRef;
		}
	}

	
	/**
	 * Retorna a hora termino das ultimas jornadas de trabalho do dia
     * 
     * Ex: 12:00 / 18:00 - Vai retornar a ultima jornada = 18:00
     * 
	 * @param jornadaDto
	 * @return
	 * @throws Exception
	 */
	private double retornaHoraTerminoDoUltimoIntervaloDaJornada(final JornadaTrabalhoDTO jornadaDto) throws Exception {
		double horaFinalDbl = -1;
		if (jornadaDto.getTermino5() != null && jornadaDto.getTermino5().trim().length() > 0) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino5());
		} else if (jornadaDto.getTermino4() != null && jornadaDto.getTermino4().trim().length() > 0) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino4());
		} else if (jornadaDto.getTermino3() != null && jornadaDto.getTermino3().trim().length() > 0) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino3());
		} else if (jornadaDto.getTermino2() != null && jornadaDto.getTermino2().trim().length() > 0) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino2());
		} else if (jornadaDto.getTermino1() != null && jornadaDto.getTermino1().trim().length() > 0) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino1());
		}

		return horaFinalDbl;
	}
	
	
	/**
	 * Retorna a hora de termino da jornadas solicitada
	 * 
	 * @param jornadaDto
	 * @param intervalo - O intervalo solicitado
	 * @return
	 * @throws Exception
	 */
	private double retornaHoraTerminoDaJornada(final JornadaTrabalhoDTO jornadaDto, int intervalo) throws Exception {
		double horaFinalDbl = -1;
		if (jornadaDto.getTermino1() != null && jornadaDto.getTermino1().trim().length() > 0 && intervalo == 1) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino1());
		} else if (jornadaDto.getTermino2() != null && jornadaDto.getTermino2().trim().length() > 0 && intervalo == 2) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino2());
		} else if (jornadaDto.getTermino3() != null && jornadaDto.getTermino3().trim().length() > 0 && intervalo == 3) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino3());
		} else if (jornadaDto.getTermino4() != null && jornadaDto.getTermino4().trim().length() > 0 && intervalo == 4) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino4());
		} else if (jornadaDto.getTermino5() != null && jornadaDto.getTermino5().trim().length() > 0 && intervalo == 5) {
			horaFinalDbl = Util.getHoraDbl(jornadaDto.getTermino1());
		}

		return horaFinalDbl;
	}
	
    public double retornaHoraTerminoJornadaContabilizandoMinutoSegundo(final JornadaTrabalhoDTO jornadaDto) throws Exception {
    	
        double horaFinalDbl = -1;
        if (jornadaDto.getTermino5() != null && jornadaDto.getTermino5().trim().length() > 0) {
            horaFinalDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino5());
        } else if (jornadaDto.getTermino4() != null && jornadaDto.getTermino4().trim().length() > 0) {
            horaFinalDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino4());
        } else if (jornadaDto.getTermino3() != null && jornadaDto.getTermino3().trim().length() > 0) {
            horaFinalDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino3());
        } else if (jornadaDto.getTermino2() != null && jornadaDto.getTermino2().trim().length() > 0) {
            horaFinalDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino2());
        } else if (jornadaDto.getTermino1() != null && jornadaDto.getTermino1().trim().length() > 0) {
            horaFinalDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino1());
        }

        return horaFinalDbl;
    }

    /**
     * 
     * Retorna a hora inicio das primeiras jornadas de trabalho
     * 
     * Ex: 08:00 / 12:00 - Vai retornar o primeiro inicio da jornada = 08:00 
     * 
     * @param jornadaDto
     * @return
     * @throws Exception
     */
	private double retornaHoraInicioDoPrimeiroIntervaloJornada(final JornadaTrabalhoDTO jornadaDto) throws Exception {
		double horaInicialDbl = -1;
		if (jornadaDto.getInicio1() != null && jornadaDto.getInicio1().trim().length() > 0) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio1());
		} else if (jornadaDto.getInicio2() != null && jornadaDto.getInicio2().trim().length() > 0) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio2());
		} else if (jornadaDto.getInicio3() != null && jornadaDto.getInicio3().trim().length() > 0) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio3());
		} else if (jornadaDto.getInicio4() != null && jornadaDto.getInicio4().trim().length() > 0) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio4());
		} else if (jornadaDto.getInicio5() != null && jornadaDto.getInicio5().trim().length() > 0) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio5());
		}

		return horaInicialDbl;
	}
	
	/**
	 * Retorna a hora inicio da jornadas solicitada
	 * 
	 * @param jornadaDto
	 * @param intervalo - O intervalo solicitado
	 * @return
	 * @throws Exception
	 */
	private double retornaHoraInicioDaJornada(final JornadaTrabalhoDTO jornadaDto, int intervalo) throws Exception {
		double horaInicialDbl = -1;
		if (jornadaDto.getInicio5() != null && jornadaDto.getInicio5().trim().length() > 0 && intervalo == 5) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio5());
		} else if (jornadaDto.getInicio4() != null && jornadaDto.getInicio4().trim().length() > 0 && intervalo == 4) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio4());
		} else if (jornadaDto.getInicio3() != null && jornadaDto.getInicio3().trim().length() > 0 && intervalo == 3) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio3());
		} else if (jornadaDto.getInicio2() != null && jornadaDto.getInicio2().trim().length() > 0 && intervalo == 2) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio2());
		} else if (jornadaDto.getInicio1() != null && jornadaDto.getInicio1().trim().length() > 0 && intervalo == 1) {
			horaInicialDbl = Util.getHoraDbl(jornadaDto.getInicio1());
		}

		return horaInicialDbl;
	}

    public double retornaHoraInicioJornadaContabilizandoMinutoSegundo(final JornadaTrabalhoDTO jornadaDto) throws Exception {
        double horaInicialDbl = -1;
        if (jornadaDto.getInicio1() != null && jornadaDto.getInicio1().trim().length() > 0) {
            horaInicialDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getInicio1());
        } else if (jornadaDto.getInicio2() != null && jornadaDto.getInicio2().trim().length() > 0) {
            horaInicialDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getInicio2());
        } else if (jornadaDto.getInicio3() != null && jornadaDto.getInicio3().trim().length() > 0) {
            horaInicialDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getInicio3());
        } else if (jornadaDto.getInicio4() != null && jornadaDto.getInicio4().trim().length() > 0) {
            horaInicialDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getInicio4());
        } else if (jornadaDto.getInicio5() != null && jornadaDto.getInicio5().trim().length() > 0) {
            horaInicialDbl = Util.getHoraMinutoESegundosDbl(jornadaDto.getInicio5());
        }

        return horaInicialDbl;
    }

	private double calculaIntervalos(final JornadaTrabalhoDTO jornadaDto, final double horaInicial) throws Exception {
		double intervalo = 0;
		for (int i = 1; i <= 5; i++) {
			if (jornadaDto.getTermino(i) != null && jornadaDto.getInicio(i + 1) != null) {
				final double hr = Util.getHoraDbl(jornadaDto.getTermino(i));
				if (hr >= horaInicial) {
					intervalo += Util.calculaDuracao(jornadaDto.getTermino(i), jornadaDto.getInicio(i + 1));
				}
			}
		}
		return intervalo;
	}

    private double calculaIntervalosContabilizandoMinutoESegundos(final JornadaTrabalhoDTO jornadaDto, final double horaInicial) throws Exception {
    	
        double intervalo = 0;
        for (int i = 1; i <= 5; i++) {
            if (jornadaDto.getTermino(i) != null && jornadaDto.getInicio(i + 1) != null) {
                final double hr = Util.getHoraMinutoESegundosDbl(jornadaDto.getTermino(i));
                if (hr >= horaInicial) {
                    intervalo += Util.calculaDuracaoComMinutoESegundo(jornadaDto.getTermino(i), jornadaDto.getInicio(i + 1));
                }
            }
        }
        return intervalo;
    }

    /**
     * Verifica se a hora informada est fora da Jornada de trabalho. Ou seja, fora de um intervalo vlido na Jornada.
     * Leva em considerao os segundos
     *
     * @param jornadaDto
     * @param hora
     * @return true - Est fora da Jornada de Trabalho.
     * @throws Exception
     * @author valdoilo.damasceno
     */
    private boolean verificarSeHoraMinutoSegundoEstaForaDaJornadaDeTrabalho(final JornadaTrabalhoDTO jornadaDto, final double hora) throws Exception {
        boolean result = true;
        final double inicio[] = jornadaDto.getInicioComSegundos();
        final double termino[] = jornadaDto.getTerminoComSegundos();
        for (int i = 1; i <= 5; i++) {
            if (hora >= inicio[i] && hora <= termino[i]) {
                result = false;
                break;
            }
        }

        return result;
    }
    
	private double calculaCargaHoraria(final CalendarioDTO calendarioDto, final Timestamp ts) throws Exception {
		final Date dataRef = new Date(ts.getTime());
		final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
		if (jornadaDto == null) {
			return 0.0;
		}

		final double horaInicial = Util.getHoraDbl(UtilDatas.getHoraHHMM(ts));
		final double horaInicialJornada = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		final double horaFinal = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		double finalMenosInicial = horaFinal - horaInicial;
		if(finalMenosInicial < 0d && horaFinal < horaInicialJornada){
			finalMenosInicial = 24d - horaInicial;
			finalMenosInicial += horaFinal;
		}
		final double result = finalMenosInicial - this.calculaIntervalos(jornadaDto, horaInicial);
		if (result > 0) {
			return result;
		}
		return 0;
	}
	
	/**
	 * Realiza o ajuste da jornada quando o turno for de 24 horas (hora inical for maior que a hora final)
	 * @param calendarioDto
	 * @param ts
	 * @return
	 * @throws Exception
	 */
	private double calculaAjusteDaJornada(final CalendarioDTO calendarioDto, final Timestamp ts) throws Exception {
		final Date dataRef = new Date(ts.getTime());
		final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
		if (jornadaDto == null) {
			return 0.0;
		}

		final double horaFinal = Util.getHoraDbl(UtilDatas.getHoraHHMM(ts));
		final double horaFinalJornada = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		return horaFinalJornada - horaFinal;
		
	}
	
	
	/**
	 * Calcula a carga horaria do dia trabalhado considerando o termino da jornada de trabalho 
	 * 
	 * @param calendarioDto
	 * @param calculoJornada
	 * @return
	 * @throws Exception
	 */
	public double calculaCargaHorariaDoDia(CalendarioDTO calendarioDto, CalculoJornadaDTO calculoJornada) throws Exception {
		return calculaCargaHorariaDoDia(calendarioDto, calculoJornada.getDataHoraInicial(), calculoJornada.getDataHoraFinal());
	}

	
	/**
	 * Calcula a carga horaria do dia trabalhado considerando o termino da jornada de trabalho
	 * 
	 * @param calendarioDto
	 * @param dataInicial
	 * @param dataFinal
	 * @return
	 * @throws Exception
	 */
	public double calculaCargaHorariaDoDia(CalendarioDTO calendarioDto, Timestamp dataInicial, Timestamp dataFinal) throws Exception {
		final Date dataRef = new Date(dataInicial.getTime());
		
		final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
		if (jornadaDto == null) {
			return 0.0;
		}

		//Hora inicio e fim real
		double horaInicial = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataInicial));
		double horaFinal = Util.getHoraDbl(UtilDatas.getHoraHHMM(dataFinal));
		
		//Hora inicio e fim da jornada
		double horaInicialJornada = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		double horaFinalJornada = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		
		double result = 0;
		
		if(validaSeExisteIntervaloNaJornada(jornadaDto)){
			
			int qtdIntervalo = calculaQuantidadeDeIntervalosNaJornada(jornadaDto);
			int intervalo = 1;
				
			//Percorre os intervalos da jornada
			while(qtdIntervalo > 0){
				
				//Busca o inicio e o fim do turno da jornada
				horaInicialJornada = this.retornaHoraInicioDaJornada(jornadaDto, intervalo);
				horaFinalJornada = this.retornaHoraTerminoDaJornada(jornadaDto, intervalo);

				if(horaFinal > horaFinalJornada){
					if(horaInicial > horaInicialJornada && horaInicial < horaFinalJornada){
						result += horaFinalJornada - horaInicial;
					} else if(horaInicial < horaFinalJornada){
						result += horaFinalJornada - horaInicialJornada;						
					}
				} else if(horaFinal <= horaFinalJornada && horaFinal > horaInicialJornada){
					if(horaInicial > horaInicialJornada){
						result += horaFinal - horaInicial;
					} else {
						result += horaFinal - horaInicialJornada;						
					}
				}
				qtdIntervalo--;
				intervalo++;
			}
			return result;
		}
			
		if(horaFinalJornada > horaFinal){
			horaFinalJornada = horaFinal;
		}
		
		if(horaInicialJornada > horaInicial){
			horaInicial = horaInicialJornada;
		}
		
		double finalMenosInicial = horaFinalJornada - horaInicial;
		if(finalMenosInicial < 0d && horaFinalJornada < horaInicialJornada){
			finalMenosInicial = 24d - horaInicial;
			finalMenosInicial += horaFinalJornada;
		}
		
		if(finalMenosInicial > 0)
			return finalMenosInicial;
		else
			return 0;
				
	}

	/**
	 * Verifica se existe mais de um inicio na jornada
	 * 
	 * @param jornadaDto
	 * @return true: jornada possui intervalo
	 * 		   false:jornada nao possui intervalo
	 */
    private boolean validaSeExisteIntervaloNaJornada(JornadaTrabalhoDTO jornadaDto) {

    	int contador = 0;
    	if(jornadaDto.getInicio1() != null && jornadaDto.getInicio1().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio2() != null && jornadaDto.getInicio2().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio3() != null && jornadaDto.getInicio3().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio4() != null && jornadaDto.getInicio4().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio5() != null && jornadaDto.getInicio5().trim().length() > 0){
    		contador++;
    	}
    	
		return contador >= 2;
	}

    
    /**
     * Retorna a quantidade de intervalos na jornada
     * 
     * @param jornadaDto
     * @return
     */
    private int calculaQuantidadeDeIntervalosNaJornada(JornadaTrabalhoDTO jornadaDto) {

    	int contador = 0;
    	if(jornadaDto.getInicio1() != null && jornadaDto.getInicio1().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio2() != null && jornadaDto.getInicio2().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio3() != null && jornadaDto.getInicio3().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio4() != null && jornadaDto.getInicio4().trim().length() > 0){
    		contador++;
    	}
    	
    	if(jornadaDto.getInicio5() != null && jornadaDto.getInicio5().trim().length() > 0){
    		contador++;
    	}
    	
		return contador;
	}

	/**
     * Calcula a carga horaria total contabilizando HH MM SS
     * 
     * @param calendarioDto
     * @param ts
     * @return
     * @throws Exception
     */
    private double calculaCargaHorariaContandoMinutosESegundos(final CalendarioDTO calendarioDto, final Timestamp ts) throws Exception {
    	
        final Date dataRef = new Date(ts.getTime());
        final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
        if (jornadaDto == null) {
            return 0.0;
        }

        final double horaInicial = Util.getHoraDbl(UtilDatas.getHoraHHMMSS(ts));
		final double horaInicialJornada = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		final double horaFinal = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		double finalMenosInicial = horaFinal - horaInicial;
		if(finalMenosInicial < 0d && horaFinal < horaInicialJornada){
			finalMenosInicial = 24d - horaInicial;
			finalMenosInicial += horaFinal;
		}
		final double result = finalMenosInicial - this.calculaIntervalos(jornadaDto, horaInicial);
		if (result > 0) {
            return result;
        }
        return 0;
    }
    
	private double calculaCargaHorariaTotal(final CalendarioDTO calendarioDto, final Timestamp ts) throws Exception {
		final Date dataRef = new Date(ts.getTime());
		final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
		if (jornadaDto == null) {
			return 0.0;
		}

		final double horaInicial = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		final double horaFinal = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		double finalMenosInicial = horaFinal - horaInicial;
		if(finalMenosInicial < 0d){
			finalMenosInicial = 24d - horaInicial;
			finalMenosInicial += horaFinal;
		}
		final double result = finalMenosInicial - this.calculaIntervalos(jornadaDto, horaInicial);
		if (result > 0) {
			return result;
		} else {
			return 0;
		}
	}

    private double calculaCargaHorariaTotalContabilizandoMinutoESegundo(final CalendarioDTO calendarioDto, final Timestamp ts) throws Exception {
    	
        final Date dataRef = new Date(ts.getTime());
        final JornadaTrabalhoDTO jornadaDto = this.recuperaJornada(calendarioDto, dataRef);
        
        if (jornadaDto == null) {
            return 0.0;
        }

        final double horaInicial = this.retornaHoraInicioDoPrimeiroIntervaloJornada(jornadaDto);
		final double horaFinal = this.retornaHoraTerminoDoUltimoIntervaloDaJornada(jornadaDto);
		double finalMenosInicial = horaFinal - horaInicial;
		if(finalMenosInicial < 0d){
			finalMenosInicial = 24d - horaInicial;
			finalMenosInicial += horaFinal;
		}

        final double result = finalMenosInicial - this.calculaIntervalosContabilizandoMinutoESegundos(jornadaDto, horaInicial);
        if (result > 0) {
            return result;
        } else {
            return 0;
        }
        
    }

	@Override
	public boolean jornadaDeTrabalhoEmUso(final JornadaTrabalhoDTO jornadaTrabalhoDTO) throws Exception {
		boolean resp = false;

		final Integer idJornada = jornadaTrabalhoDTO.getIdJornada();
		resp = this.getDao().verificaJornada(idJornada);

		return resp;
	}

	@Override
	public boolean verificaSeExisteCalendario(final CalendarioDTO calendarioDTO) throws Exception {
		return this.getDao().verificaSeExisteCalendario(calendarioDTO);
	}

	/**
     * retorna o fim de um jornada proxima a hora passada considerando HH MM SS
     *
     * @param jornadaDto
     * @param hora
     * @return
     */
    private double retornaProximaHoraMinutoSegundoTerminoJornada(final JornadaTrabalhoDTO jornadaDto, final double hora) {
        final double termino[] = jornadaDto.getTerminoComSegundos();
        for (int i = 1; i <= 5; i++) {
            if (termino[i] == 0) {
                break;
            }
            if (termino[i] != 0 && termino[i] >= hora) {
                return termino[i];
            }
        }
        return 0;
    }
    
    /**
	 * @author euler.ramos
	 * @param idCalendario
	 * @return
	 * @throws Exception
	 */
	@Override
	public Object verificaSePermiteExcluir(final DocumentHTML document, final HttpServletRequest request, final CalendarioDTO calendario) throws Exception {
		String resultado = "excluir";
		/*
		 * Tabelas que se relacionam com calendario: RECURSO SERVICOCONTRATO TIPOLIBERACAO TIPOMUDANCA
		 */
		final List<ServicoContratoDTO> listaservicoContrato = this.getServicoContratoDAO().findByIdCalendario(calendario.getIdCalendario());
		if (listaservicoContrato != null && listaservicoContrato.size() > 0) {
			resultado = UtilI18N.internacionaliza(request, "calendario.naoExDevidoServicoContrato");
		} else {
			final List<TipoLiberacaoDTO> listaTipoLiberacao = this.getTipoLiberacaoDAO().findByIdCalendario(calendario.getIdCalendario());
			if (listaTipoLiberacao != null && listaTipoLiberacao.size() > 0) {
				resultado = UtilI18N.internacionaliza(request, "calendario.naoExDevidoTipoLiberacao");
			} else {
				final List<TipoMudancaDTO> listaTipoMudanca = this.getTipoMudancaDAO().findByIdCalendario(calendario.getIdCalendario());
				if (listaTipoMudanca != null && listaTipoMudanca.size() > 0) {
					resultado = UtilI18N.internacionaliza(request, "calendario.naoExDevidoTipoMudanca");
				}
			}
		}
		return resultado;
	}

	public CalculoJornadaDTO calculaTempoDecorridoPelaJornadaDeTrabalho(final CalculoJornadaDTO calculoDto, final TransactionControler tc) throws Exception {
		
		this.setTransacao(tc);
		
		validaObjetoCalculoJornada(calculoDto);

		double prazoDecorrido = calcularPrazoDecorridoEmSegundosConsiderandoJornadaDeTrabalho(calculoDto);

		calculoDto.setTempoDecorridoHH(new Integer(Util.getHoraHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoMM(new Integer(Util.getMinutoHHMMSS(prazoDecorrido)));
        /**
         * TODO Implementar calculo de segundos
         * 		Embora o metodo retorne o prazo decorrido em segundos, os metodos internos que fazem esse calculo desconsideram os segundos
         * 		Calculo com exatidao somente das Horas e os Minutos HH:MM 
         */
        calculoDto.setTempoDecorridoSS(new Integer(Util.getSegundoHHMMSS(prazoDecorrido)));
        calculoDto.setTempoDecorridoTotalEmSegundos(prazoDecorrido);
		
		return calculoDto;
	}

	private double calcularPrazoDecorridoEmSegundosConsiderandoJornadaDeTrabalho(final CalculoJornadaDTO calculoDto) throws Exception {

		CalendarioDTO calendarioDto = this.recuperaCalendario(calculoDto.getIdCalendario());
		
		Timestamp dataHoraInicioJornada = this.retornaDataHoraInicioDaProximaJornadaDeTrabalho(calendarioDto, calculoDto.getDataHoraInicial(), HORA_INICIO_CALCULADA, true);
		
		int qtdDiasEntreInicioJornadaEDataFinal = this.calculaDiferencaDeDiasEntreAsDatas(calculoDto.getDataHoraFinal(), dataHoraInicioJornada);
		
		if(qtdDiasEntreInicioJornadaEDataFinal < 0){
			return 0d;
		}

		if(qtdDiasEntreInicioJornadaEDataFinal == 0){
			return Util.converteHoraParaSegundos(this.calculaCargaHorariaDoDia(calendarioDto, calculoDto));
		}
		
		double prazoDecorrido = 0.00;
		prazoDecorrido += this.calculaCargaHoraria(calendarioDto, dataHoraInicioJornada);
		while (qtdDiasEntreInicioJornadaEDataFinal > 0) {
			dataHoraInicioJornada = this.retornaDataHoraInicioDaProximaJornadaDeTrabalho(calendarioDto, incrementaDias(dataHoraInicioJornada, 1), HORA_INICIO_JORNADA, false);
			qtdDiasEntreInicioJornadaEDataFinal = this.calculaDiferencaDeDiasEntreAsDatas(calculoDto.getDataHoraFinal(), dataHoraInicioJornada);
			if (qtdDiasEntreInicioJornadaEDataFinal > 0) {
				prazoDecorrido += this.calculaCargaHorariaTotal(calendarioDto, dataHoraInicioJornada);
			} else if (qtdDiasEntreInicioJornadaEDataFinal == 0) {
				prazoDecorrido += this.calculaCargaHorariaDoDia(calendarioDto, dataHoraInicioJornada, calculoDto.getDataHoraFinal());
			} 
		}
		
		return Util.converteHoraParaSegundos(prazoDecorrido);
	}

	
	/**
	 * Valida se o objeto de calculo de jornada possui 
	 * @param calculoDto
	 * @throws Exception
	 */
	public void validaObjetoCalculoJornada(final CalculoJornadaDTO calculoDto) throws Exception, LogicException {
		if (calculoDto.getIdCalendario() == null) {
			throw new LogicException("calendario.IDcalendarioNaoInformado");
		}
		
		if (calculoDto.getDataHoraInicial() == null) {
			throw new LogicException("calendario.dataHoraInicialNaoInformadas");
		}
		
		if (calculoDto.getDataHoraFinal() == null) {
			throw new LogicException("calendario.dataHoraFinalNaoInformadas");
		}

		if (calculoDto.getDataHoraInicial().compareTo(calculoDto.getDataHoraFinal()) > 0) {
			throw new LogicException("calendario.dataHoraInicialMaiorDataHoraAtual");
		}
		CalendarioDTO calendarioDto = this.recuperaCalendario(calculoDto.getIdCalendario());
		
		if(calendarioDto == null || calendarioDto.getIdCalendario() == null){
			throw new LogicException("citcorpore.comum.calendarioNaoDefinido");
		}
	}
	
	
	/**
	 * Retorna a data hora final da jornada calculada
	 * 
	 * @param idCalendario
	 * @param dataHoraReferencia
	 * @param prazoHH
	 * @param prazoMM
	 * @param tc
	 * @return
	 */
	public Timestamp retornaDataHoraFinal(Integer idCalendario, Timestamp dataHoraReferencia, Integer prazoHH, Integer prazoMM, TransactionControler tc){
		try{
			CalculoJornadaDTO calculoDto = new CalculoJornadaDTO(idCalendario, dataHoraReferencia, prazoHH, prazoMM);
			calculoDto = this.calculaDataHoraFinal(calculoDto, true, tc);
			return calculoDto.getDataHoraFinal();
		}catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Verifica se a data informada por parmetro no mtodo, est na lista de feriados cadastrados nas excesses do calendrio vinculado ao contrato, se a data for encontrada,  retornado falso, pois essa se trata de um feriado e no dia til.
	 * OBS_1.: A lista de feriados contm apenas excessoes sem jornada de trabalho vinculado
	 * 
	 * Se a data informada no for feriado, ento  verificado qual o respectivo dia da semana, ento verifica se este dia da semana possui jornada de trabalho vinculado, se no possuir o retorno  falso, pois  um dia sem jornada de trabalho, caso
	 * contrrio,  retornado true, ou seja,  um dia com jornada de trabalho e consequentemente um dia til
	 * 
	 * @author gilmar.junior
	 * @since 2016.11.16
	 * @param Integer
	 *            idCalendario
	 * @param java.util.Date
	 *            data
	 * @exception Exception
	 * 
	 * @return false/true
	 */
	@Override
	public boolean isBusinessDay(Integer idCalendario, java.util.Date data) throws Exception {

		List listFeriadosAnoCorrente = this.getExcecaoCalendarioDAO().getListFeriadosAnoCorrente(idCalendario);
		if (listFeriadosAnoCorrente != null && !listFeriadosAnoCorrente.isEmpty() && listFeriadosAnoCorrente.contains(data)) {
			return false;
		}

		CalendarioDTO calendarioDTO = new CalendarioDTO();
		calendarioDTO.setIdCalendario(idCalendario);
		calendarioDTO = (CalendarioDTO) this.restore(calendarioDTO);

		if (calendarioDTO != null) {
			Integer diaSemana = UtilDatas.getDiaSemana(UtilDatas.dateToSTR(data));

			switch (diaSemana) {
			case 1:
				if (calendarioDTO.getIdJornadaDom() != null) {
					return true;
				} else {
					return false;
				}
			case 2:
				if (calendarioDTO.getIdJornadaSeg() != null) {
					return true;
				} else {
					return false;
				}
			case 3:
				if (calendarioDTO.getIdJornadaTer() != null) {
					return true;
				} else {
					return false;
				}
			case 4:
				if (calendarioDTO.getIdJornadaQua() != null) {
					return true;
				} else {
					return false;
				}
			case 5:
				if (calendarioDTO.getIdJornadaQui() != null) {
					return true;
				} else {
					return false;
				}
			case 6:
				if (calendarioDTO.getIdJornadaSex() != null) {
					return true;
				} else {
					return false;
				}
			case 7:
				if (calendarioDTO.getIdJornadaSab() != null) {
					return true;
				} else {
					return false;
				}
			}
		}
		return false;
	}
}