/**
 * CentralIT - CITSmart.
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Service de Caracterstica.
 * 
 * @author valdoilo.damasceno
 * 
 */
public interface CaracteristicaService extends CrudService {

	/**
	 * Cria Nova Caracterstica.
	 * 
	 * @param caracteristica
	 * @param request
	 * @throws ServiceException
	 * @throws LogicException
	 * @author valdoilo.damasceno
	 */
	public void create(CaracteristicaDTO caracteristica, HttpServletRequest request) throws ServiceException, LogicException;

	/**
	 * Consulta Caractersticas Ativas.
	 * 
	 * @param id
	 * @return Collection - Coleo de Caractersticas.
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 */
	public Collection<CaracteristicaDTO> consultarCaracteristicasAtivas(Integer idTipoItemConfiguracao) throws ServiceException;
	
	/**
	 * Exclui caracterstica.
	 * 
	 * @param caracteristica
	 *            - Bean de Caracterstica.
	 * @throws ServiceException
	 * @throws LogicException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public void excluirCaracteristica(CaracteristicaDTO caracteristica) throws ServiceException, LogicException, Exception;

	/**
	 * Consulta Caractersticas com seus respectivos valores.
	 * 
	 * @param idTipoItemConfiguracao
	 * @param idBaseItemConfiguracao
	 * @return Collection - Coleo de Caractersticas.
	 * @throws LogicException
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValores(Integer idTipoItemConfiguracao, Integer idBaseItemConfiguracao) throws LogicException,
			ServiceException, Exception;

	/**
	 * Consulta Caractersticas com seus respectivos valores.
	 * 
	 * @param idTipoItemConfiguracao
	 * @param idBaseItemConfiguracao
	 * @return Collection - Coleo de Caractersticas.
	 * @throws LogicException
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValoresItemConfiguracao(Integer idTipoItemConfiguracao, Integer idItemConfiguracao) throws LogicException,
			ServiceException, Exception;
	
	/**
	 * Consulta Caractersticas com seus respectivos valores.
	 * 
	 * @param idTipoItemConfiguracao
	 * @param idBaseItemConfiguracao
	 * @param arrCaracteristicas
	 * @return Collection - Coleo de Caractersticas.
	 * @throws LogicException
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValoresItemConfiguracao(Integer idTipoItemConfiguracao, Integer idItemConfiguracao, String [] arrCaracteristicas) throws LogicException,
	ServiceException, Exception;

	/**
	 * Consulta caracteristicas com seus respectivos valores com base no item de configurao.
	 * 
	 * @param idItemConfiguracao
	 * @return
	 * @throws LogicException
	 * @throws ServiceException
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValoresItemConfiguracao(final Integer idItemConfiguracao) throws LogicException, ServiceException, Exception;

	/**
	 * Verifica se Caracteristica informada existe.
	 * 
	 * @param grupo
	 * @return true - existe; false - no existe;
	 * @throws PersistenceException
	 * @author Thays.araujo
	 */
	public boolean verificarSeCaracteristicaExiste(CaracteristicaDTO caracteristica) throws PersistenceException;

	
	/**
	 * Consulta Caractersticas Ativas com array.
	 * 
	 * @param id
	 * @return Collection - Coleo de Caractersticas.
	 * @throws ServiceException
	 * @author flavio.santana
	 */
	public Collection<CaracteristicaDTO> consultarCaracteristicasAtivas(Integer idTipoItemConfiguracao, String[] arrCaracteristicas) throws ServiceException;

	/**
	 * Consulta caracteristica pela tag
	 * 
	 * @param Tag
	 * @return CaracteristicaDTO
	 * @throws ServiceException,
	 *             PersistenceException
	 * @author gustavo.gomes
	 */
	public CaracteristicaDTO buscaCaracteristicaPorTag(String tag) throws Exception;

}
