/**
 * CentralIT - CITCorpore.
 *
 * @author CentralIT
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.bean.ValorDTO;
import br.com.centralit.citcorpore.integracao.CaracteristicaDao;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;

/**
 * EJB de Caracterstica Service.
 *
 * @author valdoilo.damasceno
 */
@SuppressWarnings("unchecked")
public class CaracteristicaServiceEjb extends CrudServiceImpl implements CaracteristicaService {

	private CaracteristicaDao dao;

	private ValorService valorService;

	private CaracteristicaTipoItemConfiguracaoService caracteristicaTipoItemConfiguracaoService;

	@Override
	protected CaracteristicaDao getDao() {
		if (dao == null) {
			dao = new CaracteristicaDao();
		}
		return dao;
	}

	@Override
	public void create(final CaracteristicaDTO caracteristica, final HttpServletRequest request) throws ServiceException, LogicException {
		/*
		 * Retirado da rotina para validao da pink elephant caracteristica.setSistema("N"); Acrescentado novamente por apresentar erro ao gravar caracterstica. No Oracle, campo no pode ser Null.
		 */
		caracteristica.setSistema("N");
		caracteristica.setNome(caracteristica.getNome().trim().replaceAll("[<>]", ""));
		caracteristica.setTag(caracteristica.getTag().trim().replaceAll("[<>]", ""));
		caracteristica.setDescricao(caracteristica.getDescricao() != null ? caracteristica.getDescricao().trim() : null);
		caracteristica.setDataInicio(UtilDatas.getDataAtual());
		caracteristica.setTipo("");
		caracteristica.setIdEmpresa(WebUtil.getIdEmpresa(request));
		super.create(caracteristica);
	}

	/*
	 * Desenvolvedor: Fabio Amorim - Data: 29/05/2015 - Horrio: 15:56 - ID Citsmart: 155312 - Motivo/Comentrio: Remover espao no incio e fim dos campos texto.
	 */
	@Override
	public void update(IDto model) throws ServiceException, LogicException {
		CaracteristicaDTO caracteristicaDTO = (CaracteristicaDTO) model;
		caracteristicaDTO.setNome(caracteristicaDTO.getNome().trim());
		caracteristicaDTO.setDescricao(caracteristicaDTO.getDescricao().trim());
		caracteristicaDTO.setDescricao(caracteristicaDTO.getDescricao() != null ? caracteristicaDTO.getDescricao().trim() : null);
		super.update(caracteristicaDTO);
	}

    @Override
	public void excluirCaracteristica(final CaracteristicaDTO caracteristica) throws ServiceException, Exception {
		if (this.getCaracteristicaTipoItemConfiguracaoService().existeAssociacaoComCaracteristica(caracteristica.getIdCaracteristica(), null)) {
			throw new LogicException("Caracterstica no pode ser excluda!");
		} else {
			caracteristica.setDataFim(UtilDatas.getDataAtual());
			super.update(caracteristica);
		}
	}

	@Override
	public Collection<CaracteristicaDTO> consultarCaracteristicasAtivas(final Integer idTipoItemConfiguracao) throws ServiceException {
		try {
			return this.getDao().consultarCaracteristicasAtivas(idTipoItemConfiguracao);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<CaracteristicaDTO> consultarCaracteristicasAtivas(final Integer idTipoItemConfiguracao, final String[] arrCaracteristicas) throws ServiceException {
		try {
			return this.getDao().consultarCaracteristicasAtivas(idTipoItemConfiguracao, arrCaracteristicas);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValores(final Integer idTipoItemConfiguracao, final Integer idBaseItemConfiguracao) throws LogicException, ServiceException,
			Exception {
		final Collection<CaracteristicaDTO> caracteristicas = this.consultarCaracteristicasAtivas(idTipoItemConfiguracao);

		for (final CaracteristicaDTO caracteristica : caracteristicas) {
			final ValorDTO valor = this.getValorService().restore(idBaseItemConfiguracao, caracteristica.getIdCaracteristica());

			if (valor != null && valor.getValorStr() != null) {
				caracteristica.setValorString(valor.getValorStr());
			}
		}
		return caracteristicas;
	}

	@Override
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValoresItemConfiguracao(final Integer idTipoItemConfiguracao, final Integer idItemConfiguracao) throws LogicException,
			ServiceException, Exception {

		final Collection<CaracteristicaDTO> caracteristicas = this.consultarCaracteristicasAtivas(idTipoItemConfiguracao);
		if (caracteristicas != null) {
			for (final CaracteristicaDTO caracteristica : caracteristicas) {
				final ValorDTO valor = this.getValorService().restoreItemConfiguracao(idItemConfiguracao, caracteristica.getIdCaracteristica());

				if (valor != null && valor.getValorStr() != null) {
					caracteristica.setValorString(valor.getValorStr());
				}
			}
		}
		return caracteristicas;
	}

	@Override
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValoresItemConfiguracao(final Integer idTipoItemConfiguracao, final Integer idItemConfiguracao, final String[] arr)
			throws LogicException, ServiceException, Exception {
		final Collection<CaracteristicaDTO> caracteristicas = this.consultarCaracteristicasAtivas(idTipoItemConfiguracao, arr);
		if (caracteristicas != null) {
			for (final CaracteristicaDTO caracteristica : caracteristicas) {
				final ValorDTO valor = this.getValorService().restoreItemConfiguracao(idItemConfiguracao, caracteristica.getIdCaracteristica());

				if (valor != null && valor.getValorStr() != null) {
					caracteristica.setValorString(valor.getValorStr());
				}
			}
		}
		return caracteristicas;
	}

	@Override
	public Collection<CaracteristicaDTO> consultarCaracteristicasComValoresItemConfiguracao(final Integer idItemConfiguracao) throws LogicException, ServiceException, Exception {
		return this.getDao().consultarCaracteristicasComValoresItemConfiguracao(idItemConfiguracao);
	}

	/**
	 * Retorna Service de Valor.
	 *
	 * @return ValorService
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public ValorService getValorService() throws ServiceException, Exception {
		if (valorService == null) {
			valorService = (ValorService) ServiceLocator.getInstance().getService(ValorService.class, null);
		}
		return valorService;
	}

	/**
	 * Retorna instncia de CaracteristicaTipoItemConfiguracaoService;
	 * 
	 * @return CaracteristicaTipoItemConfiguracaoService
	 * @author valdoilo.damasceno
	 */
	public CaracteristicaTipoItemConfiguracaoService getCaracteristicaTipoItemConfiguracaoService() throws ServiceException {
		if (caracteristicaTipoItemConfiguracaoService == null) {
			caracteristicaTipoItemConfiguracaoService = (CaracteristicaTipoItemConfiguracaoService) ServiceLocator.getInstance().getService(CaracteristicaTipoItemConfiguracaoService.class, null);
		}
		return caracteristicaTipoItemConfiguracaoService;
	}

	@Override
	public boolean verificarSeCaracteristicaExiste(final CaracteristicaDTO caracteristica) throws PersistenceException {
		return this.getDao().verificarSeCaracteristicaExiste(caracteristica);
	}

	@Override
	public CaracteristicaDTO buscaCaracteristicaPorTag(String tag) throws Exception {
		return this.getDao().buscaCaracteristicaPorTa(tag);
	}

}
