/**
 * CentralIT - CITSmart.
 */
package br.com.centralit.citcorpore.negocio;

import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Service de CaracteristicaTipoItemConfiguracao.
 * 
 * @author valdoilo.damasceno
 */
public interface CaracteristicaTipoItemConfiguracaoService extends CrudService {

	/**
	 * Exclui associao da Caracterstica com o Tipo de Item Configurao.
	 * 
	 * @author valdoilo.damasceno
	 */
	public void excluirAssociacaoCaracteristicaTipoItemConfiguracao(Integer idTipoItemConfiguracao, Integer idCaracteristica) throws PersistenceException, ServiceException, Exception;

	/**
	 * Verifica se Caracterstica est associada a algum Tipo Item Configurao.
	 * 
	 * @author valdoilo.damasceno
	 */
	public boolean existeAssociacaoComCaracteristica(Integer idCaracteristica, Integer idTipoItemConfiguracao) throws PersistenceException;

}
