/**
 * CentralIT - CITSmart.
 *
 * @author valdoilo.damasceno
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.integracao.CaracteristicaTipoItemConfiguracaoDAO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;

/**
 * EJB de CaracteristicaTipoItemConfiguracao.
 *
 * @author valdoilo.damasceno
 */
@SuppressWarnings("unchecked")
public class CaracteristicaTipoItemConfiguracaoServiceEjb extends CrudServiceImpl implements CaracteristicaTipoItemConfiguracaoService {

	private CaracteristicaTipoItemConfiguracaoDAO caracteristicaTipoItemConfiguracaoDao;

	private CaracteristicaService caracteristicaService;

	@Override
	protected CaracteristicaTipoItemConfiguracaoDAO getDao() {
		if (caracteristicaTipoItemConfiguracaoDao == null) {
			caracteristicaTipoItemConfiguracaoDao = new CaracteristicaTipoItemConfiguracaoDAO();
		}

		return caracteristicaTipoItemConfiguracaoDao;
	}

	@Override
	public void excluirAssociacaoCaracteristicaTipoItemConfiguracao(final Integer idTipoItemConfiguracao, final Integer idCaracteristica) throws Exception {
		if (idCaracteristica != null && idCaracteristica.intValue() != 0) {
			this.getDao().excluirAssociacaoCaracteristicaTipoItemConfiguracao(idTipoItemConfiguracao, idCaracteristica);
		} else {
			final Collection<CaracteristicaDTO> caracteristicas = this.getCaracteristicaService().consultarCaracteristicasAtivas(idTipoItemConfiguracao);

			if (caracteristicas != null && !caracteristicas.isEmpty()) {
				for (final CaracteristicaDTO caracteristica : caracteristicas) {
					this.getDao().excluirAssociacaoCaracteristicaTipoItemConfiguracao(idTipoItemConfiguracao, caracteristica.getIdCaracteristica());
				}
			}
		}
	}

	/**
	 * Retorna instncia de CaracteristicaService.
	 *
	 * @author valdoilo.damasceno
	 * @since 25.02.2015
	 */
	public CaracteristicaService getCaracteristicaService() throws ServiceException, Exception {
		if (caracteristicaService == null) {
			caracteristicaService = (CaracteristicaService) ServiceLocator.getInstance().getService(CaracteristicaService.class, null);
		}
		return caracteristicaService;
	}

	@Override
	public boolean existeAssociacaoComCaracteristica(Integer idCaracteristica, Integer idTipoItemConfiguracao) throws PersistenceException {
		return this.getDao().existeAssociacaoComCaracteristica(idCaracteristica, idTipoItemConfiguracao);
	}

}
