package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.CasoNegocioDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.integracao.CasoNegocioDao;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;

/**
 * @author ibimon.morais
 * @02/11/2015
 */
@SuppressWarnings("unchecked")
public class CasoNegocioServiceEjb extends CrudServiceImpl implements CasoNegocioService {

	protected final String LETRA_S = "S";
	private CasoNegocioDao dao;
	protected ControleGEDDao controleGEDDao = new ControleGEDDao();
	private ControleGEDService controleGedService;

	@Override
	protected CasoNegocioDao getDao() {
		if (this.dao == null) {
			this.dao = new CasoNegocioDao();
		}
		return this.dao;
	}

	public ControleGEDService getControleGedService() {
		if (this.controleGedService == null) {
			try {
				this.controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
			} catch (final ServiceException servExc) {
				servExc.printStackTrace();
			} catch (final Exception exc) {
				exc.printStackTrace();
			}
		}
		return this.controleGedService;
	}

	public ControleGEDDao getControleGEDDao() {
		if (this.controleGEDDao == null) {
			this.controleGEDDao = new ControleGEDDao();
		}
		return this.controleGEDDao;
	}

	/**
	 * @author ibimon.morais
	 * @since 08/10/2015
	 */
	@Override
	public Collection<CasoNegocioDTO> findByIdServico(final Integer parm) throws PersistenceException {
		return this.getDao().findByIdServico(parm);
	}

	/**
	 * @author ibimon.morais
	 * @since 08/10/2015
	 */
	@Override
	public CasoNegocioDTO salvar(final CasoNegocioDTO iDto) throws PersistenceException {
		CasoNegocioDTO dtoRetorno = new CasoNegocioDTO();

		final TransactionControler transacao = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			transacao.start();
			this.validaCreate(iDto);
			dtoRetorno = this.executarAcaoSalvar(iDto, transacao);
			transacao.commit();
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(transacao, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			transacao.close();
		}
		return dtoRetorno;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#executarAcaoSalvar)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private CasoNegocioDTO executarAcaoSalvar(CasoNegocioDTO iDto, final TransactionControler transacao) throws PersistenceException,
			Exception {
		iDto.setDataFim(null);
		if (iDto.getIdCasoNegocio() != null && iDto.getIdCasoNegocio().intValue() > 0) {
			if (this.isServicoExiste(iDto.getIdServico())) {
				this.getDao().update(iDto);
			}
		} else {
			iDto = (CasoNegocioDTO) this.getDao().create(iDto);
		}
		//Tratar inclusao upload
		if (iDto != null && iDto.getColsUploadGED() != null && !iDto.getColsUploadGED().isEmpty()) {
			final String gedDiretorio = this.getDiretorioInterno();
			final String gedInterno = this.getCasoNegocioGedInterno();
			final String gedInternoBancoDados = this.getGedInternoBD();
			
			this.gravarInformacaoGED(iDto, transacao, gedDiretorio, gedInterno, gedInternoBancoDados);
		}
		return iDto;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#removerAnexosDiretorioGed)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	@Override
	public void removerAnexosDiretorioGed(final CasoNegocioDTO iDto) throws PersistenceException {
		final TransactionControler transacao = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			transacao.start();
			final String gedDiretorio = this.getDiretorioInterno();
			final String gedInterno = this.getCasoNegocioGedInterno();
			final String gedInternoBancoDados = this.getGedInternoBD();
			this.deletarArquivos(iDto, transacao, gedDiretorio, gedInterno, gedInternoBancoDados);
			transacao.commit();
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(transacao, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			transacao.close();
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#deletarArquivos)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	private void deletarArquivos(final CasoNegocioDTO iDto, final TransactionControler transacao, final String gedDiretorio,
			final String gedInterno, final String gedInternoBancoDados) throws Exception {
		if (iDto.getColsUploadGEDExcluidos() != null && !iDto.getColsUploadGEDExcluidos().isEmpty()) {
			this.getControleGEDDao().setTransactionControler(transacao);
			for (final String valorId : iDto.getColsUploadGEDExcluidos()) {
				if (valorId.startsWith("ID=")) {
					ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
					controleGEDDTO.setIdControleGED(this.obterIdParaExclusaoGed(valorId));
					controleGEDDTO = (ControleGEDDTO) this.getControleGEDDao().restore(controleGEDDTO);
					this.controleGEDDao.delete(controleGEDDTO);
					final File arquivo = montarArquivoParaDelecaoNoDiretorio(iDto, gedDiretorio, controleGEDDTO);
					this.deleteDir(arquivo);
				} else {
					final File arquTemp = new File(valorId);
					this.deleteDir(arquTemp);
				}
			}
		}
	}
	
	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#montarArquivoParaDelecaoNoDiretorio)
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private File montarArquivoParaDelecaoNoDiretorio(final CasoNegocioDTO iDto, final String gedDiretorio, ControleGEDDTO controleGEDDTO) {
		final File arquivo = new File(gedDiretorio.concat("/").concat(String.valueOf(iDto.getIdEmpresa())).concat("/")
				.concat(controleGEDDTO.getPasta()).concat("/").concat(String.valueOf(controleGEDDTO.getIdControleGED()))
				.concat(".").concat("ged"));
		return arquivo;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#deleteDir)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	public boolean deleteDir(final File dir) {
		if (dir.isDirectory()) {
			final String[] children = dir.list();
			for (final String element : children) {
				final boolean success = this.deleteDir(new File(dir, element));
				if (!success) {
					return false;
				}
			}
		}
		return dir.delete();
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#obterIdParaExclusaoGed)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	private Integer obterIdParaExclusaoGed(final String strParaVerificar) {
		final String[] strParaVerificarArray = strParaVerificar.split("=");
		return Integer.valueOf(strParaVerificarArray[1].toString());
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#gravarInformacaoGED)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private void gravarInformacaoGED(final CasoNegocioDTO iDto, final TransactionControler tc, final String gedDiretorio,
			final String gedInterno, final String gedInternoBancoDados) throws Exception {
		this.controleGEDDao.setTransactionControler(tc);
		final String pasta = this.definirDiretorioGed(iDto, this.controleGEDDao, gedInterno, gedDiretorio);
		this.tratarListaDeArquivoGED(iDto, this.controleGEDDao, gedDiretorio, gedInterno, gedInternoBancoDados, pasta);
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#definirDiretorioGed)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private String definirDiretorioGed(final CasoNegocioDTO iDto, final ControleGEDDao controleGEDDao,
			final String casoNegocioGEDDiretorio, final String gedDiretorio) throws Exception {
		String pasta = "";
		if (casoNegocioGEDDiretorio.equalsIgnoreCase(this.LETRA_S)) {
			pasta = controleGEDDao.getProximaPastaArmazenar();

			File fileDir = new File(gedDiretorio);
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(gedDiretorio.concat("/").concat(String.valueOf(iDto.getIdEmpresa())));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(gedDiretorio.concat("/").concat(String.valueOf(iDto.getIdEmpresa())).concat("/").concat(pasta));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
		}
		return pasta;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#tratarListaDeArquivoGED)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */

	private void tratarListaDeArquivoGED(final CasoNegocioDTO iDto, final ControleGEDDao controleGEDDao, final String gedDiretorio,
			final String gedInterno, final String gedInternoBancoDados, final String pasta) throws PersistenceException {
		this.percorrerColunasUploadGED(iDto, controleGEDDao, gedDiretorio, gedInterno, gedInternoBancoDados, pasta);
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#percorrerColunasUploadGED)
	 *
	 * @since 21/10/2015
	 * @author ibimon.morais
	 */
	private void percorrerColunasUploadGED(final CasoNegocioDTO iDto, final ControleGEDDao controleGEDDao, final String gedDiretorio,
			final String gedInterno, final String gedInternoBancoDados, final String pasta) throws PersistenceException {
		for (final UploadDTO upDto : iDto.getColsUploadGED()) {
			if (upDto.getTemporario().equals(this.LETRA_S)) {
				ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
				this.setarControleGEDDTO(iDto, pasta, upDto, controleGEDDTO);
				this.definirCasoNegocioPathInterno(gedDiretorio, gedInternoBancoDados, upDto, controleGEDDTO);
				controleGEDDTO = this.salvarControleGED(controleGEDDao, upDto, controleGEDDTO);
				this.criarDiretorioInternoGED(iDto, gedDiretorio, gedInternoBancoDados, pasta, upDto, controleGEDDTO, gedInterno);
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#criarDiretorioInternoGED)
	 *
	 * @since 21/10/2015
	 * @author ibimon.morais
	 */
	private void criarDiretorioInternoGED(final CasoNegocioDTO iDto, final String gedDiretorio, final String gedInternoBancoDados,
			final String pasta, final UploadDTO upDto, final ControleGEDDTO controleGEDDTO, final String gedInterno) {
		// Se utiliza GED interno e nao eh BD
		if (gedInterno.equalsIgnoreCase("S") && !this.LETRA_S.equalsIgnoreCase(gedInternoBancoDados)) {
			if (controleGEDDTO != null) {
				try {
					final File arquivo = new File(gedDiretorio.concat("/").concat(String.valueOf(iDto.getIdEmpresa())).concat("/")
							.concat(pasta).concat("/").concat(String.valueOf(controleGEDDTO.getIdControleGED())).concat(".")
							.concat(Util.getFileExtension(upDto.getNameFile())));

					CriptoUtils.encryptFile(upDto.getPath(),
							gedDiretorio.concat("/").concat(String.valueOf(iDto.getIdEmpresa())).concat("/").concat(pasta).concat("/")
									.concat(String.valueOf(controleGEDDTO.getIdControleGED())).concat(".ged"), ((String) System
									.getProperties().get("user.dir")).concat(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));
					arquivo.delete();
				} catch (ClassNotFoundException | IOException | GeneralSecurityException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#setarControleGEDD)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private ControleGEDDTO salvarControleGED(final ControleGEDDao controleGEDDao, final UploadDTO upDto, ControleGEDDTO controleGEDDTO)
			throws PersistenceException {
		controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);
		upDto.setIdControleGED(controleGEDDTO.getIdControleGED());
		return controleGEDDTO;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#definirCasoNegocioPathInterno)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private void definirCasoNegocioPathInterno(final String gedDiretorio, final String gedInternoBancoDados, final UploadDTO uploadDTO,
			final ControleGEDDTO controleGEDDTO) {
		// Se utiliza GEDinterno
		controleGEDDTO.setPathArquivo(null);
		if (gedDiretorio != null && gedDiretorio.trim().equalsIgnoreCase(this.LETRA_S)
				&& this.LETRA_S.equalsIgnoreCase(gedInternoBancoDados.trim())) {
			controleGEDDTO.setPathArquivo(uploadDTO.getPath());
		} 
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#definirControleGEDDTO)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private void setarControleGEDDTO(final CasoNegocioDTO iDto, final String pasta, final UploadDTO uploadDTO,
			final ControleGEDDTO controleGEDDTO) {
		controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_BUSINESS_CASE);
		controleGEDDTO.setId(iDto.getIdCasoNegocio());
		controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
		controleGEDDTO.setDescricaoArquivo(uploadDTO.getDescricao());
		controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDTO.getNameFile()));
		controleGEDDTO.setPasta(pasta);
		controleGEDDTO.setNomeArquivo(uploadDTO.getNameFile());
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#getGedInternoBD)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private String getGedInternoBD() {
		String prontuarioGedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD,
				"N");
		if (!UtilStrings.isNotVazio(prontuarioGedInternoBancoDados)) {
			prontuarioGedInternoBancoDados = "N";
		}
		return prontuarioGedInternoBancoDados;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#getCasoNegocioGedInterno)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private String getCasoNegocioGedInterno() {
		String casoNegocioGEDInterno = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, this.LETRA_S);
		if (casoNegocioGEDInterno == null) {
			casoNegocioGEDInterno = this.LETRA_S;
		}
		return casoNegocioGEDInterno;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#getDiretorioInterno)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private String getDiretorioInterno() throws Exception {
		final String casoNegocioGEDDiretorio = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "");
		if ("".equals(casoNegocioGEDDiretorio.trim())) {
			throw new Exception("Diretrio No Informado.");
		}
		return casoNegocioGEDDiretorio;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.CasoNegocioServiceEjb.java_(#isServicoExiste)
	 *
	 * @since 19/10/2015
	 * @author ibimon.morais
	 */
	private boolean isServicoExiste(final Integer idServico) throws PersistenceException {
		final Collection<CasoNegocioDTO> casos = this.findByIdServico(idServico);
		return (casos != null && !casos.isEmpty()) ? Boolean.TRUE : Boolean.FALSE;
	}

}