package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.CatalogoServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

/**
 * 
 * @author pedro
 *
 */
@SuppressWarnings("unchecked")
public interface CatalogoServicoService extends CrudService {
	
	public Collection<CatalogoServicoDTO> listAllCatalogos() throws ServiceException, Exception;
	
	public void update(IDto model) throws ServiceException, LogicException;
	
	public IDto create(IDto model) throws ServiceException, LogicException;
	 
	public boolean verificaSeCatalogoExiste(CatalogoServicoDTO catalogoServicoDTO) throws PersistenceException, ServiceException;
	 
	public Collection<CatalogoServicoDTO> listByIdContrato(Integer idContrato) throws ServiceException, Exception;
	
	public Page<CatalogoServicoDTO> listByIdPortfolioAndSituacaoAndFiltro(Integer idPortfolio, Integer idSituacao, String filtroServico, final Pageable pageable, final Boolean isTotalizacao) throws PersistenceException;
}
