package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.CategoriaAmeacaDTO;
import br.com.centralit.citcorpore.integracao.CategoriaAmeacaDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

public class CategoriaAmeacaServiceEjb extends CrudServiceImpl implements CategoriaAmeacaService {

	private CategoriaAmeacaDao cadastroCategoriaAmeacaDao;

	@Override
	protected CategoriaAmeacaDao getDao() {
		if (cadastroCategoriaAmeacaDao == null) {
			cadastroCategoriaAmeacaDao = new CategoriaAmeacaDao();
		}
		return cadastroCategoriaAmeacaDao;
	}

	/**
	 * Retorna true quando houver alguma tupla com mesmo nome
	 * 
	 * @author joao.morais
	 */
	@Override
	public boolean verificaDuplicata(String nome) throws PersistenceException {
		Collection<CategoriaAmeacaDTO> lista = this.getDao().getListAmeacasByNome(nome);
		if (lista != null && lista.size() > 0) {
			return true;
		} else
			return false;
	}
}
