package br.com.centralit.citcorpore.negocio;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.CategoriaOcorrenciaDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Classe da camada de negcio da aplicao para provimento de servios.
 * Por meio de sua herana de CrudService operaes CRUD so providas.
 * Nessa classe podem ser definidos servios complementares.
 * 
 * @author thiago.monteiro
 *
 */
public interface CategoriaOcorrenciaService extends CrudService {
	/**
	 * Exclui a categoria caso no exista uma ocorrncia associada.
	 * 
	 * @param model
	 * @param document
	 * @throws ServiceException
	 * @throws Exception
	 */	
	public void deletarCategoriaOcorrencia(IDto model, DocumentHTML document) throws ServiceException, Exception;	
	
	/**
	 * Consulta por categorias de ocorrncia que estejam ativas (dataFim no nula).
	 * 
	 * @param model
	 * @param document
	 * @return
	 * @throws Exception 
	 */
	public boolean consultarCategoriaOcorrenciaAtiva(CategoriaOcorrenciaDTO categoriaOcorrencia) throws Exception;	
	
	
	public CategoriaOcorrenciaDTO restoreAll(Integer idCategoriaOcorrencia) throws Exception;
	
}
