/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.util.Arvore;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface CategoriaServicoService extends CrudService {

	/**
	 * Retorna Lista de Categorias Ativas.
	 *
	 * @throws Exception
	 * @return <code>Collection</code>
	 */
	public Collection listCategoriasAtivas() throws Exception;

	/**
	 * Verifica se Categoria Servio possui subcategoria ou servio associado.
	 *
	 * @param categoriaServico
	 * @return - <b>True:</b> Possui. - <b>False: </b>No possui.
	 * @throws PersistenceException
	 * @throws ServiceException
	 */
	public boolean verificarSeCategoriaPossuiServicoOuSubCategoria(CategoriaServicoDTO categoriaServicoDto) throws PersistenceException, br.com.citframework.excecao.ServiceException;

	/**
	 * Verifica se categoria informada j existe.
	 *
	 * @param categoriaServicoDTO
	 * @throws PersistenceException
	 * @throws ServiceException
	 * @return true - existe; false - no existe;
	 */
	public boolean verificarSeCategoriaExiste(CategoriaServicoDTO categoriaServicoDTO) throws PersistenceException, ServiceException;
	public Collection listHierarquia() throws Exception;

	 public List<CategoriaServicoDTO> listCategoriaHierarquia (CategoriaServicoDTO categoriaServicoDTO,  List<CategoriaServicoDTO> listCategoriaHierarquia ) throws Exception;

	public String verificaIdCategoriaServico(HashMap mapFields) throws Exception;

	public List<CategoriaServicoDTO> findCategoriaRelacionadaAoServicoContrato(Integer idContrato, Integer idServicoNegocioTecnico) throws Exception;

	public List<CategoriaServicoDTO> findByNomeCategoria(String titulo) throws PersistenceException;

	public Collection<CategoriaServicoDTO> listByTipoCategoria(String tipoCategoria) throws Exception;

	/**
	 * 
	 * Consulta autocomplete da lista de categoria de servico na tela de solicitacao de servico
	 * 
	 * @param tipoCategoria
	 * @return
	 * @throws Exception
	 */
	public Collection<CategoriaServicoDTO> findAutoCompleteCategoriaServico(Integer idContrato, Integer idServicoNegocio, String queryConsulta) throws Exception;

	public Arvore obtemArvoreCategoriaServico (Integer idContrato, Integer idServico, String queryConsulta) throws ServiceException, Exception;

	/**
	 * Consulta 
	 * 
	 * @param idContrato
	 * @param idServico
	 * @param queryConsulta
	 * @return
	 * @throws Exception
	 */
	Collection findByNomeEcontrato(Integer idContrato, Integer idServico, String queryConsulta) throws Exception;

	public Integer getIdCategoriaSeExiste(CategoriaServicoDTO categoriaServicoDTO) throws Exception;
}