/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.integracao.CategoriaServicoDao;
import br.com.centralit.citcorpore.util.Arvore;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({"rawtypes", "unchecked"})
public class CategoriaServicoServiceEjb extends CrudServiceImpl implements CategoriaServicoService {

	private CategoriaServicoDao dao;

	@Override
	protected CategoriaServicoDao getDao() {
		if (dao == null) {
			dao = new CategoriaServicoDao();
		}
		return dao;
	}

	@Override
	public Collection listCategoriasAtivas() throws Exception {
		return this.getDao().listCategoriasAtivas();
	}

    public Collection list(final List ordenacao) throws LogicException, ServiceException {
        return null;
    }

    public Collection list(final String ordenacao) throws LogicException, ServiceException {
        return null;
    }

	@Override
    public boolean verificarSeCategoriaPossuiServicoOuSubCategoria(final CategoriaServicoDTO categoriaServico) throws PersistenceException, ServiceException {
		if (this.getDao().verificarSeCategoriaPossuiFilho(categoriaServico) || this.getDao().verificarSeCategoriaPossuiServico(categoriaServico)) {
			return true;
		} else {
			return false;
	}
    }

	@Override
	public boolean verificarSeCategoriaExiste(final CategoriaServicoDTO categoriaServicoDTO) throws PersistenceException, ServiceException {
		return this.getDao().verificarSeCategoriaExiste(categoriaServicoDTO);
	}

	@Override
    public Collection listHierarquia() throws Exception {
        final Collection colFinal = new ArrayList();
        try {
            final Collection col = this.getDao().findSemPai();
            if (col != null) {
                for (final Iterator it = col.iterator(); it.hasNext();) {
                    final CategoriaServicoDTO dto = (CategoriaServicoDTO) it.next();
                    dto.setNivel(0);
                    colFinal.add(dto);
                    final Collection colAux = this.getCollectionHierarquia(dto.getIdCategoriaServico(), 0);
                    if (colAux != null && colAux.size() > 0) {
                        colFinal.addAll(colAux);
                    }
                }
            }
            return colFinal;
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }
    
    public Collection getCollectionHierarquia(final Integer idUnidade, final Integer nivel) throws Exception {
        final Collection col = this.getDao().findByIdPai(idUnidade);
        final Collection colFinal = new ArrayList();
        if (col != null) {
            for (final Iterator it = col.iterator(); it.hasNext();) {
                final CategoriaServicoDTO dto = (CategoriaServicoDTO) it.next();
                dto.setNivel(nivel + 1);
                colFinal.add(dto);
                final Collection colAux = this.getCollectionHierarquia(dto.getIdCategoriaServico(), dto.getNivel());
                if (colAux != null && colAux.size() > 0) {
                    colFinal.addAll(colAux);
                }
            }
        }
        return colFinal;
    }

    @Override
    public List<CategoriaServicoDTO> listCategoriaHierarquia(final CategoriaServicoDTO categoriaServicoDTO, final List<CategoriaServicoDTO> listCategoriaHierarquia)
            throws Exception {
        CategoriaServicoDTO bean = new CategoriaServicoDTO();
        listCategoriaHierarquia.add(categoriaServicoDTO);
        if (categoriaServicoDTO.getIdCategoriaServicoPai() != null) {
            bean.setIdCategoriaServico(categoriaServicoDTO.getIdCategoriaServicoPai());
            bean = (CategoriaServicoDTO) this.getDao().restore(bean);

            if (bean.getIdCategoriaServicoPai() != null) {
                this.listCategoriaHierarquia(bean, listCategoriaHierarquia);
            } else {
                listCategoriaHierarquia.add(bean);
            }
        }
        return listCategoriaHierarquia;
    }

    @Override
	public String verificaIdCategoriaServico(final HashMap mapFields) throws Exception {
		List<CategoriaServicoDTO> listaCategoriaServico = null;

		final String id = mapFields.get("IDCATEGORIASERVICO").toString().trim();
		if (id == null || id.equals("")) {
			return "0";
		}
		if (UtilStrings.soContemNumeros(id)) {
			final Integer idCategoriaServico = Integer.parseInt(id);
			listaCategoriaServico = this.getDao().findByIdCategoriaServico(idCategoriaServico);
		} else {
			listaCategoriaServico = this.getDao().findByNomeCategoria(id);
		}
		if (listaCategoriaServico != null && listaCategoriaServico.size() > 0) {
			return String.valueOf(listaCategoriaServico.get(0).getIdCategoriaServico());
		} else {
			return "0";
		}
	}

	@Override
	public List<CategoriaServicoDTO> findByNomeCategoria(String titulo) throws PersistenceException {
		return this.getDao().findByNomeCategoria(titulo);
	}

	@Override
	public List<CategoriaServicoDTO> findCategoriaRelacionadaAoServicoContrato(Integer idContrato, Integer idServicoNegocioTecnico) throws Exception {
		return this.getDao().findCategoriaRelacionadaAoServicoContrato(idContrato, idServicoNegocioTecnico);
	}

	@Override
	public Collection<CategoriaServicoDTO> listByTipoCategoria(String tipoCategoria) throws Exception {
		return this.getDao().listByTipoCategoria(tipoCategoria);
	}

	@Override
	public Collection<CategoriaServicoDTO> findAutoCompleteCategoriaServico(Integer idContrato, Integer idServicoNegocio, String queryConsulta) throws Exception {
		return this.getDao().findAutoCompleteCategoriaServico(idContrato, idServicoNegocio, queryConsulta);
	}

	//TODO[deborah.ferreira][26.07.2016] Verificar se pode ser removido. Usado somente em AutoCompleteCategoriaServico.java Linha 72, mas est comentado.
	@Override
    public Arvore obtemArvoreCategoriaServico(Integer idContrato, Integer idServico, String queryConsulta) throws ServiceException, Exception {
    	
        Collection<CategoriaServicoDTO> listaResultado;
        Arvore arvore = new Arvore();

        final CategoriaServicoService categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);

        listaResultado = categoriaServicoService.findByNomeEcontrato(idContrato, idServico, queryConsulta);
        
		// Alimentando a rvore apartir da pesquisa
        if (listaResultado != null) {
            for (final CategoriaServicoDTO categoriaServicoDTO : listaResultado) {
            	arvore.adicionaNo(categoriaServicoDTO.getIdCategoriaServico(), categoriaServicoDTO.getNomeCategoriaServico(), categoriaServicoDTO.getIdCategoriaServicoPai());
	}
        }
        arvore.geraListaSemRestricao();
        return arvore;
    }

  //TODO[deborah.ferreira][26.07.2016] Verificar se pode ser removido. Usado no mtodo acima obtemArvoreCategoriaServico.
    @Override
    public Collection findByNomeEcontrato(Integer idContrato, Integer idServico, String queryConsulta) throws Exception {
        try {
            Collection<CategoriaServicoDTO> arvore = this.getDao().findAutoCompleteCategoriaServico(idContrato, idServico, queryConsulta);
            Collection<CategoriaServicoDTO> arvoreCopia = this.getDao().findAutoCompleteCategoriaServico(idContrato, idServico, queryConsulta);
            /*
			 * Cria uma estrutura de dados auxiliar para gerencia de criao da arvore de hierarquias
			 */
            List<CategoriaServicoDTO> arvore_aux = new ArrayList<CategoriaServicoDTO>();
            
            for(CategoriaServicoDTO catServ : arvoreCopia){
            	arvore_aux = (ArrayList<CategoriaServicoDTO>) this.getDao().findByIdPai(catServ.getIdCategoriaServicoPai());
				for(CategoriaServicoDTO aux : arvore_aux){
					if (arvore.contains(aux)) {
						continue;
					}else{
						arvore.add(aux);
					}
				}
            }

            return arvore;
        } catch (final Exception e) {
        	e.printStackTrace();
            throw new ServiceException(e);
        }
    }

	@Override
	public Integer getIdCategoriaSeExiste(final CategoriaServicoDTO categoriaServicoDTO) throws Exception {
		return this.getDao().getIdCategoriaSeExiste(categoriaServicoDTO);
	}
}