package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import br.com.centralit.citcorpore.bean.CategoriaSolucaoDTO;
import br.com.centralit.citcorpore.integracao.CategoriaSolucaoDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

public class CategoriaSolucaoServiceEjb extends CrudServiceImpl implements CategoriaSolucaoService {

    private CategoriaSolucaoDao dao;

    @Override
    protected CategoriaSolucaoDao getDao() {
        if (dao == null) {
            dao = new CategoriaSolucaoDao();
        }
        return dao;
    }

    @Override
    public Collection<CategoriaSolucaoDTO> findByIdCategoriaSolucaoPai(final Integer parm) throws Exception {
        try {
            return this.getDao().findByIdCategoriaSolucaoPai(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdCategoriaSolucaoPai(final Integer parm) throws Exception {
        try {
            this.getDao().deleteByIdCategoriaSolucaoPai(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection<CategoriaSolucaoDTO> listHierarquia() throws Exception {
        final Collection<CategoriaSolucaoDTO> colFinal = new ArrayList<>();
        try {
            final Collection<CategoriaSolucaoDTO> col = this.getDao().findSemPai();
            if (col != null) {
                for (final CategoriaSolucaoDTO categoriaSolucaoDTO : col) {
                    categoriaSolucaoDTO.setNivel(0);
                    colFinal.add(categoriaSolucaoDTO);
                    final Collection<CategoriaSolucaoDTO> colAux = this.getCollectionHierarquia(categoriaSolucaoDTO.getIdCategoriaSolucao(), 0);
                    if (colAux != null && colAux.size() > 0) {
                        colFinal.addAll(colAux);
                    }
                }
            }
            return colFinal;
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection<CategoriaSolucaoDTO> getCollectionHierarquia(final Integer idCateg, final Integer nivel) throws Exception {
        final Collection<CategoriaSolucaoDTO> col = this.getDao().findByIdPai(idCateg);
        final Collection<CategoriaSolucaoDTO> colFinal = new ArrayList<>();
        if (col != null) {
            for (final CategoriaSolucaoDTO categoriaSolucaoDTO : col) {
                categoriaSolucaoDTO.setNivel(nivel + 1);
                colFinal.add(categoriaSolucaoDTO);
                final Collection<CategoriaSolucaoDTO> colAux = this.getCollectionHierarquia(categoriaSolucaoDTO.getIdCategoriaSolucao(), categoriaSolucaoDTO.getNivel());
                if (colAux != null && colAux.size() > 0) {
                    colFinal.addAll(colAux);
                }
            }
        }
        return colFinal;
    }
    
    /**
     * Quando um "Problema" foi cadastrado, sendo associado a uma "Categoria Soluo" que foi posteriormente excluda lgicamente, surgia o problema de que no era mais trazido a "Categoria Soluo"
     * associada ao "Problema". Assim, como soluo tem-se este outro mtodo, que traz todas as "Categorias Soluo" cadastradas e vlidas, seguindo as mesma regras do mtodo
     * "categoriaSolucaoServiceEjb.listHierarquia()", alm de trazer tambm apenas uma "Categoria Soluo" excluda, se houver associao.
     * 
     * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
     * @param idCategoriaSolucao
     * @return
     * @throws PersistenceException
     * @since 08/05/2015
     */
    public Collection<CategoriaSolucaoDTO> buscaCategoriasSolucoesMesmoQuandoDeleted(final Integer idCategoriaSolucao) throws Exception {
        final Collection<CategoriaSolucaoDTO> colFinal = new ArrayList<>();
        try {
            final Collection<CategoriaSolucaoDTO> col = this.getDao().findSemPaiMesmoQuandoDeleted(idCategoriaSolucao);
            if (col != null) {
                for (final CategoriaSolucaoDTO categoriaSolucaoDTO : col) {
                    categoriaSolucaoDTO.setNivel(0);
                    colFinal.add(categoriaSolucaoDTO);
                    final Collection<CategoriaSolucaoDTO> colAux = this.getCollectionHierarquiaMesmoQuandoDeleted(categoriaSolucaoDTO.getIdCategoriaSolucao(), 0);
                    if (colAux != null && colAux.size() > 0) {
                        colFinal.addAll(colAux);
                    }
                }
            }
            return colFinal;
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    /**
     * Quando um "Problema" foi cadastrado, sendo associado a uma "Categoria Soluo" que foi posteriormente excluda lgicamente, surgia o problema de que no era mais trazido a "Categoria Soluo"
     * associada ao "Problema". Assim, como soluo tem-se este outro mtodo, que traz todas as "Categorias Soluo" cadastradas e vlidas, seguindo as mesma regras do mtodo
     * "categoriaSolucaoServiceEjb.getCollectionHierarquia()", alm de trazer tambm apenas uma "Categoria Soluo" excluda, se houver associao.
     * 
     * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
     * @param idCategoriaSolucao
     * @param nivel
     * @return
     * @throws PersistenceException
     * @since 08/05/2015
     */
    public Collection<CategoriaSolucaoDTO> getCollectionHierarquiaMesmoQuandoDeleted(final Integer idCateg, final Integer nivel) throws Exception {
        final Collection<CategoriaSolucaoDTO> col = this.getDao().findByIdPaiMesmoQuandoDeleted(idCateg);
        final Collection<CategoriaSolucaoDTO> colFinal = new ArrayList<>();
        if (col != null) {
            for (final CategoriaSolucaoDTO categoriaSolucaoDTO : col) {
                categoriaSolucaoDTO.setNivel(nivel + 1);
                colFinal.add(categoriaSolucaoDTO);
                final Collection<CategoriaSolucaoDTO> colAux = this.getCollectionHierarquiaMesmoQuandoDeleted(categoriaSolucaoDTO.getIdCategoriaSolucao(), categoriaSolucaoDTO.getNivel());
                if (colAux != null && colAux.size() > 0) {
                    colFinal.addAll(colAux);
                }
            }
        }
        return colFinal;
    }

    @Override
    public String verificaDescricaoDuplicadaCategoriaAoCriar(final Map mapFields) throws Exception {
        List<CategoriaSolucaoDTO> listaCategoriaSolucao = null;
        final String descricaoCategoria = mapFields.get("DESCRICAOCATEGORIASOLUCAO").toString().trim();
        listaCategoriaSolucao = (List<CategoriaSolucaoDTO>) this.getDao().verificaDescricaoDuplicadaCategoriaAoCriar(descricaoCategoria);
        if (listaCategoriaSolucao == null || listaCategoriaSolucao.isEmpty()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String verificaDescricaoDuplicadaCategoriaAoAtualizar(final Map mapFields) throws Exception {
        List<CategoriaSolucaoDTO> listaCategoriaSolucao = null;
        final String descricaoCategoria = mapFields.get("DESCRICAOCATEGORIASOLUCAO").toString().trim();
        final String idCategoria = mapFields.get("IDCATEGORIASOLUCAO").toString().trim();
        listaCategoriaSolucao = (List<CategoriaSolucaoDTO>) this.getDao().verificaDescricaoDuplicadaCategoriaAoAtualizar(Integer.valueOf(idCategoria), descricaoCategoria);
        if (listaCategoriaSolucao == null || listaCategoriaSolucao.isEmpty()) {
            return "1";
        }
        return "0";
    }

    @Override
    public Collection<CategoriaSolucaoDTO> listaCategoriasSolucaoAtivas() throws Exception {
        return this.getDao().listaCategoriasSolucaoAtivas();
    }

}
