/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.ConhecimentoICDTO;
import br.com.centralit.citcorpore.integracao.ConhecimentoICDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

/**
 * ServiceEJB de ConhecimentoIC.
 *
 * @author rodrigo.acorse
 */
@SuppressWarnings({ "unchecked" })
public class ConhecimentoICServiceEjb extends CrudServiceImpl implements ConhecimentoICService {

	private ConhecimentoICDao dao;

	@Override
	protected ConhecimentoICDao getDao() {
		if (dao == null) {
			dao = new ConhecimentoICDao();
		}
		return dao;
	}

	@Override
	public void deleteByidItemConfiguracao(Integer parm) throws PersistenceException {
		getDao().deleteByidItemConfiguracao(parm);
	}

	@Override
	public void deleteByIdBaseConhecimento(Integer parm) throws PersistenceException {
		getDao().deleteByIdBaseConhecimento(parm);
	}

	@Override
	public Collection<ConhecimentoICDTO> findByIdBaseConhecimento(Integer parm) throws PersistenceException {
		return getDao().findByIdBaseConhecimento(parm);
	}

	@Override
	public Collection<ConhecimentoICDTO> findByidItemConfiguracao(Integer parm) throws PersistenceException {
		return getDao().findByidItemConfiguracao(parm);
	}

	@Override
	public void deleteByIdBaseConhecimentoAndIdItemConfiguracao(Integer idBaseConhecimento, Integer idItemConfiguracao)
			throws PersistenceException {
		getDao().deleteByIdBaseConhecimentoAndIdItemConfiguracao(idBaseConhecimento, idItemConfiguracao);
	}

	@Override
	public Collection<ConhecimentoICDTO> findByidItemConfiguracaoAndIdBaseConhecimento(Integer idItemConfiguracao,
			Integer idBaseConhecimento) throws PersistenceException {
		return getDao().findByidItemConfiguracaoAndIdBaseConhecimento(idItemConfiguracao, idBaseConhecimento);
	}

}
