package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.ContratoFormulaOsDTO;
import br.com.centralit.citcorpore.bean.FormulaOsDTO;
import br.com.centralit.citcorpore.integracao.ContratoFormulaOsDao;
import br.com.centralit.citcorpore.integracao.FormulaOsDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @author ibimon.morais
 * @29/09/2015
 */
@SuppressWarnings("unchecked")
public class ContratoFormulaOsServiceEjb extends CrudServiceImpl implements ContratoFormulaOsService {
	private ContratoFormulaOsDao dao;

	/**
	 * @author ibimon.morais
	 * - 30/09/2015
	 */
	@Override
	protected ContratoFormulaOsDao getDao() {
		if (this.dao == null) {
			this.dao = new ContratoFormulaOsDao();
		}
		return this.dao;
	}

	/**
	 * @author ibimon.morais
	 * - 30/09/2015
	 */
	@Override
	public ContratoFormulaOsDTO findByIdContratoIdFormula(final Integer idContrato, final Integer idFormula) throws ServiceException {
		try {
			return this.getDao().findByIdContratoIdFormula(idContrato, idFormula);
		} catch (final PersistenceException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		return null;
	}

	/**
	 * @author ibimon.morais
	 * - 30/09/2015
	 */
	@Override
	public Collection<ContratoFormulaOsDTO> findByIdContrato(final Integer idContrato) throws PersistenceException {
		try {
			final Collection<ContratoFormulaOsDTO> lista = this.getDao().findByIdContrato(idContrato);
			if (lista != null && !lista.isEmpty()) {
				final FormulaOsDao formulaOsDao = new FormulaOsDao();
				for (final ContratoFormulaOsDTO dto : lista) {
					FormulaOsDTO formulaOsDTO = new FormulaOsDTO();
					formulaOsDTO.setIdFormulaOs(dto.getIdFormulaOs());
					formulaOsDTO = (FormulaOsDTO) formulaOsDao.restore(formulaOsDTO);
					dto.setDescricao(formulaOsDTO.getDescricao());
				}
			}
			return lista;
		} catch (final PersistenceException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		return null;
	}

}
