package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.ComplexidadeDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface ContratoService extends CrudService {

	public Collection findByIdCliente(Integer parm) throws Exception;

	public Collection findByIdFornecedor(Integer parm) throws Exception;

	public Collection findByIdContrato(Integer parm) throws Exception;

	public void deleteByIdCliente(Integer parm) throws Exception;

	public boolean verificaDataFinalContrato(final HashMap mapFields);
	
	/**
	 * Retorna uma lista de complexidade de acordo com o contrato passado.
	 *
	 * @param idServicoContrato
	 * @return Collection
	 * @throws Exception
	 */
	public Collection<ComplexidadeDTO> listaComplexidadePorContrato(Integer idServicoContrato) throws Exception;

	public Collection listByIdAcordoNivelServicoAndTipo(Integer idAcordoNivelServicoParm, String tipoParm) throws Exception;

	/**
	 * Lista Contratos Ativos (Situao Ativa e DataFim maior que a data Atual).
	 *
	 * @return Collection<ContratoDTO> - Lista de Contratos Ativos.
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 30.10.2013
	 */
	public Collection<ContratoDTO> listAtivos() throws Exception;

	/**
	 * Contratos ativos pelo tipo
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato
	 * @param tipo
	 * @return
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 20.11.2015
	 */
	public Collection<ContratoDTO> listaContratosAtivosPorTipo(String tipo) throws Exception;

	public Collection findByIdGrupo(Integer idGrupo) throws Exception;

	/**
	 * Retorna a Lista de Contratos (Situao Ativa e DataFim maior que a data Atual) que esto relacionados aos Grupos informados.
	 *
	 * @param listGrupoDto
	 *            - Lista de GrupoDTO.
	 * @return Collection<ContratoDTO> - Lista de Contratos Ativos encontrados.
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 30.10.2013
	 */
	public Collection<ContratoDTO> findAtivosByGrupos(Collection<GrupoDTO> listGrupoDto) throws Exception;

	/**
	 * Retorna Lista de Contratos Ativos (Situao Ativa e DataFim maior que a data Atual) que esto relacionados aos Grupos do Empregado informado.
	 *
	 * @param idEmpregado
	 *            - Identificador do Empregado.
	 * @return Collection<ContratoDTO> - Lista de Contratos Ativos.
	 * @throws Exception
	 * @throws ServiceException
	 * @since 30.10.2013
	 */
	public Collection<ContratoDTO> findAtivosByIdEmpregado(Integer idEmpregado) throws ServiceException, Exception;

	String verificaIdCliente(HashMap mapFields) throws Exception;

	String verificaIdFornecedor(HashMap mapFields) throws Exception;

	/**
	 * Retorna a lista de Contratos com o nome da Razo Social do Cliente do Contrato.
	 *
	 * @return Collection<ContratoDTO>
	 * @throws ServiceException
	 * @throws Exception
	 * @since 04.06.2014
	 * @author valdoilo.damasceno
	 */
	public Collection<ContratoDTO> listAtivosWithNomeRazaoSocialCliente() throws ServiceException, Exception;

	public void restauraContrato(Integer idContrato, UsuarioDTO usuarioDto, DocumentHTML document, HttpServletRequest request) throws Exception;

	public Integer carregarContratos(String editar, UsuarioDTO usuario, DocumentHTML document, HttpServletRequest request) throws Exception;

	Page<ContratoDTO> listAtivosByIdServicoAndFiltro(Integer idServico, String filtro, Pageable pageable, Boolean isTotalizacao) throws Exception;

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoService.java_(#salvar)
	 * @23/09/2015
	 * @author ibimon.morais
	 */
	public ContratoDTO salvar(final Map<String, Object> parametros) throws Exception;
	
	public void removerAnexosDiretorioGed(final DocumentHTML document, ContratoDTO contratoDTO) throws PersistenceException;
}
