package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ComplexidadeDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ContratoFormulaOsDTO;
import br.com.centralit.citcorpore.bean.ContratoHistoricoDTO;
import br.com.centralit.citcorpore.bean.ContratoPerfilDTO;
import br.com.centralit.citcorpore.bean.ContratosGruposDTO;
import br.com.centralit.citcorpore.bean.ContratosUnidadesDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.MatrizContratoDTO;
import br.com.centralit.citcorpore.bean.ProdutoContratoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoContratoDao;
import br.com.centralit.citcorpore.integracao.ClienteDao;
import br.com.centralit.citcorpore.integracao.ComplexidadeDao;
import br.com.centralit.citcorpore.integracao.ContratoDao;
import br.com.centralit.citcorpore.integracao.ContratoFormulaOsDao;
import br.com.centralit.citcorpore.integracao.ContratoHistoricoDao;
import br.com.centralit.citcorpore.integracao.ContratoPerfilDao;
import br.com.centralit.citcorpore.integracao.ContratosGruposDAO;
import br.com.centralit.citcorpore.integracao.ContratosUnidadesDAO;
import br.com.centralit.citcorpore.integracao.FornecedorDao;
import br.com.centralit.citcorpore.integracao.MatrizContratoDao;
import br.com.centralit.citcorpore.integracao.ProdutoContratoDao;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ContratoServiceEjb extends CrudServiceImpl implements ContratoService {

	private ContratoDao dao;
	private ControleGEDDao controleGEDDao;
	
	private static final String DIRETORIO_PADRAO = "1";
	private static final String EXTENSAO_GED = ".ged";
	private static final String FS = System.getProperty("file.separator");
	
	@Override
	protected ContratoDao getDao() {
		if (this.dao == null) {
			this.dao = new ContratoDao();
		}
		return this.dao;
	}

	@Override
	public Collection findByIdCliente(final Integer parm) throws Exception {
		try {
			return this.getDao().findByIdCliente(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdFornecedor(final Integer parm) throws Exception {
		try {
			return this.getDao().findByIdFornecedor(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void deleteByIdCliente(final Integer parm) throws Exception {
		try {
			this.getDao().deleteByIdCliente(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdContrato(final Integer parm) throws Exception {
		try {
			return this.getDao().findByIdContrato(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<ComplexidadeDTO> listaComplexidadePorContrato(final Integer idServicoContrato) throws Exception {
		return this.getDao().listaComplexidadePorContrato(idServicoContrato);
	}

	@Override
	public Collection listByIdAcordoNivelServicoAndTipo(final Integer idAcordoNivelServicoParm, final String tipoParm) throws Exception {
		return this.getDao().listByIdAcordoNivelServicoAndTipo(idAcordoNivelServicoParm, tipoParm);
	}

	@Override
	public Collection<ContratoDTO> listAtivos() throws Exception {
		return this.getDao().listAtivos();
	}

	@Override
	public Collection findByIdGrupo(final Integer idGrupo) throws Exception {
		return this.getDao().findByIdGrupo(idGrupo);
	}

	@Override
	public Collection<ContratoDTO> findAtivosByGrupos(final Collection<GrupoDTO> listGrupoDto) throws Exception {
		return this.getDao().findAtivosByGrupos(listGrupoDto);
	}

	@Override
	public Collection<ContratoDTO> findAtivosByIdEmpregado(final Integer idEmpregado) throws ServiceException, Exception {
		return this.getDao().findAtivosByIdEmpregado(idEmpregado);
		}

	@Override
	public String verificaIdCliente(final HashMap mapFields) throws Exception {
		final ClienteDao clienteDao = new ClienteDao();
		List<ClienteDTO> listaCliente = null;
		String id = mapFields.get("IDCLIENTE").toString().trim();
		if (id == null || id.equals("")) {
			id = "0";
		}
		if (UtilStrings.soContemNumeros(id)) {
			Integer idCliente;
			idCliente = Integer.parseInt(id);
			listaCliente = clienteDao.findByIdCliente(idCliente);
		} else {
			listaCliente = clienteDao.findByRazaoSocial(id);
		}
		if (listaCliente != null && listaCliente.size() > 0) {
			return String.valueOf(listaCliente.get(0).getIdCliente());
		} else {
			return "0";
		}
	}

	@Override
	public String verificaIdFornecedor(final HashMap mapFields) throws Exception {
		final FornecedorDao fornecedorDao = new FornecedorDao();
		List<FornecedorDTO> listaFornecedor = null;
		String id = mapFields.get("IDFORNECEDOR").toString().trim();
		if (id == null || id.equals("")) {
			id = "0";
		}
		if (UtilStrings.soContemNumeros(id)) {
			final Integer idFornecedor = Integer.parseInt(id);
			listaFornecedor = fornecedorDao.findByIdFornecedor(idFornecedor);
		} else {
			listaFornecedor = fornecedorDao.findByRazaoSocial(id);
		}
		if (listaFornecedor != null && listaFornecedor.size() > 0) {
			return String.valueOf(listaFornecedor.get(0).getIdFornecedor());
		} else {
			return "0";
		}
	}

	@Override
	public Collection<ContratoDTO> listAtivosWithNomeRazaoSocialCliente() throws ServiceException, Exception {
		return this.getDao().listAtivosWithNomeRazaoSocialCliente();
	}

	/**
	 * desenvolvedor: rcs(Rafael Csar Soyer) data: 02/02/2015
	 *
	 * @author rafael.soyer
	 * @param idContrato
	 * @param request
	 * @return
	 * @throws Exception
	 */
	public String montaNomeDoContratoParaGridDePesquisa(final Integer idContrato, final HttpServletRequest request) throws Exception {

		final ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		final FornecedorService fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		final Collection contratoDaRequisicaoMudanca = this.findByIdContrato(idContrato);
		final ContratoDTO contratoDaRequisicaoMudancaDTO = (ContratoDTO) contratoDaRequisicaoMudanca.iterator().next();
		String nomeDoContrato = "";

		String nomeCliente = "";
		String nomeForn = "";
		ClienteDTO clienteDto = new ClienteDTO();
		clienteDto.setIdCliente(contratoDaRequisicaoMudancaDTO.getIdCliente());
		clienteDto = (ClienteDTO) clienteService.restore(clienteDto);

		if (clienteDto != null) {
			nomeCliente = clienteDto.getNomeRazaoSocial();
		}
		FornecedorDTO fornecedorDto = new FornecedorDTO();
		fornecedorDto.setIdFornecedor(contratoDaRequisicaoMudancaDTO.getIdFornecedor());
		fornecedorDto = (FornecedorDTO) fornecedorService.restore(fornecedorDto);

		if (fornecedorDto != null) {
			nomeForn = fornecedorDto.getRazaoSocial();
		}

		if (contratoDaRequisicaoMudancaDTO.getSituacao().equalsIgnoreCase("A")) {
			nomeDoContrato = "" + contratoDaRequisicaoMudancaDTO.getNumero() + " de "
					+ UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDaRequisicaoMudancaDTO.getDataContrato(), WebUtil.getLanguage(request)) + " (" + nomeCliente
					+ " - " + nomeForn + ")";
		}

		return nomeDoContrato;
	}

	private boolean isContratoInList(final Integer idContrato, final Collection colContratosColab) {
		if (colContratosColab != null) {
			for (final Iterator it = colContratosColab.iterator(); it.hasNext();) {
				final ContratosGruposDTO contratosGruposDTO = (ContratosGruposDTO) it.next();
				if (contratosGruposDTO.getIdContrato().intValue() == idContrato.intValue()) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public Integer carregarContratos(final String editar, final UsuarioDTO usuario, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		final HTMLSelect selectContrato = document.getSelectById("idContrato");
		Integer idContratoSelecionado = null;
		// Carrega todos os contratos permitidos, somente quando a visualizao
		// permite editar
		if (editar == null || editar.equalsIgnoreCase("") || editar.equalsIgnoreCase("S")) {
			final ContratosGruposService contratosGruposService = (ContratosGruposService) ServiceLocator.getInstance().getService(ContratosGruposService.class, null);

			final ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
			final FornecedorService fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);

			String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(
					br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

			if (COLABORADORES_VINC_CONTRATOS == null) {
				COLABORADORES_VINC_CONTRATOS = "N";
			}

			Collection colContratosColab = null;
			if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
				colContratosColab = contratosGruposService.findByIdEmpregado(usuario.getIdEmpregado());
			}

			final ArrayList<ContratoDTO> colContratos = (ArrayList<ContratoDTO>) this.listAtivos();

			selectContrato.removeAllOptions();

			if (colContratos != null) {
				if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
					if (colContratosColab != null) {
						for (Iterator<ContratoDTO> it = colContratos.iterator(); it.hasNext();) {
							ContratoDTO contratoDTO = it.next();
							if (!this.isContratoInList(contratoDTO.getIdContrato(), colContratosColab)) {
								it.remove();
							}
						}
					} else {
						colContratos.clear();
					}
				}

				if (!colContratos.isEmpty()) {
					// Requisito: Quando existir apenas um contrato, ele deve vir
					// selecionado.
					if (colContratos.size() > 1) {
						selectContrato.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
					} else {
						idContratoSelecionado = colContratos.get(0).getIdContrato();
					}

					String nomeCliente = "";
					String nomeForn = "";
					ClienteDTO clienteDto = new ClienteDTO();
					FornecedorDTO fornecedorDto = new FornecedorDTO();
					final StringBuilder nomeContrato = new StringBuilder();

					for (final ContratoDTO contratoDto : colContratos) {
						clienteDto.setIdCliente(contratoDto.getIdCliente());

						clienteDto = (ClienteDTO) clienteService.restore(clienteDto);

						if (clienteDto != null) {
							nomeCliente = clienteDto.getNomeRazaoSocial();
						}

						fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

						fornecedorDto = (FornecedorDTO) fornecedorService.restore(fornecedorDto);

						if (fornecedorDto != null) {
							nomeForn = fornecedorDto.getRazaoSocial();
						}

						if (contratoDto.getSituacao().equalsIgnoreCase("A")) {
							nomeContrato.delete(0, nomeContrato.length());
							nomeContrato.append(contratoDto.getNumero());
							nomeContrato.append(" ");
							nomeContrato.append(UtilI18N.internacionaliza(request, "citcorpore.comum.deMin"));
							nomeContrato.append(" ");
							nomeContrato.append(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), WebUtil.getLanguage(request)));
							nomeContrato.append(" (");
							nomeContrato.append(nomeCliente);
							nomeContrato.append(" - ");
							nomeContrato.append(nomeForn);
							nomeContrato.append(")");
							selectContrato.addOption(contratoDto.getIdContrato().toString(), nomeContrato.toString());
						}
					}
				} else {
					selectContrato.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
				}
			}
		}

		return idContratoSelecionado;
	}

	@Override
	public void restauraContrato(final Integer idContrato, final UsuarioDTO usuario, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		final HTMLSelect selectContrato = document.getSelectById("idContrato");
		// Carrega apenas o contrato que ser visualizado quando a tela est em
		// modo somente leitura
		if (idContrato != null && idContrato.intValue() > 0) {
			final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
			final ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
			final FornecedorService fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);

			selectContrato.removeAllOptions();

			ContratoDTO contratoDto = new ContratoDTO();
			contratoDto.setIdContrato(idContrato);
			contratoDto = (ContratoDTO) contratoService.restore(contratoDto);

			if (contratoDto != null) {
				String nomeCliente = "";

				String nomeForn = "";

				ClienteDTO clienteDto = new ClienteDTO();

				clienteDto.setIdCliente(contratoDto.getIdCliente());

				clienteDto = (ClienteDTO) clienteService.restore(clienteDto);

				if (clienteDto != null) {
					nomeCliente = clienteDto.getNomeRazaoSocial();
				}

				FornecedorDTO fornecedorDto = new FornecedorDTO();

				fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

				fornecedorDto = (FornecedorDTO) fornecedorService.restore(fornecedorDto);

				if (fornecedorDto != null) {
					nomeForn = fornecedorDto.getRazaoSocial();
				}
				final StringBuilder nomeContrato = new StringBuilder();

				nomeContrato.delete(0, nomeContrato.length());
				nomeContrato.append(contratoDto.getNumero());
				nomeContrato.append(UtilI18N.internacionaliza(request, "citcorpore.comum.deMin"));
				nomeContrato.append(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), WebUtil.getLanguage(request)));
				nomeContrato.append(" (");
				nomeContrato.append(nomeCliente);
				nomeContrato.append(" - ");
				nomeContrato.append(nomeForn);
				nomeContrato.append(")");

				selectContrato.addOption(contratoDto.getIdContrato().toString(), nomeContrato.toString());

			} else {
				selectContrato.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			}
		}
	}

	@Override
	public boolean verificaDataFinalContrato(final HashMap mapFields) {
		final String dtInicioContrato = (String) mapFields.get("DATACONTRATO");
		final String dtTerminoContrato = (String) mapFields.get("DATAFIMCONTRATO");

		Date dataInicio = null;
		Date dataFim = null;
		boolean retorno = Boolean.TRUE;

		try {
			dataInicio = new SimpleDateFormat("dd/MM/yyyy").parse(dtInicioContrato);
			dataFim = new SimpleDateFormat("dd/MM/yyyy").parse(dtTerminoContrato);

			if (dataInicio.compareTo(dataFim) > 0) {
				retorno = Boolean.FALSE;
			}

		} catch (final ParseException e) {
			e.printStackTrace();
		}

		return retorno;
	}

	@Override
	public Page<ContratoDTO> listAtivosByIdServicoAndFiltro(final Integer idServico, final String filtro, final Pageable pageable, final Boolean isTotalizacao) throws Exception {
		return this.getDao().listAtivosByIdServicoAndFiltro(idServico, filtro, pageable, isTotalizacao);
	}

	// ------------------------- Cadastrar Contrato 23/09/2015 - criacao da nova
	// tela de cadastro de contrato ibimon.morais

	/**
	 * @author ibimon.morais 24/09/2015
	 */
	@Override
	public ContratoDTO salvar(final Map<String, Object> parametros) throws Exception {
		final TransactionControler transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());
		this.getDao().setTransactionControler(transactionControler);
		ContratoDTO contrato = null;
		try {
			// Startando a transacao
			transactionControler.start();
			contrato = this.definirAcaoSalvar(parametros, transactionControler);
			
			// Comitando a transacao
			transactionControler.commit();
		} catch (final PersistenceException e) {
			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);
			transactionControler.close();
		}

		return contrato;
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( difinirAcaoSalvar)
	 *
	 * @29/09/2015
	 * @author ibimon.morais
	 * @throws Exception 
	 */
	private ContratoDTO definirAcaoSalvar(final Map<String, Object> parametros, final TransactionControler transactionControler) throws Exception {
		final ContratoDTO contrato = this.salvarContratoDTO(transactionControler, parametros);

		this.salvarAcordoNivelServicoNoContrato(transactionControler, parametros, contrato);
		this.salvarComplexidadeDoContrato(transactionControler, parametros, contrato);
		this.salvarHistoricoAuditoriaContrato(transactionControler, parametros, contrato);
		this.salvarPerfisDoContrato(transactionControler, parametros, contrato);
		this.salvarProdutoContrato(transactionControler, parametros, contrato);
		this.salvarMatrizContrato(transactionControler, parametros, contrato);
		this.salvarFormulaContrato(transactionControler, parametros, contrato);
		this.salvarContratosGrupo(transactionControler, parametros, contrato);
		this.salvarContratosUnidade(transactionControler, parametros, contrato);
		if(parametros.containsKey("listaAnexos") && contrato !=null && contrato.getIdContrato() != null){
			this.gravarAnexos(transactionControler,parametros,contrato);
		}

		return contrato;
	}
	
	private void gravarAnexos(final TransactionControler tc,final Map<String, Object> parametros, ContratoDTO contrato) throws Exception{
		this.definirTransacao(tc);
		this.tratarListaDeArquivoGED(contrato);
	}
	
	private void tratarListaDeArquivoGED(final ContratoDTO contratoDTO) throws Exception {
		final String pasta = this.definirDiretorioGed();
		//this.getControleGEDDao().deleteByIdRequisicaoLiberacao(contratoDTO.getIdContrato(), ControleGEDDTO.TABELA_CONTRATO);
		for (final UploadDTO uploadDTO : contratoDTO.getColsUploadGED()) {
			if (uploadDTO.getTemporario().equals(SimNao.SIM.getValorStr())) {
				ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

				this.definirControleGED(contratoDTO, pasta, uploadDTO, controleGEDDTO);
				this.definirPathArquivo(uploadDTO, controleGEDDTO);
				this.salvarSetarControleGED(uploadDTO, controleGEDDTO);
				this.criarGEDInternoBD(uploadDTO, controleGEDDTO);
			}
		}
	}
	
	private void definirControleGED(final ContratoDTO contratoDTO, final String pasta, final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) {
		controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_CONTRATO);
		controleGEDDTO.setId(contratoDTO.getIdContrato());
		controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
		controleGEDDTO.setDescricaoArquivo(uploadDTO.getDescricao());
		controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDTO.getNameFile()));
		controleGEDDTO.setPasta(pasta);
		controleGEDDTO.setNomeArquivo(uploadDTO.getNameFile());
	}
	
	private String definirDiretorioGed()throws Exception {
		String pasta = "";

		if (getGedInterno().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
			pasta = getControleGEDDao().getProximaPastaArmazenar();

			File fileDir = new File(getGedDiretorio());
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(pasta));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
		}

		return pasta;
	}
	private void definirTransacao(final TransactionControler tc) {
		if (tc != null) {
			getControleGEDDao().setTransactionControler(tc);
		}
	}
	
	private void definirPathArquivo(final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) {
		if (SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInterno().trim()) && SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInternoBD().trim())) {
			controleGEDDTO.setPathArquivo(uploadDTO.getPath());
		} else {
			controleGEDDTO.setPathArquivo(null);
		}
	}
	
	private void salvarSetarControleGED(final UploadDTO uploadDTO, ControleGEDDTO controleGEDDTO) throws PersistenceException {
		controleGEDDTO = (ControleGEDDTO) getControleGEDDao().create(controleGEDDTO);
		uploadDTO.setIdControleGED(controleGEDDTO.getIdControleGED());
	}
	
	private void criarGEDInternoBD(final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) throws Exception {
		if (getGedInternoBD().equalsIgnoreCase(SimNao.NAO.getValorStr())) {
			if (controleGEDDTO != null) {
				try {
					String caminho = getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS)
							.concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED()));

					final File arquivo = new File(caminho.concat(".").concat(Util.getFileExtension(uploadDTO.getNameFile())));

					CriptoUtils.encryptFile(uploadDTO.getPath(),
							caminho.concat(EXTENSAO_GED),
							((String) System.getProperties().get("user.dir")).concat(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));

					arquivo.delete();
				} catch (ClassNotFoundException | IOException | GeneralSecurityException e) {
					e.printStackTrace();
				}
			}
		}

	}
	/**
	 * projeto-missao_novo_paradigma - br.com.centralit.citcorpore.negocio -(#salvarContratosGrupo)
	 *
	 * @since 09/11/2015.
	 * @author ibimon.morais.
	 * @throws PersistenceException
	 */
	private void salvarContratosGrupo(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final ContratosGruposDAO contratosGruposDAO = new ContratosGruposDAO();
		contratosGruposDAO.setTransactionControler(transactionControler);
		final List<ContratosGruposDTO> lista = (List<ContratosGruposDTO>) parametros.get("listaDeContratosGrupos");
		if (lista != null && !lista.isEmpty()) {
			for (final ContratosGruposDTO dto : lista) {
				final ContratosGruposDTO contratosGruposDTO = new ContratosGruposDTO();
				contratosGruposDTO.setIdGrupo(dto.getIdGrupo());
				contratosGruposDTO.setIdContrato(dto.getIdContrato());
				// Verificando se existe um cadastro para esse grupo na
				// tabela contratosgrupo
				final boolean existeContratosGrupo = contratosGruposDAO.isContratosGrupoExiste(contratosGruposDTO, contrato);
				// caso ainda nao exista, o cadastro do contrato vai criar
				// um registro no banco de dados
				// Atentar para exclusao de um contrato, verificar se o
				// mesmo vai continuar vinculado ou nao.
				if (!existeContratosGrupo) {
					contratosGruposDTO.setIdContrato(contrato.getIdContrato());
					contratosGruposDAO.create(contratosGruposDTO);
				}
			}
		}
		// Tratando exclusao
		this.exclusaoContratosGrupo(contratosGruposDAO, parametros, contrato);
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - br.com.centralit.citcorpore.negocio -(#exclusaoContratosGrupo)
	 *
	 * @since 09/11/2015.
	 * @author ibimon.morais.
	 */
	private void exclusaoContratosGrupo(final ContratosGruposDAO contratosGrupoDao, final Map<String, Object> parametros, final ContratoDTO contrato) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaExclusaoDeContratosGrupos");
		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (contrato != null && contrato.getIdContrato() != null && StringUtils.isNotBlank(strItem)) {
					contratosGrupoDao.deleteByIdContratoAndIdGrupo(contrato.getIdContrato(), Integer.valueOf(strItem));
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( salvarFormulaContrato)
	 *
	 * @29/09/2015
	 * @author ibimon.morais
	 */
	private void salvarFormulaContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final ContratoFormulaOsDao formulaDao = new ContratoFormulaOsDao();
		formulaDao.setTransactionControler(transactionControler);
		// Tratando exclusao
		this.exclusaoFormulasContrato(formulaDao, parametros);
		transactionControler.commit();
		final List<ContratoFormulaOsDTO> lista = (List<ContratoFormulaOsDTO>) parametros.get("listaDeFormulasOs");
		if (lista != null && !lista.isEmpty()) {
			for (final ContratoFormulaOsDTO dto : lista) {
				if (dto.getIdContratoFormulaOs() != null) {
					final ContratoFormulaOsDTO dtoRestore = (ContratoFormulaOsDTO) formulaDao.restore(dto);
					if (dtoRestore != null && dtoRestore.getDeleted().equalsIgnoreCase("N")) {
						formulaDao.update(dto);
					}
				} else {
					dto.setIdContrato(contrato.getIdContrato());
					dto.setDeleted("N");
					formulaDao.create(dto);
				}
			}
		}
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - ContratoServiceEjb.java_(#salvarContratosUnidade).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	private void salvarContratosUnidade(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato) throws PersistenceException {
		final ContratosUnidadesDAO unidadeDao = new ContratosUnidadesDAO();
		unidadeDao.setTransactionControler(transactionControler);
		// Tratando exclusao
		final List<ContratosUnidadesDTO> lista = (List<ContratosUnidadesDTO>) parametros.get("listaDeUnidades");
		if (lista != null && !lista.isEmpty()) {
			for (final ContratosUnidadesDTO dto : lista) {
				final ContratosUnidadesDTO contratoUnidade = new ContratosUnidadesDTO();
				contratoUnidade.setIdContrato(contrato.getIdContrato());
				contratoUnidade.setIdUnidade(dto.getIdUnidade());
				// Verificando se existe um cadastro para essa unidade na
				// tabela contratosunidades
				final boolean existeUnidade = unidadeDao.isContratosUnidadeExiste(contratoUnidade, contrato);
				// caso ainda nao exista, o cadastro do contrato vai criar
				// um registro no banco de dados
				// Atentar para exclusao de um contrato, verificar se o
				// mesmo vai continuar vinculado ou nao.
				if (!existeUnidade) {
					unidadeDao.create(contratoUnidade);
				}
			}
		}
		this.exclusaoUnidadesContrato(unidadeDao, parametros, contrato);
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - ContratoServiceEjb.java_(#exclusaoUnidadesContrato).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	private void exclusaoUnidadesContrato(final ContratosUnidadesDAO unidadeDao, final Map<String, Object> parametros, final ContratoDTO contrato) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaExclusaoDeUnidades");
		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (StringUtils.isNotBlank(strItem)) {
					unidadeDao.deleteByIdContratoAndIdUnidade(contrato.getIdContrato(), Integer.valueOf(strItem));
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( exclusaoFormulasContrato)
	 *
	 * @29/09/2015
	 * @author ibimon.morais
	 */
	private void exclusaoFormulasContrato(final ContratoFormulaOsDao formulaDao, final Map<String, Object> parametros) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaFormulasDeFormulasOs");
		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (StringUtils.isNotBlank(strItem)) {
					final ContratoFormulaOsDTO contratoFormulaDTO = new ContratoFormulaOsDTO();
					contratoFormulaDTO.setIdContratoFormulaOs(Integer.valueOf(strItem));
					contratoFormulaDTO.setDeleted("Y");
					formulaDao.delete(contratoFormulaDTO);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( salvarMatrizContrato)
	 *
	 * @28/09/2015
	 * @author ibimon.morais
	 */
	private void salvarMatrizContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final MatrizContratoDao matrizContratoDao = new MatrizContratoDao();
		matrizContratoDao.setTransactionControler(transactionControler);
		// Tratando exclusao
		this.exclusaoMatrizesContrato(matrizContratoDao, parametros);
		final List<MatrizContratoDTO> lista = (List<MatrizContratoDTO>) parametros.get("listaDeMatrizes");
		if (lista != null && !lista.isEmpty()) {
			for (final MatrizContratoDTO dto : lista) {
				dto.setDeleted(null);
				if (dto.getIdMatrizComunicacao() != null && dto.getIdMatrizComunicacao().intValue() > 0) {
					matrizContratoDao.update(dto);
				} else {
					dto.setIdContrato(contrato.getIdContrato());
					matrizContratoDao.create(dto);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( exclusaoMatrizesContrato)
	 *
	 * @28/09/2015
	 * @author ibimon.morais
	 */
	private void exclusaoMatrizesContrato(final MatrizContratoDao matrizDao, final Map<String, Object> parametros) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaExclusaoDeMatriz");

		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (StringUtils.isNotBlank(strItem)) {
					final MatrizContratoDTO produto = new MatrizContratoDTO();
					produto.setIdMatrizComunicacao(Integer.valueOf(strItem));
					matrizDao.delete(produto);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( salvarProdutoContrato)
	 *
	 * @25/09/2015
	 * @author ibimon.morais
	 */
	private void salvarProdutoContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final ProdutoContratoDao produtoContratoDao = new ProdutoContratoDao();
		produtoContratoDao.setTransactionControler(transactionControler);
		// Tratando exclusao
		this.exclusaoProdutoContrato(produtoContratoDao, parametros);
		final List<ProdutoContratoDTO> lista = (List<ProdutoContratoDTO>) parametros.get("listaDeProdutos");
		if (lista != null && !lista.isEmpty()) {
			for (final ProdutoContratoDTO dto : lista) {
				dto.setDeleted(null);
				if (dto.getIdProdutoContrato() != null && dto.getIdProdutoContrato().intValue() > 0) {
					produtoContratoDao.update(dto);
				} else {
					dto.setIdContrato(contrato.getIdContrato());
					produtoContratoDao.create(dto);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( exclusaoProdutoContrato)
	 *
	 * @25/09/2015
	 * @author ibimon.morais
	 */
	private void exclusaoProdutoContrato(final ProdutoContratoDao produtoDao, final Map<String, Object> parametros) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaExclusaoDeProdutos");

		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (StringUtils.isNotBlank(strItem)) {
					final ProdutoContratoDTO produto = new ProdutoContratoDTO();
					produto.setIdProdutoContrato(Integer.valueOf(strItem));
					produtoDao.delete(produto);
				}
			}
		}
	}
	
	public void removerAnexosDiretorioGed(final DocumentHTML document, ContratoDTO contratoDTO) throws PersistenceException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			this.deletarArquivos(document, contratoDTO, tc);
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(tc, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			tc.close();
		}

	}
	
	private void deletarArquivos(final DocumentHTML document, ContratoDTO contratoDTO, final TransactionControler tc) throws Exception {
		if (contratoDTO.getColsUploadGEDExcluidos() != null && !contratoDTO.getColsUploadGEDExcluidos().isEmpty()) {
			final String gedDiretorio = this.getGedDiretorio();

			for (final String valorId : contratoDTO.getColsUploadGEDExcluidos()) {
				if (valorId.startsWith("ID=")) {
					tc.start();
					this.definirTransacao(tc);

					ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
					controleGEDDTO.setIdControleGED(this.obterIdParaExclusaoGed(valorId));
					controleGEDDTO = (ControleGEDDTO) this.getControleGEDDao().restore(controleGEDDTO);
					this.getControleGEDDao().delete(controleGEDDTO);

					final File arquivo = new File(gedDiretorio.concat(FS).concat(DIRETORIO_PADRAO).concat(FS)
							.concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED()))
							.concat(EXTENSAO_GED));

					this.deleteDir(arquivo);
					tc.commit();
				} else {
					final File arquivoTemporario = new File(valorId);

					this.deleteDir(arquivoTemporario);
				}
			}
		}
	}
	
	private Integer obterIdParaExclusaoGed(final String strParaVerificar) {
		Integer idParaExclusao = null;

		final String[] strParaVerificarArray = strParaVerificar.split("=");

		if (strParaVerificarArray[1] != null) {
			idParaExclusao = Integer.valueOf(strParaVerificarArray[1].toString());
		}

		return idParaExclusao;
	}
	
	private boolean deleteDir(final File dir) {
		if (dir.isDirectory()) {
			final String[] children = dir.list();
			for (final String element : children) {
				final boolean success = this.deleteDir(new File(dir, element));
				if (!success) {
					return false;
				}
			}
		}

		return dir.delete();
	}
	
	/**
	 * @author ibimon.morais 26/09/2015
	 */
	private ContratoDTO salvarContratoDTO(final TransactionControler transactionControler, final Map<String, Object> parametros) throws PersistenceException {
		ContratoDTO contratoDto = (ContratoDTO) parametros.get("contratoDto");
		this.getDao().setTransactionControler(transactionControler);
		if (contratoDto.getIdContrato() != null && contratoDto.getIdContrato().intValue() > 0) {
			
			this.getDao().update(contratoDto);
		} else {
			contratoDto = (ContratoDTO) this.getDao().create(contratoDto);
		}

		return contratoDto;
	}

	/**
	 * @author ibimon.morais 24/09/2015
	 */
	private void salvarAcordoNivelServicoNoContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final AcordoNivelServicoContratoDao acordoDao = new AcordoNivelServicoContratoDao();
		acordoDao.setTransactionControler(transactionControler);
		final List<AcordoNivelServicoContratoDTO> listaAcordoNivelServico = (List<AcordoNivelServicoContratoDTO>) parametros.get("listaAcordoNivelServico");
		// Tratando exclusao
		this.exclusaoAcordoNSC(acordoDao, parametros);
		if (listaAcordoNivelServico != null && !listaAcordoNivelServico.isEmpty()) {
			for (final AcordoNivelServicoContratoDTO dto : listaAcordoNivelServico) {
				dto.setDeleted(null);
				if (dto.getIdAcordoNivelServicoContrato() != null && dto.getIdAcordoNivelServicoContrato().intValue() > 0) {
					acordoDao.update(dto);
				} else {
					dto.setIdContrato(contrato.getIdContrato());
					acordoDao.create(dto);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( verificarSeExisteAcordoNSCparaExclusao)
	 *
	 * @24/09/2015
	 * @author ibimon.morais
	 */
	private void exclusaoAcordoNSC(final AcordoNivelServicoContratoDao acordoDao, final Map<String, Object> parametros) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaExclusaoAcordNSC");

		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (StringUtils.isNotBlank(strItem)) {
					final AcordoNivelServicoContratoDTO acordo = new AcordoNivelServicoContratoDTO();
					acordo.setIdAcordoNivelServicoContrato(Integer.valueOf(strItem));
					acordoDao.delete(acordo);
				}
			}
		}
	}

	/**
	 * @author ibimon.morais 24/09/2015
	 */
	private void salvarComplexidadeDoContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final ComplexidadeDao complexidadeDao = new ComplexidadeDao();
		complexidadeDao.setTransactionControler(transactionControler);
		final List<ComplexidadeDTO> listaComplexidades = (List<ComplexidadeDTO>) parametros.get("listaComplexidades");

		for (final ComplexidadeDTO dto : listaComplexidades) {
			ComplexidadeDTO complexidadeDTO = new ComplexidadeDTO();
			complexidadeDTO.setComplexidade(dto.getComplexidade());
			complexidadeDTO.setIdContrato(contrato.getIdContrato());
			complexidadeDTO = (ComplexidadeDTO) complexidadeDao.restore(complexidadeDTO);
			dto.setIdContrato(contrato.getIdContrato());

			if (complexidadeDTO != null && complexidadeDTO.getComplexidade() != null) {
				complexidadeDao.update(dto);
			} else {
				complexidadeDao.create(dto);
			}
		}
	}

	/**
	 * @author ibimon.morais 24/09/2015
	 */
	private void salvarHistoricoAuditoriaContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final ContratoHistoricoDao historicoDao = new ContratoHistoricoDao();
		historicoDao.setTransactionControler(transactionControler);
		final ContratoHistoricoDTO historico = (ContratoHistoricoDTO) parametros.get("historicoServico");
		historico.setIdContrato(contrato.getIdContrato());
		historico.setCriadoEm(UtilDatas.getDataAtual());
		historico.setModificadoEm(UtilDatas.getDataAtual());
		historicoDao.create(historico);
	}

	/**
	 * @author ibimon.morais 24/09/2015
	 */
	private void salvarPerfisDoContrato(final TransactionControler transactionControler, final Map<String, Object> parametros, final ContratoDTO contrato)
			throws PersistenceException {
		final ContratoPerfilDao perfilDao = new ContratoPerfilDao();
		perfilDao.setTransactionControler(transactionControler);
		// Tratando exclusao
		this.exclusaoPerfilContrato(perfilDao, parametros);

		final List<ContratoPerfilDTO> listaDePerfis = (List<ContratoPerfilDTO>) parametros.get("listaDePerfis");
		if (listaDePerfis != null && !listaDePerfis.isEmpty()) {
			for (final ContratoPerfilDTO perfil : listaDePerfis) {
				perfil.setIdContrato(contrato.getIdContrato());
				if (perfil.getIdPerfilContrato() != null && perfil.getIdPerfilContrato().intValue() > 0) {
					perfilDao.update(perfil);
				} else {
					perfilDao.create(perfil);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.negocio.ContratoServiceEjb.java_( exclusaoPerfilContrato)
	 *
	 * @24/09/2015
	 * @author ibimon.morais
	 */
	private void exclusaoPerfilContrato(final ContratoPerfilDao perfilDao, final Map<String, Object> parametros) throws PersistenceException {
		final List<String> listaItens = (List<String>) parametros.get("listaExclusaoPerfilContrato");

		if (listaItens != null && !listaItens.isEmpty()) {
			for (final String strItem : listaItens) {
				if (StringUtils.isNotBlank(strItem)) {
					final ContratoPerfilDTO perfil = new ContratoPerfilDTO();
					perfil.setIdPerfilContrato(Integer.valueOf(strItem));
					perfilDao.delete(perfil);
				}
			}
		}
	}

	@Override
	public Collection<ContratoDTO> listaContratosAtivosPorTipo(String tipo) throws Exception {
		return this.getDao().listaContratosAtivosPorTipo(tipo);
	}
	
	private String getGedInterno() {
		String gedInterno = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno,
				SimNao.SIM.getValorStr());

		return gedInterno;
	}
	
	private String getGedInternoBD() {
		String gedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD,
				SimNao.NAO.getValorStr());

		return gedInternoBancoDados;
	}
	
	private String getGedDiretorio() throws Exception {
		final String gedDiretorio = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "");
		if ("".equals(gedDiretorio.trim())) {
			throw new Exception("Diretrio No Informado.");
		}
		return gedDiretorio;
	}
	
	private ControleGEDDao getControleGEDDao() {
		if (controleGEDDao == null) {
			controleGEDDao = new ControleGEDDao();
		}

		return controleGEDDao;
	}
}
