package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.ContratosUnidadesDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.integracao.ContratosUnidadesDAO;
import br.com.centralit.citcorpore.integracao.UnidadeDao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public class ContratosUnidadesServiceEjb extends CrudServiceImpl implements ContratosUnidadesService {

	private ContratosUnidadesDAO dao;

	@Override
	protected ContratosUnidadesDAO getDao() {
		if (this.dao == null) {
			this.dao = new ContratosUnidadesDAO();
		}
		return this.dao;
	}

	@Override
	public Collection<ContratosUnidadesDTO> findByIdUnidade(final Integer idUnidade) throws Exception {
		try {
			return this.getDao().findByIdUnidade(idUnidade);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<ContratosUnidadesDTO> findByIdContratoCompleto(final Integer idContrato) throws Exception {
		try {
			Collection<ContratosUnidadesDTO> lista = this.getDao().findByIdContrato(idContrato);
			UnidadeDao unidadeDAO = new UnidadeDao();
			if (lista != null && !lista.isEmpty()) {
				for (ContratosUnidadesDTO dto : lista) {
					UnidadeDTO unidade = unidadeDAO.listUnidadeById(dto.getIdUnidade());
					dto.setNome(unidade.getNome().concat("  ").concat(unidade.getDataInicio() != null ? UtilDatas.dateToSTR(unidade.getDataInicio()) : ""));
				}
			}
			return lista;
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}
}
