package br.com.centralit.citcorpore.negocio;

import java.sql.Timestamp;
import java.util.List;

import br.com.centralit.citcorpore.bean.ControleSlaDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudService;

public interface ControleSlaService extends CrudService {

	ControleSlaDTO recuperarUltimoControleSla(SolicitacaoServicoDTO solicitacaoServico);

	void atualizarDadosDeTempoDeAtendimentoDaSolicitacaoDeServico(SolicitacaoServicoDTO solicitacaoServico, final TransactionControler tc);

	void registraControleSla(SolicitacaoServicoDTO solicitacaoServico, TransactionControler tc);

	ControleSlaDTO fechaUltimoControleSla(SolicitacaoServicoDTO solicitacaoServico, TransactionControler tc);

	List<ControleSlaDTO> fechaRegistrosAbertosControleSla(SolicitacaoServicoDTO solicitacaoServico, TransactionControler tc);
	
	Double obtenTempoSlaNaoContabilizado(Integer idSolicitacaoServico, Timestamp dataHoraInicioSLA);

	void calcularTempoDeAtendimento(SolicitacaoServicoDTO solicitacaoServico);

}