package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.DonoNegocioDTO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

public interface DonoNegocioService extends CrudService{
	
	Collection<DonoNegocioDTO> listByServico(Integer idServico) throws Exception;

	boolean create(List<DonoNegocioDTO> lista) throws ServiceException, LogicException;
	
	void deleteServicoDonoNegocioVinculado(Integer idServico, Integer idServicoRelacionado) throws Exception;
	
	void updateNotNull(DonoNegocioDTO donoNegocioDTO) throws Exception;
	
	public DonoNegocioDTO findServicoDonoNegocioVinculado(Integer idServico, Integer idServicoDonoNegocio) throws Exception;
	
	public Collection<DonoNegocioDTO> listByServicoAndText(Integer idServicoAtual, String text) throws Exception;
	
}