package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.DonoNegocioDTO;
import br.com.centralit.citcorpore.bean.ServicoAutoRelacionamentoDTO;
import br.com.centralit.citcorpore.integracao.DonoNegocioDAO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class DonoNegocioServiceEjb extends CrudServiceImpl implements DonoNegocioService {
	private DonoNegocioDAO dao;

	@Override
	protected DonoNegocioDAO getDao() {
		if (dao == null){
			dao = new DonoNegocioDAO();
		}
		return dao;
	}

	@Override
	public Collection<DonoNegocioDTO> listByServico(Integer idServico) throws Exception {
		return this.getDao().listByServico(idServico);
	}
	
	@Override
	public DonoNegocioDTO findServicoDonoNegocioVinculado(Integer idServico, Integer idServicoDonoNegocio) throws Exception{
		return this.getDao().findServicoDonoNegocioVinculado(idServico, idServicoDonoNegocio);
	}
	
	@Override
	public Collection<DonoNegocioDTO> listByServicoAndText(Integer idServicoAtual, String text) throws Exception{
		return this.getDao().listByServicoAndText(idServicoAtual, text);
	}
	
	@Override
    public boolean create(List<DonoNegocioDTO> lista) throws ServiceException, LogicException {
        boolean todosItensPersistidos = false;

        final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
        this.getDao().setTransactionControler(tc);

        try {
            tc.start();

            for (DonoNegocioDTO dto : lista) {
                this.validaCreate(dto);
                this.getDao().create(dto);
            }

            tc.commit();

        } catch (final Exception e) {
            e.printStackTrace();
            this.rollbackTransaction(tc, e);
        } finally {
            tc.closeQuietly();
            todosItensPersistidos = true;
        }

        return todosItensPersistidos;
    }
	
	@Override
	public void updateNotNull(DonoNegocioDTO donoNegocioDTO) throws Exception {
		this.getDao().updateNotNull(donoNegocioDTO);
	}
	
	@Override
	public void deleteServicoDonoNegocioVinculado(Integer idServico, Integer idServicoDonoNegocio) throws Exception{
		DonoNegocioDTO donoNegocioDTO = this.findServicoDonoNegocioVinculado(idServico, idServicoDonoNegocio);
		
		if(donoNegocioDTO != null){
			this.updateNotNull(donoNegocioDTO);
		}
		
	}
}