package br.com.centralit.citcorpore.negocio;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import br.com.centralit.citcorpore.bean.EventoDTO;
import br.com.centralit.citcorpore.integracao.EventosDao;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class EventosServiceEjb extends CrudServiceImpl implements EventosService {

    private EventosDao dao;

    @Override
    protected EventosDao getDao() {
        if (dao == null) {
            dao = new EventosDao();
        }
        return dao;
    }

	@Override
	public List<EventoDTO> getListEventosAvulsos(Integer idGrupoPesquisa, Integer idGrupoAtvPeriodica, String language) throws Exception {
		List<EventoDTO> listResult = new ArrayList<>();
		List<EventoDTO> listRetorno = new ArrayList<>();
		if (Enumerados.GrupoPesquisaAgendamentoAtividadePeriodica.TODOS.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			listResult = getDao().getListEventosMudanca(idGrupoPesquisa);
			trataListaEventos(listResult, listRetorno, UtilI18N.internacionaliza(language, "agendaAtvPeriodicas.reuniaoMudanca").concat(" - "), language);
			//TODO Resto
		} else if (Enumerados.GrupoPesquisaAgendamentoAtividadePeriodica.INCIDENTE.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			//TODO Incidente
		} else if (Enumerados.GrupoPesquisaAgendamentoAtividadePeriodica.MUDANCA.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			listResult = getDao().getListEventosMudanca(idGrupoPesquisa);
			trataListaEventos(listResult, listRetorno, UtilI18N.internacionaliza(language, "agendaAtvPeriodicas.reuniaoMudanca").concat(" - "), language);
		} else if (Enumerados.GrupoPesquisaAgendamentoAtividadePeriodica.LIBERACAO.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			// TODO Liberao
		} else if (Enumerados.GrupoPesquisaAgendamentoAtividadePeriodica.PROBLEMA.getIdGrupoPesquisa().equals(idGrupoPesquisa)) {
			//TODO Problema
		}

		// Atividades Peridicas
		listResult = getDao().getListEventosAtividadePeriodica(idGrupoPesquisa, idGrupoAtvPeriodica);
		trataListaEventos(listResult, listRetorno, UtilI18N.internacionaliza(language, "agendaAtvPeriodicas.reuniaoAtividadePeriodica").concat(" - "), language);

		return listRetorno;
	}

	public void trataListaEventos(List<EventoDTO> listResult, List<EventoDTO> listRetorno, String labelTitle, String language) {
		for(int i = 0; i < listResult.size(); i++){
			EventoDTO eventoDTO = listResult.get(i);
			Timestamp start = eventoDTO.getStart();
			eventoDTO.setClassName(eventoDTO.getClassName().toLowerCase());
			eventoDTO.setAllDay(false);
			if(eventoDTO != null && eventoDTO.getTitle() != null )
				eventoDTO.setTitle(labelTitle.concat(getEventoTitle(eventoDTO, language)));
			else
				eventoDTO.setTitle(labelTitle);
			try{
				Integer horas = Integer.parseInt(eventoDTO.getHoraInicio().substring(0, 2));
				start.setHours(horas);
				eventoDTO.setStart(start);
			} catch (Exception e){
			}
			listRetorno.add(eventoDTO);
		}
	}

	private String getEventoTitle(EventoDTO eventoDTO, String language) {
		if(!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(eventoDTO.getIdProblema())) {
			return UtilI18N.internacionaliza(language, "gerenciamentoDeEventos.requisicaoProblema") + " " 
					+ UtilI18N.internacionaliza(language, "citcorpore.comum.n") + " " + eventoDTO.getIdProblema();
		} else if(!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(eventoDTO.getIdRequisicaoLiberacao())) {
			return UtilI18N.internacionaliza(language, "gerenciaservico.agendaratividade.solicitacaoliberacao") +" " + eventoDTO.getIdRequisicaoLiberacao();
		} else if(!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(eventoDTO.getIdRequisicaoMudanca())) {
			return UtilI18N.internacionaliza(language, "gerenciaservico.agendaratividade.requisicaoMudanca") + " " + eventoDTO.getIdRequisicaoMudanca();
		} else if(!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(eventoDTO.getIdSolicitacaoServico())) {
			return UtilI18N.internacionaliza(language, "gerenciaservico.agendaratividade.solicitacaoincidente") + " " + eventoDTO.getIdSolicitacaoServico();
		}

		return eventoDTO.getTitle();
	}

}
