package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.enums.EvmEnumerados.Ferramentas;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudService;

/**
 * Projeto 0006 - Gerenciamento de Eventos.
 *
 * @since 26.09.2014
 * @author valdoilo.damasceno
 */
public interface EvmConexaoService extends CrudService {

	/**
	 * Restaura EvmConexaoDTO com informaes de auditoria relacionadas.
	 *
	 * @param evmConexaoDto
	 * @return EvmConexaoDTO
	 * @throws ServiceException
	 * @throws PersistenceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 10.10.2014
	 */
	public EvmConexaoDTO restoreWithInfoAudit(final EvmConexaoDTO evmConexaoDto) throws PersistenceException, ServiceException, Exception;

	/**
	 * Verifica se existe outra conexo com o mesmo nome.
	 *
	 * @param evmConexaoDto
	 * @return boolean
	 * @author valdoilo.damasceno
	 * @throws Exception
	 * @throws ServiceException
	 * @since 10.10.2014
	 */
	public boolean conexaoExiste(final EvmConexaoDTO evmConexaoDto) throws ServiceException, Exception;

	/**
	 * Realiza update dos atributos que no esto Null. Mtodo utilizado pela excluso lgica, para realizar update do campo dataHoraFim.
	 *
	 * @param evmConexaoDto
	 * @author valdoilo.damasceno
	 * @throws ServiceException
	 * @throws Exception
	 * @since 03.11.2014
	 */
	public void updateNotNull(final EvmConexaoDTO evmConexaoDto) throws ServiceException, Exception;

	/**
	 * Lista conexes ativas. Conexes que no estejam com dataHoraFim setadas.
	 *
	 * @return Collection<EvmConexaoDTO>
	 * @throws Exception
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	public Collection<EvmConexaoDTO> listarConexoesAtivas() throws ServiceException, Exception;

	/**
	 * Recupera Conexo pelo ID
	 * 
	 * @author thyen.chang
	 * @param idConexao
	 *            - Id da Conexo
	 * @return Instncia de EvmConexaoDTO, caso no existe, retorna nulo
	 * @throws Exception
	 * @since 23/02/2015
	 */
	public EvmConexaoDTO getConexaoById(Integer idConexao) throws Exception;

	/**
	 * Seta o Transaction Controller para o DAO
	 * 
	 * @author thyen.chang
	 * @since 25/02/2015
	 * @param tc
	 * @throws Exception
	 */
	public void setTransactionController(TransactionControler tc) throws Exception;

	/**
	 * Lista conexes ativas de acordo com a ferramenta informada.
	 *
	 * @return Collection<EvmConexaoDTO>
	 * @throws PersistenceException
	 * @author valdoilo.damasceno
	 * @since 01.04.2015
	 */
	public Collection<EvmConexaoDTO> findByFerramentaMonitoracao(Ferramentas ferramenta) throws PersistenceException;

	/**
	 * Lista conexes associadas a um Citsmart Event Monitor
	 *
	 * @return Collection<EvmConexaoDTO>
	 * @throws PersistenceException
	 * @author murilo.rodrigues
	 * @since 27.04.2015
	 */
	public Collection<EvmConexaoDTO> listarFerramentasAssociadasAoEventMonitor(Integer idEventMonitor) throws Exception;

	public String getFerramentaByIdConexao(Integer idConexao) throws Exception;
	
	EvmConexaoDTO getConexaoByIdConexaoEventMonitor(
			Integer idConexaoEventMonitor, String ferramenta) throws Exception;

}
