package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.integracao.EvmConexaoDAO;
import br.com.centralit.enums.EvmEnumerados.Ferramentas;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class EvmConexaoServiceEjb extends CrudServiceImpl implements EvmConexaoService {

	private EvmConexaoDAO dao;

	@Override
	protected EvmConexaoDAO getDao() {
		if (dao == null || !dao.getTransactionControler().isStarted()) {
			dao = new EvmConexaoDAO();
		}
		return dao;
	}

	@Override
	public EvmConexaoDTO restoreWithInfoAudit(final EvmConexaoDTO evmConexaoDto) throws Exception {
		return this.getDao().restoreWithInfoAudit(evmConexaoDto);
	}

	@Override
	public boolean conexaoExiste(final EvmConexaoDTO evmConexaoDto) throws ServiceException, Exception {
		return this.getDao().conexaoExiste(evmConexaoDto);
	}

	@Override
	public void updateNotNull(final EvmConexaoDTO evmConexaoDto) throws ServiceException, Exception {
		this.getDao().updateNotNull(evmConexaoDto);
	}

	@Override
	public Collection<EvmConexaoDTO> listarConexoesAtivas() throws ServiceException, Exception {
		return this.getDao().listarConexoesAtivas();
	}

	@Override
	public EvmConexaoDTO getConexaoById(Integer idConexao) throws Exception {
		Collection<EvmConexaoDTO> listaConexoes = this.getDao().getConexaoById(idConexao);
		if (listaConexoes != null && !listaConexoes.isEmpty()) {
			return new ArrayList<EvmConexaoDTO>(listaConexoes).get(0);
		}
		return null;
	}
	
	@Override
	public EvmConexaoDTO getConexaoByIdConexaoEventMonitor(Integer idConexaoEventMonitor, String ferramenta) throws Exception {
		Collection<EvmConexaoDTO> listaConexoes = this.getDao().getConexaoByIdConexaoEventMonitor(idConexaoEventMonitor, ferramenta);
		if (listaConexoes != null && !listaConexoes.isEmpty()) {
			return new ArrayList<EvmConexaoDTO>(listaConexoes).get(0);
		}
		return null;
	}
	

	@Override
	public Collection<EvmConexaoDTO> findByFerramentaMonitoracao(Ferramentas ferramenta) throws PersistenceException {
		return this.getDao().findByFerramentaMonitoracao(ferramenta);
	}

	@Override
	public Collection<EvmConexaoDTO> listarFerramentasAssociadasAoEventMonitor(Integer idEventMonitor) throws Exception {
		return this.getDao().listarFerramentasAssociadasAoEventMonitor(idEventMonitor);
	}

	@Override
	public String getFerramentaByIdConexao(Integer idConexao) throws Exception {
		return this.getDao().getFerramentaByIdConexao(idConexao);
	}
	
	@Override
	public void setTransactionController(TransactionControler tc) throws Exception {
		this.getDao().setTransactionControler(tc);
	}
}
