package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.EvmCronDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Interface Service de EvmCron.
 *
 * @author valdoilo.damasceno
 * @version 1.0
 * @created 28/10/2014
 */
public interface EvmCronService extends CrudService {

	/**
	 * Restaura EvmCronDTO com informaes de auditoria relacionadas.
	 *
	 * @param evmCronDto
	 * @return EvmCronDTO
	 * @throws ServiceException
	 * @throws PersistenceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	EvmCronDTO restoreWithInfoAudit(final EvmCronDTO evmCronDto) throws PersistenceException, ServiceException, Exception;

	/**
	 * Verifica se existe outra expresso cron com o mesmo nome ou valores.
	 *
	 * @param evmCronDto
	 * @return boolean
	 * @throws Exception
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	boolean cronExiste(final EvmCronDTO evmCronDto) throws ServiceException, Exception;

	/**
	 * Realiza update dos atributos que no esto Null. Mtodo utilizado pela excluso lgica, para realizar update do campo dataHoraFim.
	 *
	 * @param evmCronDto
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	void updateNotNull(final EvmCronDTO evmCronDto) throws ServiceException, Exception;

	/**
	 * Lista Expresses Cron Ativas. Expresses que no estejam com dataHoraFim setadas.
	 *
	 * @return Collection<EvmCronDTO>
	 * @throws Exception
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	Collection<EvmCronDTO> listarExpressoesCronAtivas() throws ServiceException, Exception;

	/**
	 * Verifica se a expressao Cron possui referencia.
	 *
	 * @param evmCronDto
	 * @return boolean
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2014
	 */
	boolean possuiRelacionamento(final EvmCronDTO evmCronDto) throws ServiceException, Exception;
}
