package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.EvmCronDTO;
import br.com.centralit.citcorpore.integracao.EvmCronDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @author valdoilo.damasceno
 * @version 1.0
 * @created 28/10/2014
 */
public class EvmCronServiceEjb extends CrudServiceImpl implements EvmCronService {

	private static final long serialVersionUID = 691866409981469644L;

	private EvmCronDAO dao;

	@Override
	protected EvmCronDAO getDao() {
		if (dao == null) {
			dao = new EvmCronDAO();
		}
		return dao;
	}

	@Override
	public EvmCronDTO restoreWithInfoAudit(final EvmCronDTO evmCronDto) throws Exception {
		return this.getDao().restoreWithInfoAudit(evmCronDto);
	}

	@Override
	public boolean cronExiste(final EvmCronDTO evmCronDto) throws ServiceException, Exception {
		return this.getDao().cronExiste(evmCronDto);
	}

	@Override
	public void updateNotNull(final EvmCronDTO evmCronDto) throws ServiceException, Exception {
		this.getDao().updateNotNull(evmCronDto);
	}

	@Override
	public Collection<EvmCronDTO> listarExpressoesCronAtivas() throws ServiceException, Exception {
		return this.getDao().listarExpressoesCronAtivas();
	}

	@Override
	public boolean possuiRelacionamento(final EvmCronDTO evmCronDto) throws Exception {
		return this.getDao().possuiRelacionamento(evmCronDto);
	}
}
