package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudService;

/**
 *
 * @author thyen.chang
 *         08/*01/15
 */
public interface EvmInventoryConfiguracaoService extends CrudService {

    EvmInventoryConfiguracaoDTO findConfiguracaoById(final Integer idConfiguracao) throws Exception;

    void updateNotNull(final EvmInventoryConfiguracaoDTO configuracaoDTO) throws ServiceException, Exception;

    boolean configuracaoExiste(final EvmInventoryConfiguracaoDTO configuracaoDTO) throws ServiceException, Exception;
    
    List<EvmInventoryConfiguracaoDTO> listInventoryAtivo() throws Exception;
    
    EvmInventoryConfiguracaoDTO getByIdInventory(final String idInventory) throws Exception;
    
    String testarConexaoInventory(final String ws_url) throws Exception;

    void setTransactionController(TransactionControler tc) throws Exception;
    
    String salvarConfiguracao(EvmInventoryConfiguracaoDTO configuracaoDTO, EvmConexaoDTO conexaoDTO, UsuarioDTO usuario) throws Exception;
    
    EvmInventoryConfiguracaoDTO findConfiguracaoByIdConexao(Integer idConexao) throws Exception;

}
