package br.com.centralit.citcorpore.negocio;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.util.List;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.EvmInventoryConfiguracaoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public class EvmInventoryConfiguracaoServiceEjb extends CrudServiceImpl implements EvmInventoryConfiguracaoService {

	private EvmInventoryConfiguracaoDAO dao;

	@Override
	protected EvmInventoryConfiguracaoDAO getDao() {
		if (dao == null || !dao.getTransactionControler().isStarted()) {
			dao = new EvmInventoryConfiguracaoDAO();
		}
		return new EvmInventoryConfiguracaoDAO();
	}

	@Override
	public EvmInventoryConfiguracaoDTO findConfiguracaoById(final Integer idConfiguracao) throws Exception {
		return this.getDao().findConfiguracaoById(idConfiguracao);
	}

	@Override
	public void updateNotNull(final EvmInventoryConfiguracaoDTO configuracaoDTO) throws ServiceException, Exception {
		this.getDao().update(configuracaoDTO);
	}

	@Override
	public boolean configuracaoExiste(final EvmInventoryConfiguracaoDTO configuracaoDTO) throws ServiceException, Exception {
		return this.getDao().configuracaoExiste(configuracaoDTO);
	}

	@Override
	public List<EvmInventoryConfiguracaoDTO> listInventoryAtivo() throws Exception {
		return this.getDao().listInventoryAtivo();
	}

	@Override
	public EvmInventoryConfiguracaoDTO getByIdInventory(String idInventory) throws Exception {
		return this.getDao().getByIdInventory(idInventory);
	}

	@Override
	public String testarConexaoInventory(String ws_url) throws Exception {
		final URL url = new URL(ws_url);
		final HttpURLConnection connection = (HttpURLConnection) url.openConnection();

		String userPassword = "ADMIN" + ":" + "1";
		String encoding = new sun.misc.BASE64Encoder().encode(userPassword.getBytes());

		connection.setRequestProperty("Authorization", "Basic " + encoding);
		connection.setRequestMethod("GET");
		connection.setRequestProperty("Content-Type", "application/json");

		connection.setDoOutput(true);
		connection.setInstanceFollowRedirects(false);

		try (final InputStreamReader is = new InputStreamReader(connection.getInputStream()); final BufferedReader br = new BufferedReader(is)) {
			return "OK";
		} catch (Exception e) {
			return e.toString();
		}
	}

	@Override
	public void setTransactionController(TransactionControler tc) throws Exception {
		this.getDao().setTransactionControler(tc);
	}

	@Override
	public String salvarConfiguracao(EvmInventoryConfiguracaoDTO configuracaoDTO, EvmConexaoDTO conexaoDTO, UsuarioDTO usuario) throws Exception {
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		tc.start();
		String retorno = "";
		try {
			EvmConexaoService conexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
			conexaoService.setTransactionController(tc);
			int portaPadraoDotNet = 7103;
			configuracaoDTO.setPortaNet(portaPadraoDotNet);
			this.setTransactionController(tc);

			if (!conexaoService.conexaoExiste(conexaoDTO) && !this.configuracaoExiste(configuracaoDTO)) {
				UtilDatas.setLocale(usuario.getLocale());
				if (conexaoDTO != null && conexaoDTO.getIdConexao() != null) {

					conexaoDTO.setIdUsuarioModificador(usuario.getIdUsuario());
					conexaoDTO.setDataHoraUltimaAlteracao(UtilDatas.getDataHoraAtual());

					conexaoService.update(conexaoDTO);
				} else {
					conexaoDTO.setIdUsuarioCriador(usuario.getIdUsuario());
					conexaoDTO.setDataHoraInicio(UtilDatas.getDataHoraAtual());

					conexaoService.create(conexaoDTO);
				}

				configuracaoDTO.setIdConexao(conexaoDTO.getIdConexao());
				if (configuracaoDTO != null) {
					if (configuracaoDTO.getIdConfiguracao() == null) {
						configuracaoDTO.setDataHoraUltimaAlteracao(new Timestamp(UtilDatas.parseDateTimeStringToDate(UtilDatas.getCurrentDateTimeString(null), null).getMillis()));
						this.create(configuracaoDTO);
						retorno = "MSG05";
					} else {
						//configuracaoDTO.setDataHoraUltimaAlteracao(UtilDatas.getDataAtual());
						this.updateNotNull(configuracaoDTO);
						retorno = "MSG06";
					}

				}

			} else {
				retorno = "citcorpore.comum.registroJaCadastrado";
			}
			tc.commit();
		} catch (Exception e) {
			tc.rollback();
		} finally {
			tc.closeQuietly();
		}
		return retorno == null || retorno.equals("") ? "MSE02" : retorno;
	}

	@Override
	public EvmInventoryConfiguracaoDTO findConfiguracaoByIdConexao(final Integer idConexao) throws Exception {
		return this.getDao().findConfiguracaoByIdConexao(idConexao);
	}

}
