package br.com.centralit.citcorpore.negocio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

import org.apache.log4j.Logger;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.metainfo.util.JSONConverter;
import br.com.centralit.citcorpore.util.IPInventario;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.CrudDAO;
import br.com.citframework.service.CrudServiceImpl;

import com.fasterxml.jackson.core.type.TypeReference;

@SuppressWarnings("unchecked")
public class EvmStatusInventoryServiceEjb extends CrudServiceImpl implements EvmStatusInventoryService {

	private static final Logger LOGGER = Logger.getLogger(EvmStatusInventoryServiceEjb.class);

	@SuppressWarnings("rawtypes")
	@Override
	protected CrudDAO getDao() {
		return null;
	}

	@Override
	public List<IPInventario> listIpsByConexao(String ws_url) throws ServiceException, Exception {
		final URL url = new URL(ws_url);
		final HttpURLConnection connection = (HttpURLConnection) url.openConnection();
		connection.setRequestMethod("GET");
		connection.setRequestProperty("Content-Type", "application/json");

		connection.setDoOutput(true);
		connection.setInstanceFollowRedirects(false);

		StringBuilder saidaDoServidor = new StringBuilder();
		
		final InputStreamReader is = new InputStreamReader(connection.getInputStream());
		final BufferedReader br = new BufferedReader(is);

		try {
			String output;
			while ((output = br.readLine()) != null) {
				saidaDoServidor.append(output);
			}

			List<IPInventario> retorno = JSONConverter.fromJson(saidaDoServidor.toString(), new TypeReference<List<IPInventario>>() {
			});

			return retorno;
		} catch (java.net.ConnectException e) {
			throw e;
		} finally {
			try {
				br.close();
				is.close();
			} catch (Exception e) {
			}
		}
	}

	@Override
	public String realizaInventarioIp(EvmInventoryConfiguracaoDTO evmInventoryConfiguracaoDTO, EvmConexaoDTO evmConexaoDTO) {
		try {
			LOGGER.info("Citsmart > Solicitando inventario ao Citsmart Inventory.");

			// TODO Adicionar mtodo de autenticao na conexo
			// final String userName = evmGerenteDTO.getEvmConexaoDto().getUsuario();
			// final String password = evmGerenteDTO.getEvmConexaoDto().getSenha();
			//
			String userPassword = "ADMIN:1";
			String encoding = new sun.misc.BASE64Encoder().encode(userPassword.getBytes());

			/**
			 * Conectando ao Citsmart Monitor
			 */
			final URL url = new URL(IPInventario.montaUrlWs(evmConexaoDTO, evmInventoryConfiguracaoDTO, "obterInventario"));
			final HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestProperty("Authorization", "Basic " + encoding);
			connection.setRequestMethod("PUT");
			connection.setRequestProperty("Content-Type", "application/json");

			connection.setDoOutput(true);
			connection.setInstanceFollowRedirects(false);

			final StringBuilder sb = new StringBuilder();

			sb.append("   {  ");
			sb.append("      \"faixa\":\"" + evmInventoryConfiguracaoDTO.getFaixaIp() + "\",");
			sb.append("      \"completo\":\"false\",");
			sb.append("      \"destinoParaEVM\":\"false\",");
			sb.append("      \"portaAgenteDotNet\":" + evmInventoryConfiguracaoDTO.getPortaNet() + ",");
			sb.append("      \"portaSNMP\":\"" + evmInventoryConfiguracaoDTO.getPortaSNMP() + "\",");
			sb.append("      \"diretorioArquivos\":\"D:\\\\Temp\\\\CITSMART_INVENTORY_\","); // <--- NO  UTILIZADO
			sb.append("      \"destino\":\"" + evmInventoryConfiguracaoDTO.getDestinoInventario() + "\"");
			sb.append("   }  ");

			try (final OutputStream os = connection.getOutputStream()) {
				os.write(sb.toString().getBytes());
				os.flush();
			}

			LOGGER.info(String.format("Citsmart > ReponseCode: %s. ResponseMessage: %s", connection.getResponseCode(), connection.getResponseMessage()));

			connection.disconnect();
		} catch (final IOException e) {
			LOGGER.warn(String.format("Citsmart > Nao foi possivel realizar a conexao com o Citsmart Inventory. Mensagem: %s.", (e.getMessage() != null ? e.getMessage() : "Nao informada")));
		}

		return null;
	}

}
