package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ExternalConnectionDTO;
import br.com.centralit.citcorpore.bean.ImportManagerDTO;
import br.com.centralit.citcorpore.metainfo.bean.CamposObjetoNegocioDTO;
import br.com.centralit.citcorpore.metainfo.bean.ObjetoNegocioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

public interface ExternalConnectionService extends CrudService {

	Collection<ObjetoNegocioDTO> getTables(final Integer idExternalConnection) throws Exception;

	Collection<ObjetoNegocioDTO> getLocalTables() throws Exception;

	Collection<CamposObjetoNegocioDTO> getFieldsTable(final Integer idExternalConnection, final String tableName) throws Exception;

	Collection<CamposObjetoNegocioDTO> getFieldsLocalTable(final String tableName) throws Exception;

	void processImport(final ImportManagerDTO importManagerDTO, final List<Object> colMatrizTratada) throws Exception;

	public boolean deletarConexao(final IDto model) throws ServiceException, Exception;

	boolean consultarConexoesAtivas(final ExternalConnectionDTO obj) throws Exception;

	Collection<ExternalConnectionDTO> seConexaoJaCadastrada(final ExternalConnectionDTO conexoesDTO) throws Exception;

	Collection<ExternalConnectionDTO> listarAtivas() throws Exception;

}
